/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;

public class DynamicResourcePack
implements IResourcePack {
    private final String packName;
    private Map<DynamicResourceKey, Supplier<InputStream>> dynamicResourceMap = new HashMap<DynamicResourceKey, Supplier<InputStream>>();

    public DynamicResourcePack(String packName) {
        this.packName = packName;
    }

    public void clear() {
        this.dynamicResourceMap.clear();
    }

    public boolean removeResource(ResourcePackType type, ResourceLocation location) {
        DynamicResourceKey key = new DynamicResourceKey(type.func_198956_a(), location.func_110624_b(), location.func_110623_a());
        if (this.dynamicResourceMap.containsKey(key)) {
            this.dynamicResourceMap.remove(key);
            return true;
        }
        return false;
    }

    public boolean registerResource(ResourcePackType type, ResourceLocation location, Supplier<InputStream> resourceSupplier) {
        return this.register(type.func_198956_a(), location.func_110624_b(), location.func_110623_a(), resourceSupplier);
    }

    public boolean registerRootResource(String path, Supplier<InputStream> resourceSupplier) {
        return this.register("root", "", path, resourceSupplier);
    }

    private boolean register(String directory, String namespace, String path, Supplier<InputStream> resourceSupplier) {
        DynamicResourceKey key = new DynamicResourceKey(directory, namespace, path);
        if (!this.dynamicResourceMap.containsKey(key)) {
            this.dynamicResourceMap.put(key, resourceSupplier);
            return true;
        }
        return false;
    }

    public InputStream func_195763_b(String path) throws IOException {
        return this.getResource("root", "", path);
    }

    public InputStream func_195761_a(ResourcePackType type, ResourceLocation location) throws IOException {
        return this.getResource(type.func_198956_a(), location.func_110624_b(), location.func_110623_a());
    }

    private InputStream getResource(String directory, String namespace, String path) throws IOException {
        DynamicResourceKey key = new DynamicResourceKey(directory, namespace, path);
        if (this.dynamicResourceMap.containsKey(key)) {
            return this.dynamicResourceMap.get(key).get();
        }
        throw new FileNotFoundException("Can't find dynamic resource " + path + ". Please ensure it has been registered.");
    }

    public Collection<ResourceLocation> func_225637_a_(ResourcePackType type, String namespace, String path, int maxDepth, Predicate<String> filter) {
        return this.dynamicResourceMap.entrySet().stream().filter(entry -> ((DynamicResourceKey)entry.getKey()).namespace.contentEquals(namespace)).filter(entry -> ((DynamicResourceKey)entry.getKey()).path.startsWith(path)).filter(entry -> ((DynamicResourceKey)entry.getKey()).type.contentEquals(type.func_198956_a())).filter(entry -> filter.test(((DynamicResourceKey)entry.getKey()).path)).map(entry -> new ResourceLocation(namespace, ((DynamicResourceKey)entry.getKey()).path)).collect(Collectors.toList());
    }

    public boolean func_195764_b(ResourcePackType type, ResourceLocation location) {
        return this.dynamicResourceMap.containsKey(new DynamicResourceKey(type.func_198956_a(), location.func_110624_b(), location.func_110623_a()));
    }

    public Set<String> func_195759_a(ResourcePackType type) {
        HashSet<String> namespaces = new HashSet<String>();
        for (DynamicResourceKey key : this.dynamicResourceMap.keySet()) {
            if (!type.func_198956_a().contentEquals(key.type)) continue;
            namespaces.add(key.namespace);
        }
        return namespaces;
    }

    public <T> T func_195760_a(IMetadataSectionSerializer<T> p_10291_) throws IOException {
        return null;
    }

    public String func_195762_a() {
        return this.packName;
    }

    public void close() {
    }

    private static class DynamicResourceKey {
        public final String type;
        public final String namespace;
        public final String path;

        public DynamicResourceKey(String type, String namespace, String path) {
            this.type = type;
            this.namespace = namespace;
            this.path = path;
        }

        public int hashCode() {
            return Objects.hash(this.type, this.namespace, this.path);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DynamicResourceKey)) {
                return false;
            }
            DynamicResourceKey other = (DynamicResourceKey)obj;
            return Objects.equals(this.type, other.type) && Objects.equals(this.namespace, other.namespace) && Objects.equals(this.path, other.path);
        }
    }
}

