/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.util;

import com.anthonyhilyard.iceberg.events.RenderTooltipExtEvent;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class Tooltips {
    public static void renderItemTooltip(@Nonnull ItemStack stack, MatrixStack matrixStack, TooltipInfo info, Rectangle2d rect, int screenWidth, int screenHeight, int backgroundColor, int borderColorStart, int borderColorEnd) {
        Tooltips.renderItemTooltip(stack, matrixStack, info, rect, screenWidth, screenHeight, backgroundColor, borderColorStart, borderColorEnd, false);
    }

    public static void renderItemTooltip(@Nonnull ItemStack stack, MatrixStack matrixStack, TooltipInfo info, Rectangle2d rect, int screenWidth, int screenHeight, int backgroundColor, int borderColorStart, int borderColorEnd, boolean comparison) {
        Tooltips.renderItemTooltip(stack, matrixStack, info, rect, screenWidth, screenHeight, backgroundColor, borderColorStart, borderColorEnd, comparison, false);
    }

    public static void renderItemTooltip(@Nonnull ItemStack stack, MatrixStack matrixStack, TooltipInfo info, Rectangle2d rect, int screenWidth, int screenHeight, int backgroundColor, int borderColorStart, int borderColorEnd, boolean comparison, boolean constrain) {
        Tooltips.renderItemTooltip(stack, matrixStack, info, rect, screenWidth, screenHeight, backgroundColor, borderColorStart, borderColorEnd, comparison, constrain, false, 0);
    }

    public static void renderItemTooltip(@Nonnull ItemStack stack, MatrixStack matrixStack, TooltipInfo info, Rectangle2d rect, int screenWidth, int screenHeight, int backgroundColor, int borderColorStart, int borderColorEnd, boolean comparison, boolean constrain, boolean centeredTitle, int index) {
        if (info.getLines().isEmpty()) {
            return;
        }
        if (centeredTitle) {
            info = new TooltipInfo(Tooltips.centerTitle(info.getLines(), info.getFont(), rect.func_199316_c()), info.getFont());
        }
        int rectX = rect.func_199318_a() - 8;
        int rectY = rect.func_199319_b() + 18;
        int maxTextWidth = rect.func_199316_c() - 8;
        RenderTooltipExtEvent.Pre event = new RenderTooltipExtEvent.Pre(stack, info.getLines(), matrixStack, rectX, rectY, screenWidth, screenHeight, maxTextWidth, info.getFont(), comparison, index);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        rectX = event.getX();
        rectY = event.getY();
        screenWidth = event.getScreenWidth();
        screenHeight = event.getScreenHeight();
        maxTextWidth = event.getMaxWidth();
        info.setFont(event.getFontRenderer());
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableDepthTest();
        int tooltipTextWidth = info.getMaxLineWidth();
        if (constrain) {
            tooltipTextWidth = Math.max(info.getMaxLineWidth(), rect.func_199316_c() - 8);
        }
        boolean needsWrap = false;
        int tooltipX = rectX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = rectX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = rectX > screenWidth / 2 ? rectX - 12 - 8 : screenWidth - 16 - rectX;
            needsWrap = true;
        }
        if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
            tooltipTextWidth = maxTextWidth;
            needsWrap = true;
        }
        if (needsWrap) {
            info.wrap(tooltipTextWidth);
            tooltipTextWidth = info.getTooltipWidth();
            tooltipX = rectX + 12;
        }
        int tooltipY = rectY - 12;
        int tooltipHeight = 8;
        if (info.getLines().size() > 1) {
            tooltipHeight += (info.getLines().size() - 1) * 10;
            if (info.getLines().size() > info.getTitleLines()) {
                tooltipHeight += 2;
            }
        }
        if (tooltipY < 4) {
            tooltipY = 4;
        } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 4;
        }
        int zLevel = 400;
        RenderTooltipExtEvent.Color colorEvent = new RenderTooltipExtEvent.Color(stack, info.getLines(), matrixStack, tooltipX, tooltipY, info.getFont(), backgroundColor, borderColorStart, borderColorEnd, comparison, index);
        MinecraftForge.EVENT_BUS.post((Event)colorEvent);
        backgroundColor = colorEvent.getBackground();
        borderColorStart = colorEvent.getBorderStart();
        borderColorEnd = colorEvent.getBorderEnd();
        matrixStack.func_227860_a_();
        Matrix4f mat = matrixStack.func_227866_c_().func_227870_a_();
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 3), (int)(tooltipY - 4), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 4), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 4), (int)(tooltipY - 3), (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 4), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 3), (int)(tooltipY - 3 + 1), (int)(tooltipX - 3 + 1), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX + tooltipTextWidth + 2), (int)(tooltipY - 3 + 1), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3 + 1), (int)borderColorStart, (int)borderColorStart);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 2), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)borderColorEnd, (int)borderColorEnd);
        MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipExtEvent.PostBackground(stack, info.getLines(), matrixStack, tooltipX, tooltipY, info.getFont(), tooltipTextWidth, tooltipHeight, comparison, index));
        IRenderTypeBuffer.Impl renderType = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        matrixStack.func_227861_a_(0.0, 0.0, 400.0);
        int tooltipTop = tooltipY;
        for (int lineNumber = 0; lineNumber < info.getLines().size(); ++lineNumber) {
            ITextProperties line = info.getLines().get(lineNumber);
            if (line != null) {
                info.getFont().func_238416_a_(LanguageMap.func_74808_a().func_241870_a(line), (float)tooltipX, (float)tooltipY, -1, true, mat, (IRenderTypeBuffer)renderType, false, 0, 0xF000F0);
            }
            if (lineNumber + 1 == info.getTitleLines()) {
                tooltipY += 2;
            }
            tooltipY += 10;
        }
        renderType.func_228461_a_();
        matrixStack.func_227865_b_();
        MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipExtEvent.PostText(stack, info.getLines(), matrixStack, tooltipX, tooltipTop, info.getFont(), tooltipTextWidth, tooltipHeight, comparison, index));
        RenderSystem.enableDepthTest();
        RenderSystem.enableRescaleNormal();
    }

    public static Rectangle2d calculateRect(ItemStack stack, MatrixStack matrixStack, List<? extends ITextProperties> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, FontRenderer font) {
        return Tooltips.calculateRect(stack, matrixStack, textLines, mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, font, 0, false);
    }

    public static Rectangle2d calculateRect(ItemStack stack, MatrixStack matrixStack, List<? extends ITextProperties> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, FontRenderer font, int minWidth, boolean centeredTitle) {
        int n;
        Rectangle2d rect = new Rectangle2d(0, 0, 0, 0);
        if (textLines == null || textLines.isEmpty() || stack == null) {
            return rect;
        }
        RenderTooltipEvent.Pre event = new RenderTooltipEvent.Pre(stack, textLines, matrixStack, mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, font);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return rect;
        }
        mouseX = event.getX();
        mouseY = event.getY();
        screenWidth = event.getScreenWidth();
        screenHeight = event.getScreenHeight();
        maxTextWidth = event.getMaxWidth();
        font = event.getFontRenderer();
        int tooltipTextWidth = minWidth;
        if (centeredTitle) {
            textLines = Tooltips.centerTitle(textLines, font, minWidth);
        }
        for (ITextProperties iTextProperties : textLines) {
            int textLineWidth = font.func_238414_a_(iTextProperties);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        boolean needsWrap = false;
        boolean bl = true;
        int tooltipX = mouseX + 14;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 14 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
            tooltipTextWidth = maxTextWidth;
            needsWrap = true;
        }
        if (needsWrap) {
            int wrappedTooltipWidth = 0;
            ArrayList<? extends ITextProperties> wrappedTextLines = new ArrayList<ITextProperties>();
            for (int i = 0; i < textLines.size(); ++i) {
                ITextProperties textLine = textLines.get(i);
                List wrappedLine = font.func_238420_b_().func_238362_b_(textLine, tooltipTextWidth, Style.field_240709_b_);
                if (i == 0) {
                    n = wrappedLine.size();
                }
                for (ITextProperties line : wrappedLine) {
                    int lineWidth = font.func_238414_a_(line);
                    if (lineWidth > wrappedTooltipWidth) {
                        wrappedTooltipWidth = lineWidth;
                    }
                    wrappedTextLines.add((ITextProperties)line);
                }
            }
            tooltipTextWidth = wrappedTooltipWidth;
            textLines = wrappedTextLines;
            tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 14;
        }
        int tooltipY = mouseY - 14;
        int tooltipHeight = 8;
        if (textLines.size() > 1) {
            tooltipHeight += (textLines.size() - 1) * 10;
            if (textLines.size() > n) {
                tooltipHeight += 2;
            }
        }
        if (tooltipY < 4) {
            tooltipY = 4;
        } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 4;
        }
        rect = new Rectangle2d(tooltipX - 4, tooltipY - 4, tooltipTextWidth + 8, tooltipHeight + 8);
        return rect;
    }

    /*
     * WARNING - void declaration
     */
    public static List<? extends ITextProperties> centerTitle(List<? extends ITextProperties> textLines, FontRenderer font, int minWidth) {
        int tooltipWidth = minWidth;
        for (ITextProperties iTextProperties : textLines) {
            if (iTextProperties == null) {
                return textLines;
            }
            int textLineWidth = font.func_238414_a_(iTextProperties);
            if (textLineWidth <= tooltipWidth) continue;
            tooltipWidth = textLineWidth;
        }
        ArrayList<? extends ITextProperties> result = new ArrayList<ITextProperties>(textLines);
        ITextComponent iTextComponent = (ITextComponent)textLines.get(0);
        if (iTextComponent != null) {
            void var5_7;
            IFormattableTextComponent iFormattableTextComponent;
            while (font.func_238414_a_((ITextProperties)result.get(0)) < tooltipWidth && (iFormattableTextComponent = new StringTextComponent(" ").func_230529_a_((ITextComponent)var5_7).func_240702_b_(" ")) != null) {
                result.set(0, (ITextProperties)new StringTextComponent("").func_230529_a_((ITextComponent)iFormattableTextComponent));
            }
        }
        return result;
    }

    public static class TooltipInfo {
        private int tooltipWidth = 0;
        private int titleLines = 1;
        private FontRenderer font;
        private List<? extends ITextProperties> lines = new ArrayList<ITextProperties>();

        public TooltipInfo(List<? extends ITextProperties> lines, FontRenderer font) {
            this.lines = lines;
            this.font = font;
        }

        public int getTooltipWidth() {
            return this.tooltipWidth;
        }

        public int getTitleLines() {
            return this.titleLines;
        }

        public FontRenderer getFont() {
            return this.font;
        }

        public List<? extends ITextProperties> getLines() {
            return this.lines;
        }

        public void setFont(FontRenderer font) {
            this.font = font;
        }

        public int getMaxLineWidth() {
            int textWidth = 0;
            for (ITextProperties iTextProperties : this.lines) {
                int textLineWidth = this.font.func_238414_a_(iTextProperties);
                if (textLineWidth <= textWidth) continue;
                textWidth = textLineWidth;
            }
            return textWidth;
        }

        public void wrap(int maxWidth) {
            this.tooltipWidth = 0;
            ArrayList<? extends ITextProperties> wrappedLines = new ArrayList<ITextProperties>();
            for (int i = 0; i < this.lines.size(); ++i) {
                ITextProperties textLine = this.lines.get(i);
                List wrappedLine = this.font.func_238420_b_().func_238362_b_(textLine, maxWidth, Style.field_240709_b_);
                if (i == 0) {
                    this.titleLines = wrappedLine.size();
                }
                for (ITextProperties line : wrappedLine) {
                    int lineWidth = this.font.func_238414_a_(line);
                    if (lineWidth > this.tooltipWidth) {
                        this.tooltipWidth = lineWidth;
                    }
                    wrappedLines.add((ITextProperties)line);
                }
            }
            this.lines = wrappedLines;
        }
    }
}

