/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity.layer;

import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.TabulaModel;
import com.github.alexthe666.iceandfire.ClientProxy;
import com.github.alexthe666.iceandfire.entity.DragonType;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityDreadQueen;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.HorseModel;
import net.minecraft.client.renderer.entity.model.QuadrupedModel;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LayerDragonRider
extends LayerRenderer<EntityDragonBase, SegmentedModel<EntityDragonBase>> {
    private final MobRenderer render;
    private final boolean excludeDreadQueenMob;

    public LayerDragonRider(MobRenderer renderIn, boolean excludeDreadQueenMob) {
        super((IEntityRenderer)renderIn);
        this.render = renderIn;
        this.excludeDreadQueenMob = excludeDreadQueenMob;
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, EntityDragonBase dragon, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        matrixStackIn.func_227860_a_();
        if (!dragon.func_184188_bt().isEmpty()) {
            float dragonScale = dragon.getRenderSize() / 3.0f;
            for (Entity passenger : dragon.func_184188_bt()) {
                boolean prey;
                boolean bl = prey = dragon.func_184179_bs() == null || dragon.func_184179_bs().func_145782_y() != passenger.func_145782_y();
                if (this.excludeDreadQueenMob && passenger instanceof EntityDreadQueen) {
                    prey = false;
                }
                ClientProxy.currentDragonRiders.remove(passenger.func_110124_au());
                float riderRot = passenger.field_70126_B + (passenger.field_70177_z - passenger.field_70126_B) * partialTicks;
                int animationTicks = 0;
                if (dragon.getAnimation() == EntityDragonBase.ANIMATION_SHAKEPREY) {
                    animationTicks = dragon.getAnimationTick();
                }
                if (animationTicks == 0 || animationTicks >= 15) {
                    this.translateToBody(matrixStackIn);
                }
                if (prey) {
                    if (animationTicks == 0 || animationTicks >= 15 || dragon.isFlying()) {
                        this.translateToHead(matrixStackIn);
                        this.offsetPerDragonType(dragon.dragonType, matrixStackIn);
                        EntityRenderer render = Minecraft.func_71410_x().func_175598_ae().func_78713_a(passenger);
                        EntityModel modelBase = null;
                        if (render instanceof MobRenderer) {
                            modelBase = ((MobRenderer)render).func_217764_d();
                        }
                        if ((passenger.func_213302_cg() > passenger.func_213311_cf() || modelBase instanceof BipedModel) && !(modelBase instanceof QuadrupedModel) && !(modelBase instanceof HorseModel)) {
                            matrixStackIn.func_227861_a_((double)(-0.15f * passenger.func_213302_cg()), (double)(0.1f * dragonScale - 0.1f * passenger.func_213302_cg()), (double)(-0.1f * dragonScale - 0.1f * passenger.func_213311_cf()));
                            matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229183_f_, 90.0f, true));
                            matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, 45.0f, true));
                        } else {
                            boolean horse = modelBase instanceof HorseModel;
                            matrixStackIn.func_227861_a_((double)((horse ? -0.08f : -0.15f) * passenger.func_213311_cf()), (double)(0.1f * dragonScale - 0.15f * passenger.func_213311_cf()), (double)(-0.1f * dragonScale - 0.1f * passenger.func_213311_cf()));
                            matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229178_a_, 90.0f, true));
                        }
                    } else {
                        matrixStackIn.func_227861_a_(0.0, (double)(0.555f * dragonScale), (double)(-0.5f * dragonScale));
                    }
                } else {
                    matrixStackIn.func_227861_a_(0.0, (double)(-0.01f * dragonScale), (double)(-0.035f * dragonScale));
                }
                matrixStackIn.func_227860_a_();
                matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229183_f_, 180.0f, true));
                matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, riderRot + 180.0f, true));
                matrixStackIn.func_227862_a_(1.0f / dragonScale, 1.0f / dragonScale, 1.0f / dragonScale);
                matrixStackIn.func_227861_a_(0.0, -0.25, 0.0);
                this.renderEntity(passenger, 0.0, 0.0, 0.0, 0.0f, partialTicks, matrixStackIn, bufferIn, packedLightIn);
                matrixStackIn.func_227865_b_();
                ClientProxy.currentDragonRiders.add(passenger.func_110124_au());
            }
        }
        matrixStackIn.func_227865_b_();
    }

    protected void translateToBody(MatrixStack stack) {
        this.postRender(((TabulaModel)this.render.func_217764_d()).getCube("BodyUpper"), stack, 0.0625f);
        this.postRender(((TabulaModel)this.render.func_217764_d()).getCube("Neck1"), stack, 0.0625f);
    }

    protected void translateToHead(MatrixStack stack) {
        this.postRender(((TabulaModel)this.render.func_217764_d()).getCube("Neck2"), stack, 0.0625f);
        this.postRender(((TabulaModel)this.render.func_217764_d()).getCube("Neck3"), stack, 0.0625f);
        this.postRender(((TabulaModel)this.render.func_217764_d()).getCube("Head"), stack, 0.0625f);
    }

    protected void postRender(AdvancedModelBox renderer, MatrixStack matrixStackIn, float scale) {
        if (renderer.field_78795_f == 0.0f && renderer.field_78796_g == 0.0f && renderer.field_78808_h == 0.0f) {
            if (renderer.field_78800_c != 0.0f || renderer.field_78797_d != 0.0f || renderer.field_78798_e != 0.0f) {
                matrixStackIn.func_227861_a_((double)(renderer.field_78800_c * scale), (double)(renderer.field_78797_d * scale), (double)(renderer.field_78798_e * scale));
            }
        } else {
            matrixStackIn.func_227861_a_((double)(renderer.field_78800_c * scale), (double)(renderer.field_78797_d * scale), (double)(renderer.field_78798_e * scale));
            if (renderer.field_78808_h != 0.0f) {
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(renderer.field_78808_h));
            }
            if (renderer.field_78796_g != 0.0f) {
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(renderer.field_78796_g));
            }
            if (renderer.field_78795_f != 0.0f) {
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(renderer.field_78795_f));
            }
        }
    }

    private void offsetPerDragonType(DragonType dragonType, MatrixStack stackIn) {
        if (dragonType == DragonType.LIGHTNING) {
            stackIn.func_227861_a_((double)0.1f, (double)-0.2f, (double)-0.1f);
        }
    }

    public <E extends Entity> void renderEntity(E entityIn, double x, double y, double z, float yaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int packedLight) {
        block4: {
            EntityRenderer render = null;
            EntityRendererManager manager = Minecraft.func_71410_x().func_175598_ae();
            try {
                render = manager.func_78713_a(entityIn);
                if (render == null) break block4;
                try {
                    render.func_225623_a_(entityIn, 0.0f, partialTicks, matrixStack, bufferIn, packedLight);
                }
                catch (Throwable throwable1) {
                    throw new ReportedException(CrashReport.func_85055_a((Throwable)throwable1, (String)"Rendering entity in world"));
                }
            }
            catch (Throwable throwable3) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable3, (String)"Rendering entity in world");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being rendered");
                entityIn.func_85029_a(crashreportcategory);
                CrashReportCategory crashreportcategory1 = crashreport.func_85058_a("Renderer details");
                crashreportcategory1.func_71507_a("Assigned renderer", (Object)render);
                crashreportcategory1.func_71507_a("Location", (Object)CrashReportCategory.func_85074_a((double)x, (double)y, (double)z));
                crashreportcategory1.func_71507_a("Rotation", (Object)Float.valueOf(yaw));
                crashreportcategory1.func_71507_a("Delta", (Object)Float.valueOf(partialTicks));
                throw new ReportedException(crashreport);
            }
        }
    }

    public boolean shouldCombineTextures() {
        return false;
    }
}

