/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityStoneStatue;
import com.github.alexthe666.iceandfire.entity.ai.GorgonAIStareAttack;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.util.IBlacklistedFromStatues;
import com.github.alexthe666.iceandfire.entity.util.IHumanoid;
import com.github.alexthe666.iceandfire.entity.util.IVillagerFear;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.misc.IafDamageRegistry;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import io.netty.buffer.Unpooled;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FleeSunGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RestrictSunGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityGorgon
extends MonsterEntity
implements IAnimatedEntity,
IVillagerFear,
IAnimalFear,
IHumanoid {
    public static Animation ANIMATION_SCARE;
    public static Animation ANIMATION_HIT;
    private int animationTick;
    private Animation currentAnimation;
    private GorgonAIStareAttack aiStare;
    private MeleeAttackGoal aiMelee;
    private int playerStatueCooldown;

    public EntityGorgon(EntityType type, World worldIn) {
        super(type, worldIn);
        ANIMATION_SCARE = Animation.create((int)30);
        ANIMATION_HIT = Animation.create((int)10);
    }

    public static boolean isEntityLookingAt(LivingEntity looker, LivingEntity seen, double degree) {
        Vector3d Vector3d2 = looker.func_70676_i(1.0f).func_72432_b();
        Vector3d Vector3d1 = new Vector3d(seen.func_226277_ct_() - looker.func_226277_ct_(), seen.func_174813_aQ().field_72338_b + (double)seen.func_70047_e() - (looker.func_226278_cu_() + (double)looker.func_70047_e()), seen.func_226281_cx_() - looker.func_226281_cx_());
        double d0 = Vector3d1.func_72433_c();
        double d1 = Vector3d2.func_72430_b(Vector3d1 = Vector3d1.func_72432_b());
        return d1 > 1.0 - (degree *= 1.0 + (double)looker.func_70032_d((Entity)seen) * 0.1) / d0 && looker.func_70685_l((Entity)seen) && !EntityGorgon.isStoneMob(seen);
    }

    public static boolean isStoneMob(LivingEntity mob) {
        return mob instanceof EntityStoneStatue;
    }

    public static boolean isBlindfolded(LivingEntity attackTarget) {
        return attackTarget != null && (attackTarget.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == IafItemRegistry.BLINDFOLD || attackTarget.func_70644_a(Effects.field_76440_q));
    }

    public boolean isTargetBlocked(Vector3d target) {
        Vector3d Vector3d2 = new Vector3d(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
        BlockRayTraceResult result = this.field_70170_p.func_217299_a(new RayTraceContext(Vector3d2, target, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
        return result.func_216346_c() != RayTraceResult.Type.MISS;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new RestrictSunGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FleeSunGoal((CreatureEntity)this, 1.0));
        this.aiStare = new GorgonAIStareAttack(this, 1.0, 0, 15.0f);
        this.field_70714_bg.func_75776_a(3, (Goal)this.aiStare);
        this.aiMelee = new MeleeAttackGoal((CreatureEntity)this, 1.0, false);
        this.field_70714_bg.func_75776_a(3, (Goal)this.aiMelee);
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0){

            public boolean func_75250_a() {
                this.field_179481_f = 20;
                return super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f, 1.0f){

            public boolean func_75253_b() {
                if (this.field_75334_a != null && this.field_75334_a instanceof PlayerEntity && ((PlayerEntity)this.field_75334_a).func_184812_l_()) {
                    return false;
                }
                return super.func_75253_b();
            }
        });
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 0, false, false, (Predicate)new com.google.common.base.Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity.func_70089_S();
            }
        }));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 0, true, false, (Predicate)new com.google.common.base.Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity instanceof LivingEntity && DragonUtils.isAlive((LivingEntity)entity) || entity instanceof IBlacklistedFromStatues && ((IBlacklistedFromStatues)entity).canBeTurnedToStone();
            }
        }));
        this.field_70714_bg.func_85156_a((Goal)this.aiMelee);
    }

    public void attackEntityWithRangedAttack(LivingEntity entity) {
        if (!(entity instanceof MobEntity) && entity instanceof LivingEntity) {
            this.forcePreyToLook((LivingEntity)((MobEntity)entity));
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean blindness;
        boolean bl = blindness = this.func_70644_a(Effects.field_76440_q) || this.func_70638_az() != null && this.func_70638_az().func_70644_a(Effects.field_76440_q) || this.func_70638_az() != null && this.func_70638_az() instanceof IBlacklistedFromStatues && !((IBlacklistedFromStatues)this.func_70638_az()).canBeTurnedToStone();
        if (blindness && this.field_70725_aQ == 0) {
            if (this.getAnimation() != ANIMATION_HIT) {
                this.setAnimation(ANIMATION_HIT);
            }
            if (entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76436_u, 100, 2, false, true));
            }
        }
        return super.func_70652_k(entityIn);
    }

    public void func_70624_b(@Nullable LivingEntity LivingEntityIn) {
        super.func_70624_b(LivingEntityIn);
        if (LivingEntityIn != null && !this.field_70170_p.field_72995_K) {
            boolean blindness;
            boolean bl = blindness = this.func_70644_a(Effects.field_76440_q) || LivingEntityIn.func_70644_a(Effects.field_76440_q) || LivingEntityIn instanceof IBlacklistedFromStatues && !((IBlacklistedFromStatues)LivingEntityIn).canBeTurnedToStone() || EntityGorgon.isBlindfolded(LivingEntityIn);
            if (blindness && this.field_70725_aQ == 0) {
                this.field_70714_bg.func_75776_a(3, (Goal)this.aiMelee);
                this.field_70714_bg.func_85156_a((Goal)this.aiStare);
            } else {
                this.field_70714_bg.func_75776_a(3, (Goal)this.aiStare);
                this.field_70714_bg.func_85156_a((Goal)this.aiMelee);
            }
        }
    }

    protected int func_70693_a(PlayerEntity player) {
        return 30;
    }

    protected void func_70609_aI() {
        double d1;
        double d0;
        int k;
        ++this.field_70725_aQ;
        this.field_70757_a = 20;
        if (this.field_70170_p.field_72995_K) {
            for (k = 0; k < 5; ++k) {
                double d2 = 0.4;
                d0 = 0.1;
                d1 = 0.1;
                IceAndFire.PROXY.spawnParticle("blood", this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_(), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d2, d0, d1);
            }
        }
        if (this.field_70725_aQ >= 200) {
            if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g))) {
                int j;
                int i = this.func_70693_a(this.field_70717_bb);
                for (i = ForgeEventFactory.getExperienceDrop((LivingEntity)this, (PlayerEntity)this.field_70717_bb, (int)i); i > 0; i -= j) {
                    j = ExperienceOrbEntity.func_70527_a((int)i);
                    this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), j));
                }
            }
            this.func_70106_y();
            for (k = 0; k < 20; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                d0 = this.field_70146_Z.nextGaussian() * 0.02;
                d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197613_f, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d2, d0, d1);
            }
        }
    }

    public void func_70636_d() {
        boolean blindness;
        super.func_70636_d();
        if (this.playerStatueCooldown > 0) {
            --this.playerStatueCooldown;
        }
        if (this.func_70638_az() != null) {
            boolean bl = blindness = this.func_70644_a(Effects.field_76440_q) || this.func_70638_az().func_70644_a(Effects.field_76440_q);
            if (!blindness && this.field_70725_aQ == 0 && this.func_70638_az() instanceof MobEntity && !(this.func_70638_az() instanceof PlayerEntity)) {
                this.forcePreyToLook((LivingEntity)((MobEntity)this.func_70638_az()));
            }
            if (EntityGorgon.isEntityLookingAt(this.func_70638_az(), (LivingEntity)this, 0.4)) {
                this.func_70671_ap().func_75650_a(this.func_70638_az().func_226277_ct_(), this.func_70638_az().func_226278_cu_() + (double)this.func_70638_az().func_70047_e(), this.func_70638_az().func_226281_cx_(), (float)this.func_184649_cE(), (float)this.func_70646_bf());
            }
        }
        if (this.func_70638_az() != null && EntityGorgon.isEntityLookingAt((LivingEntity)this, this.func_70638_az(), 0.4) && EntityGorgon.isEntityLookingAt(this.func_70638_az(), (LivingEntity)this, 0.4) && !EntityGorgon.isBlindfolded(this.func_70638_az())) {
            boolean bl = blindness = this.func_70644_a(Effects.field_76440_q) || this.func_70638_az().func_70644_a(Effects.field_76440_q) || this.func_70638_az() instanceof IBlacklistedFromStatues && !((IBlacklistedFromStatues)this.func_70638_az()).canBeTurnedToStone();
            if (!blindness && this.field_70725_aQ == 0) {
                if (this.getAnimation() != ANIMATION_SCARE) {
                    this.func_184185_a(IafSoundRegistry.GORGON_ATTACK, 1.0f, 1.0f);
                    this.setAnimation(ANIMATION_SCARE);
                }
                if (this.getAnimation() == ANIMATION_SCARE && this.getAnimationTick() > 10 && !this.field_70170_p.field_72995_K && this.playerStatueCooldown == 0) {
                    EntityStoneStatue statue = EntityStoneStatue.buildStatueEntity(this.func_70638_az());
                    try {
                        PacketBuffer testPacket = new PacketBuffer(Unpooled.buffer());
                        testPacket.func_150786_a(statue.serializeNBT());
                        testPacket.func_150793_b();
                        statue.func_70080_a(this.func_70638_az().func_226277_ct_(), this.func_70638_az().func_226278_cu_(), this.func_70638_az().func_226281_cx_(), this.func_70638_az().field_70177_z, this.func_70638_az().field_70125_A);
                        if (!this.field_70170_p.field_72995_K) {
                            this.field_70170_p.func_217376_c((Entity)statue);
                        }
                        statue.field_70126_B = this.func_70638_az().field_70177_z;
                        statue.field_70177_z = this.func_70638_az().field_70177_z;
                        statue.field_70759_as = this.func_70638_az().field_70177_z;
                        statue.field_70761_aq = this.func_70638_az().field_70177_z;
                        statue.field_70760_ar = this.func_70638_az().field_70177_z;
                        this.playerStatueCooldown = 40;
                    }
                    catch (Exception ex) {
                        IceAndFire.LOGGER.debug("Tried to create a stone statue with too much NBT data {}", (Object)ex.toString());
                    }
                    if (this.func_70638_az() instanceof PlayerEntity) {
                        this.func_70638_az().func_70097_a(IafDamageRegistry.GORGON_DMG, 2.1474836E9f);
                    } else {
                        this.func_70638_az().func_70106_y();
                    }
                    this.func_70624_b(null);
                }
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public int func_70646_bf() {
        return 10;
    }

    public int func_184649_cE() {
        return 30;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    public void forcePreyToLook(LivingEntity mob) {
        if (mob instanceof MobEntity) {
            MobEntity mobEntity = (MobEntity)mob;
            mobEntity.func_70671_ap().func_75650_a(this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_70047_e(), this.func_226281_cx_(), (float)mobEntity.func_184649_cE(), (float)mobEntity.func_70646_bf());
        }
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, IafConfig.gorgonMaxHealth).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233826_i_, 1.0);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_SCARE, ANIMATION_HIT};
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return IafSoundRegistry.GORGON_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return IafSoundRegistry.GORGON_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return IafSoundRegistry.GORGON_DIE;
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return true;
    }

    public boolean func_104002_bU() {
        return true;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }
}

