/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.entity.EntityHippogryph;
import com.github.alexthe666.iceandfire.entity.ai.DragonAITargetItems;
import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;

public class HippogryphAITargetItems<T extends ItemEntity>
extends TargetGoal {
    protected final DragonAITargetItems.Sorter theNearestAttackableTargetSorter;
    protected final Predicate<? super ItemEntity> targetEntitySelector;
    private final int targetChance;
    protected ItemEntity targetEntity;

    public HippogryphAITargetItems(MobEntity creature, boolean checkSight) {
        this(creature, checkSight, false);
    }

    public HippogryphAITargetItems(MobEntity creature, boolean checkSight, boolean onlyNearby) {
        this(creature, 20, checkSight, onlyNearby, null);
    }

    public HippogryphAITargetItems(MobEntity creature, int chance, boolean checkSight, boolean onlyNearby, @Nullable Predicate<? super T> targetSelector) {
        super(creature, checkSight, onlyNearby);
        this.targetChance = chance;
        this.theNearestAttackableTargetSorter = new DragonAITargetItems.Sorter((Entity)creature);
        this.targetEntitySelector = new Predicate<ItemEntity>(){

            public boolean apply(@Nullable ItemEntity item) {
                return item instanceof ItemEntity && !item.func_92059_d().func_190926_b() && item.func_92059_d().func_77973_b() == Items.field_179556_br;
            }
        };
    }

    public boolean func_75250_a() {
        if (!((EntityHippogryph)this.field_75299_d).canMove()) {
            return false;
        }
        List list = this.field_75299_d.field_70170_p.func_175647_a(ItemEntity.class, this.getTargetableArea(this.func_111175_f()), this.targetEntitySelector);
        if (list.isEmpty()) {
            return false;
        }
        Collections.sort(list, this.theNearestAttackableTargetSorter);
        this.targetEntity = (ItemEntity)list.get(0);
        return true;
    }

    protected AxisAlignedBB getTargetableArea(double targetDistance) {
        return this.field_75299_d.func_174813_aQ().func_72314_b(targetDistance, 4.0, targetDistance);
    }

    public void func_75249_e() {
        this.field_75299_d.func_70661_as().func_75492_a(this.targetEntity.func_226277_ct_(), this.targetEntity.func_226278_cu_(), this.targetEntity.func_226281_cx_(), 1.0);
        super.func_75249_e();
    }

    public void func_75246_d() {
        super.func_75246_d();
        if (this.targetEntity == null || this.targetEntity != null && !this.targetEntity.func_70089_S()) {
            this.func_75251_c();
        }
        if (this.targetEntity != null && this.targetEntity.func_70089_S() && this.field_75299_d.func_70068_e((Entity)this.targetEntity) < 1.0) {
            EntityHippogryph hippo = (EntityHippogryph)this.field_75299_d;
            this.targetEntity.func_92059_d().func_190918_g(1);
            this.field_75299_d.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
            hippo.setAnimation(EntityHippogryph.ANIMATION_EAT);
            ++hippo.feedings;
            hippo.func_70691_i(4.0f);
            if (!(hippo.feedings <= 3 || hippo.feedings <= 7 && hippo.func_70681_au().nextInt(3) != 0 || hippo.func_70909_n() || this.targetEntity.func_200214_m() == null || this.field_75299_d.field_70170_p.func_217371_b(this.targetEntity.func_200214_m()) == null)) {
                PlayerEntity owner = this.field_75299_d.field_70170_p.func_217371_b(this.targetEntity.func_200214_m());
                hippo.func_70903_f(true);
                hippo.func_184754_b(owner.func_110124_au());
                hippo.func_70624_b(null);
                hippo.setCommand(1);
                hippo.func_233687_w_(true);
            }
            this.func_75251_c();
        }
    }

    public boolean func_75253_b() {
        return !this.field_75299_d.func_70661_as().func_75500_f();
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity theEntity;

        public Sorter(Entity theEntityIn) {
            this.theEntity = theEntityIn;
        }

        @Override
        public int compare(Entity p_compare_1_, Entity p_compare_2_) {
            double d1;
            double d0 = this.theEntity.func_70068_e(p_compare_1_);
            return d0 < (d1 = this.theEntity.func_70068_e(p_compare_2_)) ? -1 : (d0 > d1 ? 1 : 0);
        }
    }
}

