/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.tile;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.AbstractSpawner;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class DreadSpawnerBaseLogic
extends AbstractSpawner {
    private final List<WeightedSpawnerEntity> potentialSpawns = Lists.newArrayList();
    private int spawnDelay = 20;
    private WeightedSpawnerEntity spawnData = new WeightedSpawnerEntity();
    private double mobRotation;
    private double prevMobRotation;
    private int minSpawnDelay = 200;
    private int maxSpawnDelay = 800;
    private int spawnCount = 4;
    private Entity cachedEntity;
    private int maxNearbyEntities = 6;
    private int activatingRangeFromPlayer = 16;
    private int spawnRange = 4;

    @Nullable
    private ResourceLocation getEntityId() {
        String s = this.spawnData.func_185277_b().func_74779_i("id");
        return StringUtils.func_151246_b((String)s) ? null : new ResourceLocation(s);
    }

    public void setEntityId(@Nullable ResourceLocation id) {
        if (id != null) {
            this.spawnData.func_185277_b().func_74778_a("id", id.toString());
        }
    }

    private boolean isActivated() {
        BlockPos blockpos = this.func_177221_b();
        return this.func_98271_a().func_217358_a((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5, (double)this.activatingRangeFromPlayer);
    }

    public void updateSpawner() {
        if (!this.isActivated()) {
            this.prevMobRotation = this.mobRotation;
        } else {
            World world = this.func_98271_a();
            BlockPos blockpos = this.func_177221_b();
            if (this.func_98271_a().field_72995_K) {
                double d3 = (float)blockpos.func_177958_n() + this.func_98271_a().field_73012_v.nextFloat();
                double d4 = (float)blockpos.func_177956_o() + this.func_98271_a().field_73012_v.nextFloat();
                double d5 = (float)blockpos.func_177952_p() + this.func_98271_a().field_73012_v.nextFloat();
                this.func_98271_a().func_195594_a((IParticleData)ParticleTypes.field_197601_L, d3, d4, d5, 0.0, 0.0, 0.0);
                IceAndFire.PROXY.spawnParticle("dread_torch", d3, d4, d5, 0.0, 0.0, 0.0);
                if (this.spawnDelay > 0) {
                    --this.spawnDelay;
                }
                this.prevMobRotation = this.mobRotation;
                this.mobRotation = (this.mobRotation + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
            } else {
                if (this.spawnDelay == -1) {
                    this.resetTimer();
                }
                if (this.spawnDelay > 0) {
                    --this.spawnDelay;
                    return;
                }
                boolean flag = false;
                for (int i = 0; i < this.spawnCount; ++i) {
                    double d2;
                    CompoundNBT compoundnbt = this.spawnData.func_185277_b();
                    Optional optional = EntityType.func_220347_a((CompoundNBT)compoundnbt);
                    if (!optional.isPresent()) {
                        this.resetTimer();
                        return;
                    }
                    ListNBT listnbt = compoundnbt.func_150295_c("Pos", 6);
                    int j = listnbt.size();
                    double d0 = j >= 1 ? listnbt.func_150309_d(0) : (double)blockpos.func_177958_n() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)this.spawnRange + 0.5;
                    double d1 = j >= 2 ? listnbt.func_150309_d(1) : (double)(blockpos.func_177956_o() + world.field_73012_v.nextInt(3) - 1);
                    double d = d2 = j >= 3 ? listnbt.func_150309_d(2) : (double)blockpos.func_177952_p() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)this.spawnRange + 0.5;
                    if (!world.func_226664_a_(((EntityType)optional.get()).func_220328_a(d0, d1, d2)) || !EntitySpawnPlacementRegistry.func_223515_a((EntityType)((EntityType)optional.get()), (IServerWorld)((IServerWorld)world), (SpawnReason)SpawnReason.SPAWNER, (BlockPos)new BlockPos(d0, d1, d2), (Random)world.func_201674_k())) continue;
                    ServerWorld serverworld = (ServerWorld)world;
                    Entity entity = EntityType.func_220335_a((CompoundNBT)compoundnbt, (World)world, p_221408_6_ -> {
                        p_221408_6_.func_70012_b(d0, d1, d2, p_221408_6_.field_70177_z, p_221408_6_.field_70125_A);
                        return p_221408_6_;
                    });
                    if (entity == null) {
                        this.resetTimer();
                        return;
                    }
                    int k = world.func_217357_a(entity.getClass(), new AxisAlignedBB((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), (double)(blockpos.func_177958_n() + 1), (double)(blockpos.func_177956_o() + 1), (double)(blockpos.func_177952_p() + 1)).func_186662_g((double)this.spawnRange)).size();
                    if (k >= this.maxNearbyEntities) {
                        this.resetTimer();
                        return;
                    }
                    entity.func_70012_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                    if (entity instanceof MobEntity) {
                        MobEntity mobentity = (MobEntity)entity;
                        if (!ForgeEventFactory.canEntitySpawnSpawner((MobEntity)mobentity, (World)world, (float)((float)entity.func_226277_ct_()), (float)((float)entity.func_226278_cu_()), (float)((float)entity.func_226281_cx_()), (AbstractSpawner)this)) continue;
                        if (this.spawnData.func_185277_b().func_186856_d() == 1 && this.spawnData.func_185277_b().func_150297_b("id", 8)) {
                            ((MobEntity)entity).func_213386_a((IServerWorld)serverworld, world.func_175649_E(entity.func_233580_cy_()), SpawnReason.SPAWNER, null, null);
                        }
                    }
                    this.func_221409_a(entity);
                    world.func_217379_c(2004, blockpos, 0);
                    if (entity instanceof MobEntity) {
                        ((MobEntity)entity).func_70656_aK();
                    }
                    flag = true;
                }
                if (flag) {
                    this.resetTimer();
                }
            }
        }
    }

    private void func_221409_a(Entity entityIn) {
        if (this.func_98271_a().func_217376_c(entityIn)) {
            for (Entity entity : entityIn.func_184188_bt()) {
                this.func_221409_a(entity);
            }
        }
    }

    private void resetTimer() {
        if (this.maxSpawnDelay <= this.minSpawnDelay) {
            this.spawnDelay = this.minSpawnDelay;
        } else {
            int i = this.maxSpawnDelay - this.minSpawnDelay;
            this.spawnDelay = this.minSpawnDelay + this.func_98271_a().field_73012_v.nextInt(i);
        }
        if (!this.potentialSpawns.isEmpty()) {
            this.func_184993_a(this.spawnData);
        }
        this.func_98267_a(1);
    }

    public void func_98270_a(CompoundNBT nbt) {
        this.spawnDelay = nbt.func_74765_d("Delay");
        this.potentialSpawns.clear();
        if (nbt.func_150297_b("SpawnPotentials", 9)) {
            ListNBT listnbt = nbt.func_150295_c("SpawnPotentials", 10);
            for (int i = 0; i < listnbt.size(); ++i) {
                this.potentialSpawns.add(new WeightedSpawnerEntity(listnbt.func_150305_b(i)));
            }
        }
        if (nbt.func_150297_b("SpawnData", 10)) {
            this.func_184993_a(new WeightedSpawnerEntity(1, nbt.func_74775_l("SpawnData")));
        } else if (!this.potentialSpawns.isEmpty()) {
            this.func_184993_a((WeightedSpawnerEntity)WeightedRandom.func_76271_a((Random)this.func_98271_a().field_73012_v, this.potentialSpawns));
        }
        if (nbt.func_150297_b("MinSpawnDelay", 99)) {
            this.minSpawnDelay = nbt.func_74765_d("MinSpawnDelay");
            this.maxSpawnDelay = nbt.func_74765_d("MaxSpawnDelay");
            this.spawnCount = nbt.func_74765_d("SpawnCount");
        }
        if (nbt.func_150297_b("MaxNearbyEntities", 99)) {
            this.maxNearbyEntities = nbt.func_74765_d("MaxNearbyEntities");
            this.activatingRangeFromPlayer = nbt.func_74765_d("RequiredPlayerRange");
        }
        if (nbt.func_150297_b("SpawnRange", 99)) {
            this.spawnRange = nbt.func_74765_d("SpawnRange");
        }
        if (this.func_98271_a() != null) {
            this.cachedEntity = null;
        }
    }

    public CompoundNBT func_189530_b(CompoundNBT compound) {
        ResourceLocation resourcelocation = this.getEntityId();
        if (resourcelocation == null) {
            return compound;
        }
        compound.func_74777_a("Delay", (short)this.spawnDelay);
        compound.func_74777_a("MinSpawnDelay", (short)this.minSpawnDelay);
        compound.func_74777_a("MaxSpawnDelay", (short)this.maxSpawnDelay);
        compound.func_74777_a("SpawnCount", (short)this.spawnCount);
        compound.func_74777_a("MaxNearbyEntities", (short)this.maxNearbyEntities);
        compound.func_74777_a("RequiredPlayerRange", (short)this.activatingRangeFromPlayer);
        compound.func_74777_a("SpawnRange", (short)this.spawnRange);
        compound.func_218657_a("SpawnData", (INBT)this.spawnData.func_185277_b().func_74737_b());
        ListNBT listnbt = new ListNBT();
        if (this.potentialSpawns.isEmpty()) {
            listnbt.add((Object)this.spawnData.func_185278_a());
        } else {
            for (WeightedSpawnerEntity weightedspawnerentity : this.potentialSpawns) {
                listnbt.add((Object)weightedspawnerentity.func_185278_a());
            }
        }
        compound.func_218657_a("SpawnPotentials", (INBT)listnbt);
        return compound;
    }

    public boolean func_98268_b(int delay) {
        if (delay == 1 && this.func_98271_a().field_72995_K) {
            this.spawnDelay = this.minSpawnDelay;
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Entity func_184994_d() {
        if (this.cachedEntity == null) {
            this.cachedEntity = EntityType.func_220335_a((CompoundNBT)this.spawnData.func_185277_b(), (World)this.func_98271_a(), Function.identity());
            if (this.spawnData.func_185277_b().func_186856_d() != 1 || !this.spawnData.func_185277_b().func_150297_b("id", 8) || this.cachedEntity instanceof MobEntity) {
                // empty if block
            }
        }
        return this.cachedEntity;
    }

    public void func_184993_a(WeightedSpawnerEntity nextSpawnData) {
        this.spawnData = nextSpawnData;
    }

    public abstract void func_98267_a(int var1);

    public abstract BlockPos func_177221_b();

    @OnlyIn(value=Dist.CLIENT)
    public double func_177222_d() {
        return this.mobRotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_177223_e() {
        return this.prevMobRotation;
    }
}

