/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.message;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexBase;
import com.github.alexthe666.iceandfire.entity.util.MyrmexHive;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageMyrmexSettings {
    public int queenID;
    public boolean reproduces;
    public boolean deleteRoom;
    public long roomToDelete;

    public MessageMyrmexSettings(int queenID, boolean repoduces, boolean deleteRoom, long roomToDelete) {
        this.queenID = queenID;
        this.reproduces = repoduces;
        this.deleteRoom = deleteRoom;
        this.roomToDelete = roomToDelete;
    }

    public static MessageMyrmexSettings read(PacketBuffer buf) {
        return new MessageMyrmexSettings(buf.readInt(), buf.readBoolean(), buf.readBoolean(), buf.readLong());
    }

    public static void write(MessageMyrmexSettings message, PacketBuffer buf) {
        buf.writeInt(message.queenID);
        buf.writeBoolean(message.reproduces);
        buf.writeBoolean(message.deleteRoom);
        buf.writeLong(message.roomToDelete);
    }

    public static class Handler {
        public static void handle(MessageMyrmexSettings message, Supplier<NetworkEvent.Context> context) {
            MyrmexHive hive;
            Entity entity;
            context.get().setPacketHandled(true);
            ServerPlayerEntity player = context.get().getSender();
            if (context.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                player = IceAndFire.PROXY.getClientSidePlayer();
            }
            if (player != null && player.field_70170_p != null && (entity = player.field_70170_p.func_73045_a(message.queenID)) != null && entity instanceof EntityMyrmexBase && (hive = ((EntityMyrmexBase)entity).getHive()) != null) {
                hive.reproduces = message.reproduces;
                if (message.deleteRoom) {
                    hive.removeRoom(BlockPos.func_218283_e((long)message.roomToDelete));
                }
            }
        }
    }
}

