/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.message;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.util.ISyncMount;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageStartRidingMob {
    public int dragonId;
    public boolean ride;
    public boolean baby;

    public MessageStartRidingMob(int dragonId, boolean ride, boolean baby) {
        this.dragonId = dragonId;
        this.ride = ride;
        this.baby = baby;
    }

    public MessageStartRidingMob() {
    }

    public static MessageStartRidingMob read(PacketBuffer buf) {
        return new MessageStartRidingMob(buf.readInt(), buf.readBoolean(), buf.readBoolean());
    }

    public static void write(MessageStartRidingMob message, PacketBuffer buf) {
        buf.writeInt(message.dragonId);
        buf.writeBoolean(message.ride);
        buf.writeBoolean(message.baby);
    }

    public static class Handler {
        public static void handle(MessageStartRidingMob message, Supplier<NetworkEvent.Context> context) {
            TameableEntity dragon;
            Entity entity;
            context.get().setPacketHandled(true);
            ServerPlayerEntity player = context.get().getSender();
            if (context.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                player = IceAndFire.PROXY.getClientSidePlayer();
            }
            if (player != null && player.field_70170_p != null && (entity = player.field_70170_p.func_73045_a(message.dragonId)) != null && entity instanceof ISyncMount && entity instanceof TameableEntity && (dragon = (TameableEntity)entity).func_152114_e((LivingEntity)player) && dragon.func_70032_d((Entity)player) < 14.0f) {
                if (message.ride) {
                    if (message.baby) {
                        dragon.func_184205_a((Entity)player, true);
                    } else {
                        player.func_184205_a((Entity)dragon, true);
                    }
                } else if (message.baby) {
                    dragon.func_184210_p();
                } else {
                    player.func_184210_p();
                }
            }
        }
    }
}

