/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.message;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityJar;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityPixieHouse;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageUpdatePixieHouseModel {
    public long blockPos;
    public int houseType;

    public MessageUpdatePixieHouseModel(long blockPos, int houseType) {
        this.blockPos = blockPos;
        this.houseType = houseType;
    }

    public MessageUpdatePixieHouseModel() {
    }

    public static MessageUpdatePixieHouseModel read(PacketBuffer buf) {
        return new MessageUpdatePixieHouseModel(buf.readLong(), buf.readInt());
    }

    public static void write(MessageUpdatePixieHouseModel message, PacketBuffer buf) {
        buf.writeLong(message.blockPos);
        buf.writeInt(message.houseType);
    }

    public static class Handler {
        public static void handle(MessageUpdatePixieHouseModel message, Supplier<NetworkEvent.Context> context) {
            BlockPos pos;
            context.get().setPacketHandled(true);
            ServerPlayerEntity player = context.get().getSender();
            if (context.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                player = IceAndFire.PROXY.getClientSidePlayer();
            }
            if (player != null && player.field_70170_p != null && player.field_70170_p.func_175625_s(pos = BlockPos.func_218283_e((long)message.blockPos)) != null) {
                if (player.field_70170_p.func_175625_s(pos) instanceof TileEntityPixieHouse) {
                    TileEntityPixieHouse house = (TileEntityPixieHouse)player.field_70170_p.func_175625_s(pos);
                    house.houseType = message.houseType;
                }
                if (player.field_70170_p.func_175625_s(pos) instanceof TileEntityJar) {
                    TileEntityJar jar = (TileEntityJar)player.field_70170_p.func_175625_s(pos);
                    jar.pixieType = message.houseType;
                }
            }
        }
    }
}

