/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.recipe;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.util.JSONUtils;

public class DragonForgeRecipe {
    private Ingredient input;
    private Ingredient blood;
    private ItemStack output;
    private String dragonType;

    public DragonForgeRecipe(Ingredient input, Ingredient blood, ItemStack output, String dragonType) {
        this.input = input;
        this.blood = blood;
        this.output = output;
        this.dragonType = dragonType;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public Ingredient getBlood() {
        return this.blood;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public String getDragonType() {
        return this.dragonType;
    }

    public static class Deserializer
    implements JsonDeserializer<DragonForgeRecipe> {
        public DragonForgeRecipe deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonobject = json.getAsJsonObject();
            String dragonType = JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"dragon_type");
            Ingredient input_left = Ingredient.field_193370_a;
            if (jsonobject.has("input_left")) {
                input_left = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)jsonobject, (String)"input_left"));
            }
            Ingredient input_right = Ingredient.field_193370_a;
            if (jsonobject.has("input_right")) {
                input_right = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)jsonobject, (String)"input_right"));
            }
            ItemStack result = ItemStack.field_190927_a;
            if (jsonobject.has("result")) {
                result = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)jsonobject, (String)"result"));
            }
            return new DragonForgeRecipe(input_left, input_right, result, dragonType);
        }
    }
}

