/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.feature;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.world.IafWorldRegistry;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class SpawnDragonSkeleton
extends Feature<NoFeatureConfig> {
    protected EntityType<EntityDragonBase> dragonType;

    public SpawnDragonSkeleton(EntityType<EntityDragonBase> dt, Codec<NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
        this.dragonType = dt;
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator p_230362_3_, Random rand, BlockPos position, NoFeatureConfig p_230362_6_) {
        if (!IafWorldRegistry.isDimensionListedForMobs((IServerWorld)worldIn)) {
            return false;
        }
        position = worldIn.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, position.func_177982_a(8, 0, 8));
        if (IafConfig.generateDragonSkeletons && rand.nextInt(IafConfig.generateDragonSkeletonChance + 1) == 0) {
            EntityDragonBase dragon = (EntityDragonBase)this.dragonType.func_200721_a((World)worldIn.func_201672_e());
            dragon.func_70107_b((float)position.func_177958_n() + 0.5f, position.func_177956_o() + 1, (float)position.func_177952_p() + 0.5f);
            int dragonage = 10 + rand.nextInt(100);
            dragon.growDragon(dragonage);
            dragon.modelDeadProgress = 20.0f;
            dragon.setModelDead(true);
            dragon.setDeathStage(dragonage / 5 / 2);
            dragon.field_70177_z = rand.nextInt(360);
            worldIn.func_217376_c((Entity)dragon);
        }
        return false;
    }
}

