/*
 * Decompiled with CFR 0.152.
 */
package com.tome.botaniaadditions.common.core.handler;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.io.File;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class ConfigHandler {
    private static CommentedFileConfig cfg;
    private static final ForgeConfigSpec.Builder builder;
    private static final String CATEGORY_GENERAL = "general";
    public static ForgeConfigSpec.BooleanValue enableTerraHarvester;
    public static ForgeConfigSpec.BooleanValue enableTimelessIvy;
    public static ForgeConfigSpec.BooleanValue enableTerraBow;

    public static void loadConfig() {
        cfg = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(FMLPaths.CONFIGDIR.get().toString(), "botaniaadditions-common.toml")).sync().autosave().build();
        cfg.load();
        ConfigHandler.initConfig();
        ForgeConfigSpec spec = builder.build();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, spec, cfg.getFile().getName());
        spec.setConfig((CommentedConfig)cfg);
    }

    private static void initConfig() {
        builder.comment("The general configuration for this mod").push(CATEGORY_GENERAL).pop();
        enableTerraHarvester = ConfigHandler.getBoolean("enableTerraHarvester", CATEGORY_GENERAL, true, "If this is set to true the Terra Harvester will be added to the game.");
        enableTimelessIvy = ConfigHandler.getBoolean("enableTimelessIvy", CATEGORY_GENERAL, true, "If this is set to true the Timeless Ivy will be added to the game.");
        enableTerraBow = ConfigHandler.getBoolean("enableTerraBow", CATEGORY_GENERAL, true, "If this is set to true the Terra Bow will be added to the game.");
    }

    public static ForgeConfigSpec.BooleanValue getBoolean(String name, String category, boolean defaultValue, String comment) {
        String path = category + "." + name;
        return builder.comment(new String[]{comment, "Default: " + defaultValue}).define(path, defaultValue);
    }

    static {
        builder = new ForgeConfigSpec.Builder();
        ConfigHandler.loadConfig();
    }
}

