/*
 * Decompiled with CFR 0.152.
 */
package com.tome.botaniaadditions.common.item.equipment.tool.terrasteel;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DeadCoralWallFanBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.eventbus.api.Event;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.ISequentialBreaker;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ItemTemperanceStone;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.equipment.tool.manasteel.ItemManasteelShovel;
import vazkii.botania.common.item.relic.ItemLokiRing;
import vazkii.botania.common.item.relic.ItemThorRing;
import vazkii.botania.mixin.AccessorHoeItem;

public class ItemTerraShovel
extends ItemManasteelShovel
implements ISequentialBreaker {
    private static final String TAG_ENABLED = "enabled";
    private static final int MANA_PER_DAMAGE = 100;
    private static final int MANA_PER_BONEMEAL = 300;

    public ItemTerraShovel(Item.Properties props) {
        super(BotaniaAPI.instance().getTerrasteelItemTier(), props);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        BlockRayTraceResult raycast = ToolCommons.raytraceFromEntity((Entity)player, (double)10.0, (boolean)false);
        if (raycast.func_216346_c() == RayTraceResult.Type.BLOCK) {
            Direction face = raycast.func_216354_b();
            this.breakOtherBlock(player, stack, pos, pos, face);
            ItemLokiRing.breakOnAllCursors((PlayerEntity)player, (ItemStack)stack, (BlockPos)pos, (Direction)face);
        }
        return false;
    }

    public int getManaPerDamage() {
        return 100;
    }

    public void breakOtherBlock(PlayerEntity player, ItemStack stack, BlockPos pos, BlockPos originPos, Direction side) {
        if (player.func_225608_bj_() || !ItemTerraShovel.isEnabled(stack)) {
            return;
        }
        World world = player.field_70170_p;
        BlockState blockstate = world.func_180495_p(pos);
        if (blockstate.getHarvestTool() != ToolType.SHOVEL && !(blockstate.func_177230_c() instanceof IGrowable)) {
            return;
        }
        if (world.func_175623_d(pos)) {
            return;
        }
        boolean crop = blockstate.func_177230_c() instanceof IGrowable && blockstate.getHarvestTool() != ToolType.SHOVEL;
        boolean thor = !ItemThorRing.getThorRing((PlayerEntity)player).func_190926_b();
        boolean doX = thor || side.func_82601_c() == 0;
        boolean doY = (thor || side.func_96559_d() == 0) && !crop;
        boolean doZ = thor || side.func_82599_e() == 0;
        int range = 2 + (thor ? 1 : 0);
        if (ItemTemperanceStone.hasTemperanceActive((PlayerEntity)player)) {
            range = 1;
        }
        int rangeY = Math.max(1, range);
        Vector3i beginDiff = new Vector3i(doX ? -range : 0, doY ? -1 : 0, doZ ? -range : 0);
        Vector3i endDiff = new Vector3i(doX ? range : 0, doY ? rangeY * 2 - 1 : 0, doZ ? range : 0);
        Predicate<BlockState> filter = state -> state.getHarvestTool() == ToolType.SHOVEL;
        if (crop) {
            filter = state -> state.func_177230_c() instanceof IGrowable;
        }
        ToolCommons.removeBlocksInIteration((PlayerEntity)player, (ItemStack)stack, (World)world, (BlockPos)pos, (Vector3i)beginDiff, (Vector3i)endDiff, filter);
    }

    public static boolean isEnabled(ItemStack stack) {
        return ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_ENABLED, (boolean)false);
    }

    void setEnabled(ItemStack stack, boolean enabled) {
        ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_ENABLED, (boolean)enabled);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack;
        this.setEnabled(stack, !ItemTerraShovel.isEnabled(stack = player.func_184586_b(hand)));
        if (!world.field_72995_K) {
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), ModSounds.terraPickMode, SoundCategory.PLAYERS, 0.5f, 0.4f);
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        ItemStack stack = ctx.func_195996_i();
        PlayerEntity player = ctx.func_195999_j();
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        if (player == null || !player.func_175151_a(pos, ctx.func_196000_l(), stack)) {
            return ActionResultType.PASS;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        BlockState converted = (BlockState)field_195955_e.get(block);
        int range = 2 + (!ItemThorRing.getThorRing((PlayerEntity)player).func_190926_b() ? 1 : 0);
        if (ItemTemperanceStone.hasTemperanceActive((PlayerEntity)player)) {
            range = 1;
        }
        if (player.func_225608_bj_() || !ItemTerraShovel.isEnabled(stack)) {
            range = 0;
        }
        int startX = pos.func_177958_n() - range;
        int endX = pos.func_177958_n() + range;
        int endZ = pos.func_177952_p() + range;
        if (ctx.func_196000_l() != Direction.DOWN && world.func_180495_p(pos.func_177984_a()).func_177230_c().isAir(world.func_180495_p(pos.func_177984_a()), (IBlockReader)world, pos.func_177984_a()) && converted != null) {
            world.func_184133_a(null, pos, converted.func_215695_r().func_185844_d(), SoundCategory.BLOCKS, (converted.func_215695_r().func_185843_a() + 1.0f) / 2.0f, converted.func_215695_r().func_185847_b() * 0.8f);
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            BlockPos pos1 = new BlockPos(startX, pos.func_177956_o(), pos.func_177952_p() - range);
            while (pos1.func_177952_p() <= endZ) {
                while (pos1.func_177958_n() <= endX) {
                    if (world.func_180495_p(pos1).func_177230_c() == Blocks.field_196658_i && world.func_180495_p(pos1.func_177984_a()).func_177230_c().isAir(world.func_180495_p(pos1.func_177984_a()), (IBlockReader)world, pos1.func_177984_a()) && player.func_175151_a(pos1, ctx.func_196000_l(), stack)) {
                        world.func_175656_a(pos1, converted);
                    }
                    pos1 = pos1.func_177982_a(1, 0, 0);
                }
                pos1 = new BlockPos(startX, pos1.func_177956_o(), pos1.func_177952_p() + 1);
            }
            stack.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(ctx.func_221531_n()));
            return ActionResultType.SUCCESS;
        }
        converted = (BlockState)AccessorHoeItem.getConversions().get(block);
        if (converted == null && block.getBlock() == Blocks.field_150458_ak) {
            converted = Blocks.field_150458_ak.func_176223_P();
        }
        if (converted != null) {
            BlockPos pos1 = new BlockPos(startX, pos.func_177956_o(), pos.func_177952_p() - range);
            ActionResultType result = ActionResultType.PASS;
            while (pos1.func_177952_p() <= endZ) {
                while (pos1.func_177958_n() <= endX) {
                    if (pos1.equals((Object)pos)) {
                        result = this.tillBlock(pos1, ctx);
                        if (world.func_180495_p(pos1).func_177230_c() == converted.func_177230_c()) {
                            result = ActionResultType.SUCCESS;
                        }
                    } else {
                        this.tillBlock(pos1, ctx);
                    }
                    pos1 = pos1.func_177982_a(1, 0, 0);
                }
                pos1 = new BlockPos(startX, pos1.func_177956_o(), pos1.func_177952_p() + 1);
            }
            return world.func_180495_p(pos1).func_177230_c() == converted.func_177230_c() ? ActionResultType.SUCCESS : result;
        }
        if (block instanceof IGrowable) {
            BlockPos pos1 = new BlockPos(startX, pos.func_177956_o(), pos.func_177952_p() - range);
            boolean success = false;
            while (pos1.func_177952_p() <= endZ) {
                while (pos1.func_177958_n() <= endX) {
                    success = this.bonemealCrop(ctx, pos1) == ActionResultType.SUCCESS || success;
                    pos1 = pos1.func_177982_a(1, 0, 0);
                }
                pos1 = new BlockPos(startX, pos1.func_177956_o(), pos1.func_177952_p() + 1);
            }
            return success ? ActionResultType.SUCCESS : ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    public boolean disposeOfTrashBlocks(ItemStack stack) {
        return false;
    }

    private ActionResultType tillBlock(BlockPos pos, ItemUseContext ctx) {
        PlayerEntity player = ctx.func_195999_j();
        ItemStack stack = ctx.func_195996_i();
        World world = ctx.func_195991_k();
        if (player != null && player.func_175151_a(pos, ctx.func_196000_l(), stack)) {
            BlockRayTraceResult trace = new BlockRayTraceResult(new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5), ctx.func_196000_l(), pos, false);
            ItemUseContext ctx1 = new ItemUseContext(world, player, ctx.func_221531_n(), stack, trace);
            UseHoeEvent event = new UseHoeEvent(ctx1);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return ActionResultType.FAIL;
            }
            if (event.getResult() == Event.Result.ALLOW) {
                stack.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(ctx.func_221531_n()));
                return ActionResultType.SUCCESS;
            }
            Block block = world.func_180495_p(pos).func_177230_c();
            BlockState converted = (BlockState)AccessorHoeItem.getConversions().get(block);
            if (converted == null) {
                return ActionResultType.PASS;
            }
            if (ctx.func_196000_l() != Direction.DOWN && world.func_180495_p(pos.func_177984_a()).func_177230_c().isAir(world.func_180495_p(pos.func_177984_a()), (IBlockReader)world, pos.func_177984_a())) {
                world.func_184133_a(null, pos, converted.func_215695_r().func_185844_d(), SoundCategory.BLOCKS, (converted.func_215695_r().func_185843_a() + 1.0f) / 2.0f, converted.func_215695_r().func_185847_b() * 0.8f);
                if (world.field_72995_K) {
                    return ActionResultType.SUCCESS;
                }
                world.func_175656_a(pos, converted);
                stack.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(ctx.func_221531_n()));
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public boolean shouldCauseReequipAnimation(ItemStack before, @Nonnull ItemStack after, boolean slotChanged) {
        return after.func_77973_b() != this || ItemTerraShovel.isEnabled(before) != ItemTerraShovel.isEnabled(after);
    }

    private ActionResultType bonemealCrop(ItemUseContext ctx, BlockPos pos) {
        if (!ManaItemHandler.instance().requestManaExactForTool(ctx.func_195996_i(), ctx.func_195999_j(), 300, false)) {
            return ActionResultType.PASS;
        }
        World world = ctx.func_195991_k();
        BlockPos pos1 = pos.func_177972_a(ctx.func_196000_l());
        if (ItemTerraShovel.applyBonemeal(ctx.func_195996_i(), world, pos, ctx.func_195999_j())) {
            if (!world.field_72995_K) {
                world.func_217379_c(2005, pos, 0);
            }
            ManaItemHandler.instance().requestManaExactForTool(ctx.func_195996_i(), ctx.func_195999_j(), 300, true);
            return ActionResultType.SUCCESS;
        }
        BlockState blockstate = world.func_180495_p(pos);
        boolean flag = blockstate.func_224755_d((IBlockReader)world, pos, ctx.func_196000_l());
        if (flag && ItemTerraShovel.growSeagrass(ctx.func_195996_i(), world, pos1, ctx.func_196000_l())) {
            if (!world.field_72995_K) {
                world.func_217379_c(2005, pos1, 0);
            }
            ManaItemHandler.instance().requestManaExactForTool(ctx.func_195996_i(), ctx.func_195999_j(), 300, true);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static boolean applyBonemeal(ItemStack stack, World worldIn, BlockPos pos, PlayerEntity player) {
        IGrowable igrowable;
        BlockState blockstate = worldIn.func_180495_p(pos);
        int hook = ForgeEventFactory.onApplyBonemeal((PlayerEntity)player, (World)worldIn, (BlockPos)pos, (BlockState)blockstate, (ItemStack)stack);
        if (hook != 0) {
            return hook > 0;
        }
        if (blockstate.func_177230_c() instanceof IGrowable && (igrowable = (IGrowable)blockstate.func_177230_c()).func_176473_a((IBlockReader)worldIn, pos, blockstate, worldIn.field_72995_K)) {
            if (worldIn instanceof ServerWorld && igrowable.func_180670_a(worldIn, worldIn.field_73012_v, pos, blockstate)) {
                igrowable.func_225535_a_((ServerWorld)worldIn, worldIn.field_73012_v, pos, blockstate);
            }
            return true;
        }
        return false;
    }

    public static boolean growSeagrass(ItemStack stack, World worldIn, BlockPos pos, @Nullable Direction side) {
        if (worldIn.func_180495_p(pos).func_203425_a(Blocks.field_150355_j) && worldIn.func_204610_c(pos).func_206882_g() == 8) {
            if (!(worldIn instanceof ServerWorld)) {
                return true;
            }
            block0: for (int i = 0; i < 128; ++i) {
                BlockPos blockpos = pos;
                BlockState blockstate = Blocks.field_203198_aQ.func_176223_P();
                for (int j = 0; j < i / 16; ++j) {
                    if (worldIn.func_180495_p(blockpos = blockpos.func_177982_a(field_77697_d.nextInt(3) - 1, (field_77697_d.nextInt(3) - 1) * field_77697_d.nextInt(3) / 2, field_77697_d.nextInt(3) - 1)).func_235785_r_((IBlockReader)worldIn, blockpos)) continue block0;
                }
                Optional optional = worldIn.func_242406_i(blockpos);
                if (Objects.equals(optional, Optional.of(Biomes.field_203614_T)) || Objects.equals(optional, Optional.of(Biomes.field_203617_W))) {
                    if (i == 0 && side != null && side.func_176740_k().func_176722_c()) {
                        blockstate = (BlockState)((Block)BlockTags.field_211922_B.func_205596_a(worldIn.field_73012_v)).func_176223_P().func_206870_a((Property)DeadCoralWallFanBlock.field_211884_b, (Comparable)side);
                    } else if (field_77697_d.nextInt(4) == 0) {
                        blockstate = ((Block)BlockTags.field_212741_H.func_205596_a(field_77697_d)).func_176223_P();
                    }
                }
                if (blockstate.func_177230_c().func_203417_a((ITag)BlockTags.field_211922_B)) {
                    for (int k = 0; !blockstate.func_196955_c((IWorldReader)worldIn, blockpos) && k < 4; ++k) {
                        blockstate = (BlockState)blockstate.func_206870_a((Property)DeadCoralWallFanBlock.field_211884_b, (Comparable)Direction.Plane.HORIZONTAL.func_179518_a(field_77697_d));
                    }
                }
                if (!blockstate.func_196955_c((IWorldReader)worldIn, blockpos)) continue;
                BlockState blockstate1 = worldIn.func_180495_p(blockpos);
                if (blockstate1.func_203425_a(Blocks.field_150355_j) && worldIn.func_204610_c(blockpos).func_206882_g() == 8) {
                    worldIn.func_180501_a(blockpos, blockstate, 3);
                    continue;
                }
                if (!blockstate1.func_203425_a(Blocks.field_203198_aQ) || field_77697_d.nextInt(10) != 0) continue;
                ((IGrowable)Blocks.field_203198_aQ).func_225535_a_((ServerWorld)worldIn, field_77697_d, blockpos, blockstate1);
            }
            return true;
        }
        return false;
    }
}

