/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.data;

import cofh.core.data.CoreBlockStateProvider;
import cofh.core.data.CoreItemModelProvider;
import cofh.core.data.CoreLootTableProvider;
import cofh.core.data.CoreRecipeProvider;
import cofh.core.data.CoreTagsProvider;
import cofh.lib.loot.TileNBTSync;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="cofh_core")
public class CoreDataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        TileNBTSync.setup();
        if (event.includeServer()) {
            CoreDataGen.registerServerProviders(event);
        }
        if (event.includeClient()) {
            CoreDataGen.registerClientProviders(event);
        }
    }

    private static void registerServerProviders(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper exFileHelper = event.getExistingFileHelper();
        CoreTagsProvider.Block blockTags = new CoreTagsProvider.Block(gen, exFileHelper);
        gen.func_200390_a((IDataProvider)blockTags);
        gen.func_200390_a((IDataProvider)new CoreTagsProvider.Item(gen, blockTags, exFileHelper));
        gen.func_200390_a((IDataProvider)new CoreTagsProvider.Fluid(gen, exFileHelper));
        gen.func_200390_a((IDataProvider)new CoreLootTableProvider(gen));
        gen.func_200390_a((IDataProvider)new CoreRecipeProvider(gen));
    }

    private static void registerClientProviders(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper exFileHelper = event.getExistingFileHelper();
        gen.func_200390_a((IDataProvider)new CoreBlockStateProvider(gen, exFileHelper));
        gen.func_200390_a((IDataProvider)new CoreItemModelProvider(gen, exFileHelper));
    }
}

