/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.init.CoreConfig;
import cofh.lib.item.ICoFHItem;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.helpers.StringHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockItemCoFH
extends BlockItem
implements ICoFHItem {
    protected BooleanSupplier showInGroups = Constants.TRUE;
    protected int burnTime = -1;
    protected int enchantability;
    protected String modId = "";
    protected Supplier<ItemGroup> displayGroup;

    public BlockItemCoFH(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    public BlockItemCoFH setEnchantability(int enchantability) {
        this.enchantability = enchantability;
        return this;
    }

    public BlockItemCoFH setBurnTime(int burnTime) {
        this.burnTime = burnTime;
        return this;
    }

    public BlockItemCoFH setDisplayGroup(Supplier<ItemGroup> displayGroup) {
        this.displayGroup = displayGroup;
        return this;
    }

    public BlockItemCoFH setShowInGroups(BooleanSupplier showInGroups) {
        this.showInGroups = showInGroups;
        return this;
    }

    public BlockItemCoFH setModId(String modId) {
        this.modId = modId;
        return this;
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
    }

    public String getCreatorModId(ItemStack itemStack) {
        return this.modId == null || this.modId.isEmpty() ? super.getCreatorModId(itemStack) : this.modId;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.showInGroups.getAsBoolean() || this.func_179223_d() == null || this.displayGroup != null && this.displayGroup.get() != null && this.displayGroup.get() != group) {
            return;
        }
        super.func_150895_a(group, items);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ArrayList<ITextComponent> additionalTooltips = new ArrayList<ITextComponent>();
        this.tooltipDelegate(stack, worldIn, additionalTooltips, flagIn);
        if (!additionalTooltips.isEmpty()) {
            if (Screen.func_231173_s_() || CoreConfig.alwaysShowDetails) {
                tooltip.addAll(additionalTooltips);
            } else if (CoreConfig.holdShiftForDetails) {
                tooltip.add((ITextComponent)StringHelper.getTextComponent("info.cofh.hold_shift_for_details").func_240699_a_(TextFormatting.GRAY));
            }
        }
    }

    public boolean func_77616_k(ItemStack stack) {
        return this.enchantability > 0;
    }

    public int func_77619_b() {
        return this.enchantability;
    }

    public int getBurnTime(ItemStack itemStack) {
        return this.burnTime;
    }

    public Collection<ItemGroup> getCreativeTabs() {
        return this.displayGroup != null && this.displayGroup.get() != null ? Collections.singletonList(this.displayGroup.get()) : super.getCreativeTabs();
    }
}

