/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.item.ItemCoFH;
import cofh.lib.entity.AbstractMinecartEntityCoFH;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class MinecartItemCoFH
extends ItemCoFH {
    protected final IMinecartFactory<? extends AbstractMinecartEntityCoFH> factory;
    private static final IDispenseItemBehavior DISPENSER_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior behaviourDefaultDispenseItem = new DefaultDispenseItemBehavior();

        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            double d3;
            RailShape railshape;
            Direction direction = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
            ServerWorld world = source.func_197524_h();
            double d0 = source.func_82615_a() + (double)direction.func_82601_c() * 1.125;
            double d1 = Math.floor(source.func_82617_b()) + (double)direction.func_96559_d();
            double d2 = source.func_82616_c() + (double)direction.func_82599_e() * 1.125;
            BlockPos blockpos = source.func_180699_d().func_177972_a(direction);
            BlockState blockstate = world.func_180495_p(blockpos);
            RailShape railShape = railshape = blockstate.func_177230_c() instanceof AbstractRailBlock ? ((AbstractRailBlock)blockstate.func_177230_c()).getRailDirection(blockstate, (IBlockReader)world, blockpos, null) : RailShape.NORTH_SOUTH;
            if (blockstate.func_235714_a_((ITag)BlockTags.field_203437_y)) {
                d3 = railshape.func_208092_c() ? 0.6 : 0.1;
            } else {
                if (!blockstate.isAir((IBlockReader)world, blockpos) || !world.func_180495_p(blockpos.func_177977_b()).func_235714_a_((ITag)BlockTags.field_203437_y)) {
                    return this.behaviourDefaultDispenseItem.dispense(source, stack);
                }
                BlockState state = world.func_180495_p(blockpos.func_177977_b());
                RailShape shape = state.func_177230_c() instanceof AbstractRailBlock ? ((AbstractRailBlock)state.func_177230_c()).getRailDirection(state, (IBlockReader)world, blockpos.func_177977_b(), null) : RailShape.NORTH_SOUTH;
                d3 = direction != Direction.DOWN && shape.func_208092_c() ? -0.4 : -0.9;
            }
            if (stack.func_77973_b() instanceof MinecartItemCoFH) {
                ((MinecartItemCoFH)stack.func_77973_b()).createMinecart(stack, (World)world, d0, d1 + d3, d2);
                stack.func_190918_g(1);
            }
            return stack;
        }
    };

    public MinecartItemCoFH(IMinecartFactory<? extends AbstractMinecartEntityCoFH> factory, Item.Properties builder) {
        super(builder);
        this.factory = factory;
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)DISPENSER_BEHAVIOR);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos blockpos;
        World world = context.func_195991_k();
        BlockState blockstate = world.func_180495_p(blockpos = context.func_195995_a());
        if (!blockstate.func_235714_a_((ITag)BlockTags.field_203437_y)) {
            return ActionResultType.FAIL;
        }
        ItemStack stack = context.func_195996_i();
        if (!world.field_72995_K) {
            RailShape railshape = blockstate.func_177230_c() instanceof AbstractRailBlock ? ((AbstractRailBlock)blockstate.func_177230_c()).getRailDirection(blockstate, (IBlockReader)world, blockpos, null) : RailShape.NORTH_SOUTH;
            double d0 = 0.0;
            if (railshape.func_208092_c()) {
                d0 = 0.5;
            }
            this.createMinecart(stack, world, (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.0625 + d0, (double)blockpos.func_177952_p() + 0.5);
        }
        stack.func_190918_g(1);
        return ActionResultType.SUCCESS;
    }

    protected void createMinecart(ItemStack stack, World world, double posX, double posY, double posZ) {
        AbstractMinecartEntityCoFH minecart = this.factory.createMinecart(world, posX, posY, posZ);
        if (stack.func_82837_s()) {
            minecart.func_200203_b(stack.func_200301_q());
        }
        minecart.setEnchantments(stack.func_77986_q());
        world.func_217376_c((Entity)minecart);
    }

    public static interface IMinecartFactory<T extends AbstractMinecartEntity> {
        public T createMinecart(World var1, double var2, double var4, double var6);
    }
}

