/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util;

import cofh.core.event.CoreClientSetupEvents;
import cofh.core.util.Proxy;
import cofh.lib.tileentity.IAreaEffectTile;
import cofh.lib.util.IProxyItemPropertyGetter;
import cofh.lib.util.helpers.SoundHelper;
import cofh.lib.util.helpers.StringHelper;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class ProxyClient
extends Proxy {
    protected static final Map<ResourceLocation, Object> MODEL_MAP = new Object2ObjectOpenHashMap();
    protected static final Set<ModelPropertyWrapper> ITEM_PROPERTY_GETTERS = new HashSet<ModelPropertyWrapper>();
    protected static final Set<IAreaEffectTile> AREA_EFFECT_TILES = Collections.newSetFromMap(new WeakHashMap());

    @Override
    public void addIndexedChatMessage(ITextComponent chat, int index) {
        if (chat == null) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146242_c(index);
        } else {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146234_a(chat, index);
        }
    }

    @Override
    public void playSimpleSound(SoundEvent sound, float volume, float pitch) {
        SoundHelper.playSimpleSound(sound, volume, pitch);
    }

    @Override
    public PlayerEntity getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public boolean canLocalize(String key) {
        return StringHelper.canLocalize(key);
    }

    @Override
    protected Object addModel(ResourceLocation loc, Object model) {
        return MODEL_MAP.put(loc, model);
    }

    @Override
    public Object getModel(ResourceLocation loc) {
        return MODEL_MAP.get(loc);
    }

    @Override
    public void addColorable(Item colorable) {
        CoreClientSetupEvents.addColorable(colorable);
    }

    @Override
    public void registerItemModelProperty(Item item, ResourceLocation resourceLoc, IProxyItemPropertyGetter propertyGetter) {
        ITEM_PROPERTY_GETTERS.add(new ModelPropertyWrapper(item, resourceLoc, propertyGetter));
    }

    @Override
    public void addAreaEffectTile(IAreaEffectTile tile) {
        AREA_EFFECT_TILES.add(tile);
    }

    @Override
    public void removeAreaEffectTile(IAreaEffectTile tile) {
        AREA_EFFECT_TILES.remove(tile);
    }

    public static Set<IAreaEffectTile> getAreaEffectTiles() {
        return AREA_EFFECT_TILES;
    }

    public static void registerItemModelProperties() {
        for (ModelPropertyWrapper wrapper : ITEM_PROPERTY_GETTERS) {
            ItemModelsProperties.func_239418_a_((Item)wrapper.item, (ResourceLocation)wrapper.resourceLoc, (IItemPropertyGetter)wrapper.propertyGetter);
        }
        ITEM_PROPERTY_GETTERS.clear();
    }

    protected static class ModelPropertyWrapper {
        Item item;
        ResourceLocation resourceLoc;
        IItemPropertyGetter propertyGetter;

        ModelPropertyWrapper(Item item, ResourceLocation resourceLoc, IProxyItemPropertyGetter propertyGetter) {
            this.item = item;
            this.resourceLoc = resourceLoc;
            this.propertyGetter = propertyGetter::call;
        }
    }
}

