/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.crafting;

import cofh.core.CoFHCore;
import cofh.core.util.crafting.ShapedRecipeInternal;
import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ShapedPotionNBTRecipe
implements ICraftingRecipe,
IShapedRecipe<CraftingInventory> {
    private final ShapedRecipeInternal wrappedRecipe;

    public ShapedPotionNBTRecipe(ResourceLocation id, String group, int width, int height, NonNullList<Ingredient> recipeItems, ItemStack result) {
        this.wrappedRecipe = new ShapedRecipeInternal(id, group, width, height, recipeItems, result);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        boolean potionItem = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_77973_b() != Items.field_151068_bn || PotionUtils.func_185189_a((ItemStack)stack).isEmpty()) continue;
            potionItem = true;
            break;
        }
        return potionItem && this.wrappedRecipe.matches(inv, worldIn);
    }

    public ItemStack assemble(CraftingInventory inv) {
        ItemStack result = this.wrappedRecipe.func_77571_b().func_77946_l();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_77973_b() != Items.field_151068_bn || stack.func_77978_p() == null) continue;
            result.func_77982_d(stack.func_77978_p().func_74737_b());
            break;
        }
        return result;
    }

    public boolean func_194133_a(int width, int height) {
        return this.wrappedRecipe.func_194133_a(width, height);
    }

    public ItemStack func_77571_b() {
        return this.wrappedRecipe.func_77571_b();
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.wrappedRecipe.func_192400_c();
    }

    public ResourceLocation func_199560_c() {
        return this.wrappedRecipe.func_199560_c();
    }

    public IRecipeSerializer<?> func_199559_b() {
        return CoFHCore.RECIPE_SERIALIZERS.get("crafting_shaped_potion");
    }

    public int getRecipeWidth() {
        return this.wrappedRecipe.getWidth();
    }

    public int getRecipeHeight() {
        return this.wrappedRecipe.getHeight();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ShapedPotionNBTRecipe> {
        public ShapedPotionNBTRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            Map<String, Ingredient> map = ShapedRecipeInternal.keyFromJson(JSONUtils.func_152754_s((JsonObject)json, (String)"key"));
            String[] astring = ShapedRecipeInternal.shrink(ShapedRecipeInternal.patternFromJson(JSONUtils.func_151214_t((JsonObject)json, (String)"pattern")));
            int i = astring[0].length();
            int j = astring.length;
            NonNullList<Ingredient> nonnulllist = ShapedRecipeInternal.dissolvePattern(astring, map, i, j);
            ItemStack itemstack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new ShapedPotionNBTRecipe(recipeId, s, i, j, nonnulllist, itemstack);
        }

        public ShapedPotionNBTRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            int i = buffer.func_150792_a();
            int j = buffer.func_150792_a();
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            NonNullList nonnulllist = NonNullList.func_191197_a((int)(i * j), (Object)Ingredient.field_193370_a);
            for (int k = 0; k < nonnulllist.size(); ++k) {
                nonnulllist.set(k, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack itemstack = buffer.func_150791_c();
            return new ShapedPotionNBTRecipe(recipeId, s, i, j, (NonNullList<Ingredient>)nonnulllist, itemstack);
        }

        public void toNetwork(PacketBuffer buffer, ShapedPotionNBTRecipe recipe) {
            buffer.func_150787_b(recipe.getRecipeWidth());
            buffer.func_150787_b(recipe.getRecipeHeight());
            buffer.func_180714_a(recipe.func_193358_e());
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.func_77571_b());
        }
    }
}

