/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.block.impl;

import cofh.lib.block.impl.DirectionalBlock4Way;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.datafixers.util.Pair;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.pathfinding.PathType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class FeastBlock
extends DirectionalBlock4Way {
    protected static final VoxelShape[] SHAPE_BY_BITE = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0)};
    protected final Food food;
    protected Supplier<Item> serving = () -> Items.field_190931_a;

    public FeastBlock(AbstractBlock.Properties properties, @Nonnull Food food) {
        super(properties);
        this.food = food;
    }

    public FeastBlock serving(Supplier<Item> serving) {
        this.serving = serving;
        return this;
    }

    protected IItemProvider getServingItem() {
        return (IItemProvider)this.serving.get();
    }

    public IntegerProperty getBitesProperty() {
        return Constants.BITES_0_7;
    }

    protected int getMaxBites() {
        return this.getBitesProperty().func_177700_c().size() - 1;
    }

    protected ActionResultType serve(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        boolean takeServing;
        ItemStack servItem = new ItemStack(this.getServingItem());
        boolean bl = takeServing = !servItem.func_190926_b() && !player.func_226563_dT_();
        if (!player.func_71043_e(takeServing)) {
            return ActionResultType.PASS;
        }
        if (takeServing) {
            player.func_191521_c(servItem);
        } else {
            player.func_71024_bL().func_75122_a(this.food.func_221466_a(), this.food.func_221469_b());
            for (Pair pair : this.food.func_221464_f()) {
                if (world.field_72995_K || pair.getFirst() == null || !(world.field_73012_v.nextFloat() < ((Float)pair.getSecond()).floatValue())) continue;
                player.func_195064_c(new EffectInstance((EffectInstance)pair.getFirst()));
            }
        }
        int i = (Integer)state.func_177229_b((Property)this.getBitesProperty());
        if (i < this.getMaxBites()) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)this.getBitesProperty(), (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            world.func_217377_a(pos, false);
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            ItemStack stack = player.func_184586_b(handIn);
            if (this.serve(worldIn, pos, state, player).func_226246_a_()) {
                return ActionResultType.SUCCESS;
            }
            if (stack.func_190926_b()) {
                return ActionResultType.CONSUME;
            }
        }
        return this.serve(worldIn, pos, state, player);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE_BY_BITE[MathHelper.clamp((Integer)state.func_177229_b((Property)this.getBitesProperty()), 0, SHAPE_BY_BITE.length - 1)];
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState stateIn, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a();
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{this.getBitesProperty()});
    }

    public boolean func_196266_a(BlockState stateIn, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

