/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.data;

import cofh.lib.util.DeferredRegisterCoFH;
import cofh.lib.util.flags.FlagManager;
import cofh.lib.util.flags.FlagRecipeCondition;
import cofh.lib.util.flags.TagExistsRecipeCondition;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.NBTPredicate;
import net.minecraft.block.Block;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.data.SingleItemRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecipeProviderCoFH
extends RecipeProvider
implements IConditionBuilder {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final String modid;
    protected FlagManager manager;

    public RecipeProviderCoFH(DataGenerator generatorIn, String modid) {
        super(generatorIn);
        this.modid = modid;
    }

    public void func_200398_a(DirectoryCache cache) {
        Path path = this.field_200413_c.func_200391_b();
        HashSet set = Sets.newHashSet();
        this.func_200404_a(recipe -> {
            if (!set.add(recipe.func_200442_b())) {
                LOGGER.error("Duplicate recipe " + recipe.func_200442_b());
            } else {
                RecipeProviderCoFH.func_208311_a((DirectoryCache)cache, (JsonObject)recipe.func_200441_a(), (Path)path.resolve("data/" + recipe.func_200442_b().func_110624_b() + "/recipes/" + recipe.func_200442_b().func_110623_a() + ".json"));
            }
        });
    }

    @SafeVarargs
    protected final Ingredient fromTags(ITag.INamedTag<Item> ... tagsIn) {
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>(tagsIn.length);
        for (ITag.INamedTag<Item> tag : tagsIn) {
            ingredients.add(Ingredient.func_199805_a(tag));
        }
        return new CompoundIngredientWrapper(ingredients);
    }

    protected void generateSmallPackingRecipe(Consumer<IFinishedRecipe> consumer, Item storage, Item individual, String suffix) {
        String storageName = RecipeProviderCoFH.name(storage);
        String individualName = RecipeProviderCoFH.name(individual);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)storage).func_200462_a(Character.valueOf('#'), (IItemProvider)individual).func_200472_a("##").func_200472_a("##").func_200465_a("has_at_least_4_" + individualName, (ICriterionInstance)this.hasItem(MinMaxBounds.IntBound.func_211340_b((int)4), (IItemProvider)individual)).func_200466_a(consumer, this.modid + ":storage/" + storageName + suffix);
    }

    protected void generateSmallUnpackingRecipe(Consumer<IFinishedRecipe> consumer, Item storage, Item individual, String suffix) {
        String storageName = RecipeProviderCoFH.name(storage);
        String individualName = RecipeProviderCoFH.name(individual);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)individual, (int)4).func_200487_b((IItemProvider)storage).func_200483_a("has_at_least_4_" + individualName, (ICriterionInstance)this.hasItem(MinMaxBounds.IntBound.func_211340_b((int)4), (IItemProvider)individual)).func_200483_a("has_" + storageName, (ICriterionInstance)RecipeProviderCoFH.func_200403_a((IItemProvider)storage)).func_200484_a(consumer, this.modid + ":storage/" + individualName + suffix);
    }

    protected void generateSmallStorageRecipes(Consumer<IFinishedRecipe> consumer, Item storage, Item individual, String packingSuffix, String unpackingSuffix) {
        this.generateSmallPackingRecipe(consumer, storage, individual, packingSuffix);
        this.generateSmallUnpackingRecipe(consumer, storage, individual, unpackingSuffix);
    }

    protected void generateSmallStorageRecipes(Consumer<IFinishedRecipe> consumer, Item storage, Item individual) {
        this.generateSmallStorageRecipes(consumer, storage, individual, "", "_from_block");
    }

    protected void generatePackingRecipe(Consumer<IFinishedRecipe> consumer, Item storage, Item individual, String suffix) {
        String storageName = RecipeProviderCoFH.name(storage);
        String individualName = RecipeProviderCoFH.name(individual);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)storage).func_200462_a(Character.valueOf('#'), (IItemProvider)individual).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_at_least_9_" + individualName, (ICriterionInstance)this.hasItem(MinMaxBounds.IntBound.func_211340_b((int)9), (IItemProvider)individual)).func_200466_a(consumer, this.modid + ":storage/" + storageName + suffix);
    }

    protected void generatePackingRecipe(Consumer<IFinishedRecipe> consumer, Item storage, Item individual, ITag.INamedTag<Item> tag, String suffix) {
        String storageName = RecipeProviderCoFH.name(storage);
        String individualName = RecipeProviderCoFH.name(individual);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)storage).func_200462_a(Character.valueOf('I'), (IItemProvider)individual).func_200469_a(Character.valueOf('#'), tag).func_200472_a("###").func_200472_a("#I#").func_200472_a("###").func_200465_a("has_at_least_9_" + individualName, (ICriterionInstance)this.hasItem(MinMaxBounds.IntBound.func_211340_b((int)9), (IItemProvider)individual)).func_200466_a(consumer, this.modid + ":storage/" + storageName + suffix);
    }

    protected void generateUnpackingRecipe(Consumer<IFinishedRecipe> consumer, Item storage, Item individual, String suffix) {
        String storageName = RecipeProviderCoFH.name(storage);
        String individualName = RecipeProviderCoFH.name(individual);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)individual, (int)9).func_200487_b((IItemProvider)storage).func_200483_a("has_at_least_9_" + individualName, (ICriterionInstance)this.hasItem(MinMaxBounds.IntBound.func_211340_b((int)9), (IItemProvider)individual)).func_200483_a("has_" + storageName, (ICriterionInstance)RecipeProviderCoFH.func_200403_a((IItemProvider)storage)).func_200484_a(consumer, this.modid + ":storage/" + individualName + suffix);
    }

    protected void generateStorageRecipes(Consumer<IFinishedRecipe> consumer, Item storage, Item individual, String packingSuffix, String unpackingSuffix) {
        this.generatePackingRecipe(consumer, storage, individual, packingSuffix);
        this.generateUnpackingRecipe(consumer, storage, individual, unpackingSuffix);
    }

    protected void generateStorageRecipes(Consumer<IFinishedRecipe> consumer, Item storage, Item individual, ITag.INamedTag<Item> tag, String packingSuffix, String unpackingSuffix) {
        this.generatePackingRecipe(consumer, storage, individual, tag, packingSuffix);
        this.generateUnpackingRecipe(consumer, storage, individual, unpackingSuffix);
    }

    protected void generateStorageRecipes(Consumer<IFinishedRecipe> consumer, Item storage, Item individual, ITag.INamedTag<Item> tag) {
        this.generateStorageRecipes(consumer, storage, individual, tag, "", "_from_block");
    }

    protected void generateStorageRecipes(Consumer<IFinishedRecipe> consumer, Item storage, Item individual) {
        this.generateStorageRecipes(consumer, storage, individual, "", "_from_block");
    }

    protected void generateTypeRecipes(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, String type) {
        Item ingot = reg.get(type + "_ingot");
        Item gem = reg.get(type);
        Item block = reg.get(type + "_block");
        Item nugget = reg.get(type + "_nugget");
        Tags.IOptionalNamedTag<Item> ingotTag = RecipeProviderCoFH.forgeTag("ingots/" + type);
        Tags.IOptionalNamedTag<Item> gemTag = RecipeProviderCoFH.forgeTag("gems/" + type);
        Tags.IOptionalNamedTag<Item> nuggetTag = RecipeProviderCoFH.forgeTag("nuggets/" + type);
        if (block != null) {
            if (ingot != null) {
                this.generateStorageRecipes(consumer, block, ingot, (ITag.INamedTag<Item>)ingotTag, "", "_from_block");
            } else if (gem != null) {
                this.generateStorageRecipes(consumer, block, gem, (ITag.INamedTag<Item>)gemTag, "", "_from_block");
            }
        }
        if (nugget != null) {
            if (ingot != null) {
                this.generateStorageRecipes(consumer, ingot, nugget, (ITag.INamedTag<Item>)nuggetTag, "_from_nuggets", "_from_ingot");
            } else if (gem != null) {
                this.generateStorageRecipes(consumer, gem, nugget, (ITag.INamedTag<Item>)nuggetTag, "_from_nuggets", "_from_gem");
            }
        }
        this.generateGearRecipe(reg, consumer, type);
    }

    protected void generateGearRecipe(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, String type) {
        Item gear = reg.get(type + "_gear");
        if (gear == null) {
            return;
        }
        Item ingot = reg.get(type + "_ingot");
        Item gem = reg.get(type);
        Tags.IOptionalNamedTag<Item> ingotTag = RecipeProviderCoFH.forgeTag("ingots/" + type);
        Tags.IOptionalNamedTag<Item> gemTag = RecipeProviderCoFH.forgeTag("gems/" + type);
        if (ingot != null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)gear).func_200469_a(Character.valueOf('#'), ingotTag).func_200469_a(Character.valueOf('i'), (ITag)Tags.Items.NUGGETS_IRON).func_200472_a(" # ").func_200472_a("#i#").func_200472_a(" # ").func_200465_a("has_" + RecipeProviderCoFH.name(ingot), (ICriterionInstance)RecipeProviderCoFH.func_200409_a(ingotTag)).func_200466_a(consumer, this.modid + ":parts/" + RecipeProviderCoFH.name(gear));
        }
        if (gem != null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)gear).func_200469_a(Character.valueOf('#'), gemTag).func_200469_a(Character.valueOf('i'), (ITag)Tags.Items.NUGGETS_IRON).func_200472_a(" # ").func_200472_a("#i#").func_200472_a(" # ").func_200465_a("has_" + RecipeProviderCoFH.name(gem), (ICriterionInstance)RecipeProviderCoFH.func_200409_a(gemTag)).func_200466_a(consumer, this.modid + ":parts/" + RecipeProviderCoFH.name(gear));
        }
    }

    protected void generateGearRecipe(Consumer<IFinishedRecipe> consumer, Item gear, Item material, ITag.INamedTag<Item> tag) {
        if (gear == null || material == null || tag == null) {
            return;
        }
        ShapedRecipeBuilder.func_200470_a((IItemProvider)gear).func_200469_a(Character.valueOf('#'), tag).func_200469_a(Character.valueOf('i'), (ITag)Tags.Items.NUGGETS_IRON).func_200472_a(" # ").func_200472_a("#i#").func_200472_a(" # ").func_200465_a("has_" + RecipeProviderCoFH.name(material), (ICriterionInstance)RecipeProviderCoFH.func_200409_a(tag)).func_200466_a(consumer, this.modid + ":parts/" + RecipeProviderCoFH.name(gear));
    }

    protected void generateSmeltingRecipe(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, Item input, Item output, float xp) {
        this.generateSmeltingRecipe(reg, consumer, input, output, xp, "", "");
    }

    protected void generateSmeltingRecipe(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, Item input, Item output, float xp, String folder) {
        this.generateSmeltingRecipe(reg, consumer, input, output, xp, folder, "");
    }

    protected void generateSmeltingRecipe(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, Item input, Item output, float xp, String folder, String suffix) {
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input}), (IItemProvider)output, (float)xp, (int)200).func_218628_a("has_" + RecipeProviderCoFH.name(input), (ICriterionInstance)RecipeProviderCoFH.func_200403_a((IItemProvider)input)).func_218632_a(consumer, this.modid + ":" + folder + "/" + RecipeProviderCoFH.name(output) + "_from" + suffix + "_smelting");
    }

    protected void generateSmeltingAndBlastingRecipes(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, String material, float xp) {
        this.generateSmeltingAndBlastingRecipes(reg, consumer, material, xp, "smelting");
    }

    protected void generateSmeltingAndBlastingRecipes(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, String material, float xp, String folder) {
        Item ore = reg.get(material + "_ore");
        Item ingot = reg.get(material + "_ingot");
        Item gem = reg.get(material);
        Item dust = reg.get(material + "_dust");
        if (ingot != null) {
            if (dust != null) {
                this.generateSmeltingAndBlastingRecipes(reg, consumer, dust, ingot, 0.0f, folder, "_dust");
            }
            if (ore != null) {
                this.generateSmeltingAndBlastingRecipes(reg, consumer, ore, ingot, xp, folder, "_ore");
            }
        } else if (gem != null && ore != null) {
            this.generateSmeltingAndBlastingRecipes(reg, consumer, ore, gem, xp, folder, "_ore");
        }
    }

    protected void generateSmeltingAndBlastingRecipes(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, Item input, Item output, float xp, String folder) {
        this.generateSmeltingAndBlastingRecipes(reg, consumer, input, output, xp, folder, "");
    }

    protected void generateSmeltingAndBlastingRecipes(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, Item input, Item output, float xp, String folder, String suffix) {
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input}), (IItemProvider)output, (float)xp, (int)200).func_218628_a("has_" + RecipeProviderCoFH.name(input), (ICriterionInstance)RecipeProviderCoFH.func_200403_a((IItemProvider)input)).func_218632_a(consumer, this.modid + ":" + folder + "/" + RecipeProviderCoFH.name(output) + "_from" + suffix + "_smelting");
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input}), (IItemProvider)output, (float)xp, (int)100).func_218628_a("has_" + RecipeProviderCoFH.name(input), (ICriterionInstance)RecipeProviderCoFH.func_200403_a((IItemProvider)input)).func_218632_a(consumer, this.modid + ":" + folder + "/" + RecipeProviderCoFH.name(output) + "_from" + suffix + "_blasting");
    }

    protected void generateStonecuttingRecipe(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, Item input, Item output, String folder) {
        this.generateStonecuttingRecipe(reg, consumer, input, output, folder, "");
    }

    protected void generateStonecuttingRecipe(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, Item input, Item output, String folder, String suffix) {
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input}), (IItemProvider)output).func_218643_a("has_" + RecipeProviderCoFH.name(input), (ICriterionInstance)RecipeProviderCoFH.func_200403_a((IItemProvider)input)).func_218645_a(consumer, this.modid + ":" + folder + "/" + RecipeProviderCoFH.name(output) + "_from" + suffix + "_stonecutting");
    }

    public InventoryChangeTrigger.Instance hasItem(MinMaxBounds.IntBound amount, IItemProvider itemIn) {
        return RecipeProviderCoFH.func_200405_a((ItemPredicate[])new ItemPredicate[]{new ItemPredicate(null, itemIn.func_199767_j(), amount, MinMaxBounds.IntBound.field_211347_e, EnchantmentPredicate.field_226534_b_, EnchantmentPredicate.field_226534_b_, null, NBTPredicate.field_193479_a)});
    }

    protected static Tags.IOptionalNamedTag<Item> forgeTag(String name) {
        return ItemTags.createOptional((ResourceLocation)new ResourceLocation("forge", name));
    }

    protected static String name(Block block) {
        return block.getRegistryName() == null ? "" : block.getRegistryName().func_110623_a();
    }

    protected static String name(Item item) {
        return item.getRegistryName() == null ? "" : item.getRegistryName().func_110623_a();
    }

    protected ConditionalRecipeConsumer withConditions(Consumer<IFinishedRecipe> consumer) {
        return new ConditionalRecipeConsumer(consumer);
    }

    protected class ConditionalRecipeConsumer
    implements Consumer<IFinishedRecipe> {
        protected final Consumer<IFinishedRecipe> consumer;
        protected List<ICondition> conditions = new ArrayList<ICondition>();

        public ConditionalRecipeConsumer(Consumer<IFinishedRecipe> consumer) {
            this.consumer = consumer;
        }

        public ConditionalRecipeConsumer addCondition(ICondition condition) {
            this.conditions.add(condition);
            return this;
        }

        public ConditionalRecipeConsumer addConditions(List<ICondition> conditions) {
            this.conditions.addAll(conditions);
            return this;
        }

        public ConditionalRecipeConsumer tagExists(ITag.INamedTag<?> tag) {
            this.conditions.add(new TagExistsRecipeCondition(tag.func_230234_a_()));
            return this;
        }

        public ConditionalRecipeConsumer flag(String flag) {
            if (RecipeProviderCoFH.this.manager != null) {
                this.conditions.add(new FlagRecipeCondition(RecipeProviderCoFH.this.manager, flag));
            }
            return this;
        }

        @Override
        public void accept(IFinishedRecipe recipe) {
            if (!this.conditions.isEmpty()) {
                this.consumer.accept(new ConditionalRecipeWrapper(recipe).addConditions(this.conditions));
            } else {
                this.consumer.accept(recipe);
            }
        }
    }

    protected static class ConditionalRecipeWrapper
    implements IFinishedRecipe {
        protected IFinishedRecipe recipe;
        protected List<ICondition> conditions = new ArrayList<ICondition>();

        public ConditionalRecipeWrapper(IFinishedRecipe recipe) {
            this.recipe = recipe;
        }

        public ConditionalRecipeWrapper addCondition(ICondition condition) {
            this.conditions.add(condition);
            return this;
        }

        public ConditionalRecipeWrapper addConditions(List<ICondition> conditions) {
            this.conditions.addAll(conditions);
            return this;
        }

        public void func_218610_a(JsonObject json) {
            this.recipe.func_218610_a(json);
        }

        public JsonObject func_200441_a() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("type", Registry.field_218368_I.func_177774_c(this.func_218609_c()).toString());
            this.func_218610_a(jsonobject);
            if (!this.conditions.isEmpty()) {
                JsonArray conditionArray = new JsonArray();
                for (ICondition condition : this.conditions) {
                    conditionArray.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
                }
                jsonobject.add("conditions", (JsonElement)conditionArray);
            }
            return jsonobject;
        }

        public ResourceLocation func_200442_b() {
            return this.recipe.func_200442_b();
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.recipe.func_218609_c();
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.recipe.func_200440_c();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.recipe.func_200443_d();
        }
    }

    protected static class CompoundIngredientWrapper
    extends CompoundIngredient {
        public CompoundIngredientWrapper(List<Ingredient> children) {
            super(children);
        }
    }
}

