/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.entity;

import cofh.lib.item.impl.KnifeItem;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.references.CoreReferences;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.fml.network.NetworkHooks;

public class KnifeEntity
extends AbstractArrowEntity {
    protected static final DataParameter<ItemStack> DATA_ITEM_STACK = EntityDataManager.func_187226_a(KnifeEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    protected int hitTime = -1;

    public KnifeEntity(EntityType<? extends AbstractArrowEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public KnifeEntity(World world, double x, double y, double z, ItemStack stack) {
        super(CoreReferences.KNIFE_ENTITY, x, y, z, world);
        this.field_70180_af.func_187227_b(DATA_ITEM_STACK, (Object)stack.func_77946_l());
    }

    public KnifeEntity(World world, LivingEntity owner, ItemStack stack) {
        super(CoreReferences.KNIFE_ENTITY, owner, world);
        this.field_70180_af.func_187227_b(DATA_ITEM_STACK, (Object)stack.func_77946_l());
    }

    public ItemStack func_184550_j() {
        return (ItemStack)this.func_184212_Q().func_187225_a(DATA_ITEM_STACK);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_ITEM_STACK, (Object)ItemStack.field_190927_a);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70071_h_() {
        int loyalty;
        if (this.hitTime >= 0) {
            ++this.hitTime;
        }
        Entity owner = this.func_234616_v_();
        if (this.hitTime > 4 && owner != null && (loyalty = Utils.getItemEnchantmentLevel(Enchantments.field_203193_C, this.func_184550_j())) > 0) {
            if (this.hasReturnOwner()) {
                if (this.hitTime == 5) {
                    this.func_184185_a(SoundEvents.field_203270_il, 10.0f, 1.0f);
                }
                this.func_203045_n(true);
                Vector3d diff = owner.func_174824_e(1.0f).func_178788_d(this.func_213303_ch());
                this.func_226288_n_(this.func_226277_ct_(), this.func_226278_cu_() + diff.field_72448_b * 0.015 * (double)loyalty, this.func_226281_cx_());
                if (this.field_70170_p.field_72995_K) {
                    this.field_70137_T = this.func_226278_cu_();
                }
                this.func_213317_d(this.func_213322_ci().func_186678_a(0.95).func_178787_e(diff.func_72432_b().func_186678_a((double)(0.05f * (float)loyalty))));
            } else {
                if (!this.field_70170_p.field_72995_K && this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
                    this.func_70099_a(this.func_184550_j(), 0.1f);
                }
                this.func_70106_y();
            }
        }
        super.func_70071_h_();
    }

    protected boolean hasReturnOwner() {
        Entity owner = this.func_234616_v_();
        return owner != null && owner.func_70089_S() && (!(owner instanceof ServerPlayerEntity) || !owner.func_175149_v());
    }

    @Nullable
    protected EntityRayTraceResult func_213866_a(Vector3d start, Vector3d end) {
        return this.hitTime >= 0 ? null : super.func_213866_a(start, end);
    }

    protected void func_230299_a_(BlockRayTraceResult result) {
        this.hitTime = 0;
        super.func_230299_a_(result);
        this.func_213869_a(this.func_213867_k());
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        this.hitTime = 4;
        Entity target = result.func_216348_a();
        ItemStack stack = this.func_184550_j();
        if (stack.func_77973_b() instanceof KnifeItem) {
            float velocity = (float)this.func_213322_ci().func_72433_c();
            float damage = ((KnifeItem)stack.func_77973_b()).func_200894_d();
            damage = (float)MathHelper.clamp((double)(velocity * damage), 0.0, (double)(damage * 3.0f));
            if (target instanceof LivingEntity) {
                damage += EnchantmentHelper.func_152377_a((ItemStack)stack, (CreatureAttribute)((LivingEntity)target).func_70668_bt());
            }
            Entity owner = this.func_234616_v_();
            if (target.func_70097_a(this.damageSource(), damage)) {
                if (target.func_200600_R() == EntityType.field_200803_q) {
                    return;
                }
                if (target instanceof PartEntity) {
                    target = ((PartEntity)target).getParent();
                }
                if (target instanceof LivingEntity) {
                    LivingEntity livingTarget = (LivingEntity)target;
                    if (owner instanceof LivingEntity) {
                        EnchantmentHelper.func_151384_a((LivingEntity)livingTarget, (Entity)owner);
                        EnchantmentHelper.func_151385_b((LivingEntity)((LivingEntity)owner), (Entity)livingTarget);
                        if (owner instanceof PlayerEntity) {
                            stack.func_77961_a(livingTarget, (PlayerEntity)owner);
                        }
                    }
                    this.func_184548_a(livingTarget);
                    target.func_70015_d(4 * Utils.getItemEnchantmentLevel(Enchantments.field_77334_n, stack));
                }
            }
            this.func_213317_d(this.func_213322_ci().func_216372_d(-0.01, -0.1, -0.01));
            this.func_184185_a(SoundEvents.field_203268_ij, 1.0f, 1.0f);
        }
    }

    protected SoundEvent func_213867_k() {
        return SoundEvents.field_203269_ik;
    }

    public void func_70100_b_(PlayerEntity player) {
        Entity entity = this.func_234616_v_();
        if (entity == null || entity.func_110124_au() == player.func_110124_au()) {
            super.func_70100_b_(player);
        }
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_150297_b("Knife", 10)) {
            this.field_70180_af.func_187227_b(DATA_ITEM_STACK, (Object)ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Knife")));
        }
        this.hitTime = nbt.func_74762_e("HitTime");
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_218657_a("Knife", (INBT)this.func_184550_j().func_77955_b(new CompoundNBT()));
        nbt.func_74768_a("HitTime", this.hitTime);
    }

    public void func_225516_i_() {
        if (this.field_70251_a != AbstractArrowEntity.PickupStatus.ALLOWED || Utils.getItemEnchantmentLevel(Enchantments.field_203193_C, this.func_184550_j()) <= 0) {
            super.func_225516_i_();
        }
    }

    public boolean inGround() {
        return this.field_70254_i;
    }

    public DamageSource damageSource() {
        return new IndirectEntityDamageSource("knife", (Entity)this, this.func_234616_v_()).func_76349_b();
    }
}

