/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.fluid;

import javax.annotation.Nonnull;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidHandlerRestrictionWrapper
implements IFluidHandler {
    protected IFluidHandler wrappedHandler;
    protected boolean canFill;
    protected boolean canDrain;

    public FluidHandlerRestrictionWrapper(IFluidHandler wrappedHandler, boolean canFill, boolean canDrain) {
        this.wrappedHandler = wrappedHandler;
        this.canFill = canFill;
        this.canDrain = canDrain;
    }

    public int getTanks() {
        return this.wrappedHandler.getTanks();
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.wrappedHandler.getFluidInTank(tank);
    }

    public int getTankCapacity(int tank) {
        return this.wrappedHandler.getTankCapacity(tank);
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.wrappedHandler.isFluidValid(tank, stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.canFill) {
            return 0;
        }
        return this.wrappedHandler.fill(resource, action);
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.canDrain) {
            return FluidStack.EMPTY;
        }
        return this.wrappedHandler.drain(resource, action);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (!this.canDrain) {
            return FluidStack.EMPTY;
        }
        return this.wrappedHandler.drain(maxDrain, action);
    }
}

