/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import java.util.Collection;
import java.util.EnumMap;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockHelper {
    public static final Direction[] DIR_VALUES = Direction.values();
    public static final byte[] SIDE_LEFT = new byte[]{4, 5, 5, 4, 2, 3};
    public static final byte[] SIDE_RIGHT = new byte[]{5, 4, 4, 5, 3, 2};
    public static final byte[] SIDE_OPPOSITE = new byte[]{1, 0, 3, 2, 5, 4};
    public static final byte[] SIDE_ABOVE = new byte[]{3, 2, 1, 1, 1, 1};
    public static final byte[] SIDE_BELOW = new byte[]{2, 3, 0, 0, 0, 0};
    private static final EnumMap<Direction, Direction> SIDE_LEFT_LOOKUP = BlockHelper.computeMap(SIDE_LEFT);
    private static final EnumMap<Direction, Direction> SIDE_RIGHT_LOOKUP = BlockHelper.computeMap(SIDE_RIGHT);
    private static final EnumMap<Direction, Direction> SIDE_OPPOSITE_LOOKUP = BlockHelper.computeMap(SIDE_OPPOSITE);
    private static final EnumMap<Direction, Direction> SIDE_ABOVE_LOOKUP = BlockHelper.computeMap(SIDE_ABOVE);
    private static final EnumMap<Direction, Direction> SIDE_BELOW_LOOKUP = BlockHelper.computeMap(SIDE_BELOW);
    public static final byte[] ROTATE_CLOCK_Y = new byte[]{0, 1, 4, 5, 3, 2};
    public static final byte[] ROTATE_CLOCK_Z = new byte[]{5, 4, 2, 3, 0, 1};
    public static final byte[] ROTATE_CLOCK_X = new byte[]{2, 3, 1, 0, 4, 5};
    public static final byte[] ROTATE_COUNTER_Y = new byte[]{0, 1, 5, 4, 2, 3};
    public static final byte[] ROTATE_COUNTER_Z = new byte[]{4, 5, 2, 3, 1, 0};
    public static final byte[] ROTATE_COUNTER_X = new byte[]{3, 2, 0, 1, 4, 5};
    public static final byte[] INVERT_AROUND_Y = new byte[]{0, 1, 3, 2, 5, 4};
    public static final byte[] INVERT_AROUND_Z = new byte[]{1, 0, 2, 3, 5, 4};
    public static final byte[] INVERT_AROUND_X = new byte[]{1, 0, 3, 2, 4, 5};

    private BlockHelper() {
    }

    public static ToIntFunction<BlockState> lightValue(BooleanProperty property, int lightValue) {
        return state -> (Boolean)state.func_177229_b((Property)property) != false ? lightValue : 0;
    }

    public static ToIntFunction<BlockState> lightValue(int lightValue) {
        return state -> lightValue;
    }

    public static TileEntity getAdjacentTileEntity(World world, BlockPos pos, Direction dir) {
        pos = pos.func_177972_a(dir);
        return world == null || !world.func_175667_e(pos) ? null : world.func_175625_s(pos);
    }

    public static TileEntity getAdjacentTileEntity(World world, BlockPos pos, int side) {
        return world == null ? null : BlockHelper.getAdjacentTileEntity(world, pos, DIR_VALUES[side]);
    }

    public static TileEntity getAdjacentTileEntity(TileEntity refTile, Direction dir) {
        return refTile == null ? null : BlockHelper.getAdjacentTileEntity(refTile.func_145831_w(), refTile.func_174877_v(), dir);
    }

    public static boolean attemptRotateBlock(BlockState state, World world, BlockPos pos) {
        BlockState rotState;
        Collection properties = state.func_235904_r_();
        if (properties.contains(BlockStateProperties.field_208142_aq) || properties.contains(BlockStateProperties.field_208139_an) || properties.contains(BlockStateProperties.field_208182_i)) {
            return false;
        }
        if (properties.contains(BlockStateProperties.field_208140_ao) && state.func_177229_b((Property)BlockStateProperties.field_208140_ao) != ChestType.SINGLE) {
            return false;
        }
        if (properties.contains(BlockStateProperties.field_208181_h) && ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208181_h)).booleanValue()) {
            return false;
        }
        if (properties.contains(BlockStateProperties.field_208155_H)) {
            int index = ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H)).func_176745_a();
            for (int i = 1; i < 6; ++i) {
                BlockState rotState2 = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.func_82600_a((int)(index + i)));
                if (rotState2 == state || !rotState2.func_196955_c((IWorldReader)world, pos)) continue;
                world.func_175656_a(pos, rotState2);
                if (rotState2.func_185897_m()) {
                    Block block = rotState2.func_177230_c();
                    world.func_195593_d(pos, block);
                    if (rotState2.func_185893_b((IBlockReader)world, pos, (Direction)rotState2.func_177229_b((Property)BlockStateProperties.field_208155_H)) > 0) {
                        world.func_195593_d(pos.func_177972_a(((Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H)).func_176734_d()), block);
                        world.func_195593_d(pos.func_177972_a(((Direction)rotState2.func_177229_b((Property)BlockStateProperties.field_208155_H)).func_176734_d()), block);
                    }
                }
                return true;
            }
            return true;
        }
        if (properties.contains(BlockStateProperties.field_208157_J)) {
            int index = ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176736_b();
            for (int i = 1; i < 4; ++i) {
                BlockState rotState3 = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.func_176731_b((int)(index + i)));
                if (rotState3 == state || !rotState3.func_196955_c((IWorldReader)world, pos)) continue;
                world.func_175656_a(pos, rotState3);
                if (rotState3.func_185897_m()) {
                    Block block = rotState3.func_177230_c();
                    world.func_195593_d(pos, block);
                    if (rotState3.func_185893_b((IBlockReader)world, pos, (Direction)rotState3.func_177229_b((Property)BlockStateProperties.field_208157_J)) > 0) {
                        world.func_195593_d(pos.func_177972_a(((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176734_d()), block);
                        world.func_195593_d(pos.func_177972_a(((Direction)rotState3.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176734_d()), block);
                    }
                }
                return true;
            }
            return true;
        }
        if (properties.contains(BlockStateProperties.field_208148_A)) {
            BlockState rotState4;
            switch ((Direction.Axis)state.func_177229_b((Property)BlockStateProperties.field_208148_A)) {
                case Y: {
                    rotState4 = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)Direction.Axis.X);
                    break;
                }
                case X: {
                    rotState4 = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)Direction.Axis.Z);
                    break;
                }
                default: {
                    rotState4 = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)Direction.Axis.Y);
                }
            }
            if (rotState4 != state && rotState4.func_196955_c((IWorldReader)world, pos)) {
                world.func_175656_a(pos, rotState4);
            }
            return true;
        }
        if (properties.contains(BlockStateProperties.field_208156_I)) {
            BlockState rotState5 = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208156_I, (Comparable)Rotation.CLOCKWISE_90.func_185831_a((Direction)state.func_177229_b((Property)BlockStateProperties.field_208156_I)));
            if (rotState5 != state && rotState5.func_196955_c((IWorldReader)world, pos)) {
                world.func_175656_a(pos, rotState5);
            }
            return true;
        }
        if (properties.contains(BlockStateProperties.field_208138_am) && (rotState = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208138_am, (Comparable)Integer.valueOf(((Integer)state.func_177229_b((Property)BlockStateProperties.field_208138_am) + 1) % 16))) != state && rotState.func_196955_c((IWorldReader)world, pos)) {
            world.func_175656_a(pos, rotState);
            return true;
        }
        if (state.func_177230_c() instanceof AbstractRailBlock && (rotState = state.rotate((IWorld)world, pos, Rotation.CLOCKWISE_90)) != state && rotState.func_196955_c((IWorldReader)world, pos)) {
            world.func_175656_a(pos, rotState);
            return true;
        }
        return false;
    }

    public static Direction left(Direction face) {
        return SIDE_LEFT_LOOKUP.get(face);
    }

    public static Direction right(Direction face) {
        return SIDE_RIGHT_LOOKUP.get(face);
    }

    public static Direction opposite(Direction face) {
        return SIDE_OPPOSITE_LOOKUP.get(face);
    }

    public static Direction above(Direction face) {
        return SIDE_ABOVE_LOOKUP.get(face);
    }

    public static Direction below(Direction face) {
        return SIDE_BELOW_LOOKUP.get(face);
    }

    public static boolean isAxial(BlockPos pos) {
        return pos.func_177958_n() == 0 ? pos.func_177956_o() == 0 || pos.func_177952_p() == 0 : pos.func_177956_o() == 0 && pos.func_177952_p() == 0;
    }

    @Nullable
    public static Direction getSide(BlockPos pos) {
        if (!BlockHelper.isAxial(pos)) {
            return null;
        }
        if (pos.func_177956_o() < 0) {
            return Direction.DOWN;
        }
        if (pos.func_177956_o() > 0) {
            return Direction.UP;
        }
        if (pos.func_177952_p() < 0) {
            return Direction.NORTH;
        }
        if (pos.func_177952_p() > 0) {
            return Direction.SOUTH;
        }
        if (pos.func_177958_n() < 0) {
            return Direction.WEST;
        }
        if (pos.func_177958_n() > 0) {
            return Direction.EAST;
        }
        return null;
    }

    private static EnumMap<Direction, Direction> computeMap(byte[] arr) {
        EnumMap<Direction, Direction> map = new EnumMap<Direction, Direction>(Direction.class);
        for (int i = 0; i < 6; ++i) {
            map.put(DIR_VALUES[i], DIR_VALUES[arr[i]]);
        }
        return map;
    }
}

