/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.event;

import cofh.lib.util.references.CoreReferences;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cofh_core")
public class ArmorEvents {
    private static final Object2ObjectOpenHashMap<Item, Double> FALL_RESISTANCE_MAP = new Object2ObjectOpenHashMap();
    private static final Object2ObjectOpenHashMap<Item, Double> HAZARD_RESISTANCE_MAP = new Object2ObjectOpenHashMap();
    private static final Set<String> HAZARD_DAMAGE_TYPES = new ObjectOpenHashSet();
    private static final Set<Effect> HAZARD_EFFECTS = new ObjectOpenHashSet();
    private static final Object2ObjectOpenHashMap<Item, Double> STING_RESISTANCE_MAP = new Object2ObjectOpenHashMap();
    private static final Set<String> STING_DAMAGE_TYPES = new ObjectOpenHashSet();

    private ArmorEvents() {
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleLivingAttackEvent(LivingAttackEvent event) {
        double stingRes;
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        float amount = event.getAmount();
        double hazRes = ArmorEvents.getHazardResistance((Entity)entity);
        if (hazRes > 0.0 && (source.func_76347_k() || HAZARD_DAMAGE_TYPES.contains(source.func_76355_l())) && entity.func_70681_au().nextDouble() < hazRes) {
            entity.func_70066_B();
            ArmorEvents.attemptDamagePlayerArmor((Entity)entity, amount);
            event.setCanceled(true);
        }
        if ((stingRes = ArmorEvents.getStingResistance((Entity)entity)) > 0.0 && STING_DAMAGE_TYPES.contains(source.func_76355_l()) && entity.func_70681_au().nextDouble() < stingRes) {
            ArmorEvents.attemptDamagePlayerArmor((Entity)entity, amount);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleLivingFallEvent(LivingFallEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        double fallRes = ArmorEvents.getFallResistance((Entity)entity);
        if (fallRes != 0.0) {
            event.setDistance(Math.max(0.0f, event.getDistance() - (float)fallRes));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handlePotionApplicableEvent(PotionEvent.PotionApplicableEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        EffectInstance effect = event.getPotionEffect();
        double hazRes = ArmorEvents.getHazardResistance((Entity)entity);
        if (hazRes > 0.0 && HAZARD_EFFECTS.contains(effect.func_188419_a()) && entity.func_70681_au().nextDouble() < hazRes) {
            ArmorEvents.attemptDamagePlayerArmor((Entity)entity, (float)((1 + effect.func_76458_c()) * effect.func_76459_b()) / 40.0f);
            event.setResult(Event.Result.DENY);
        }
    }

    private static void attemptDamagePlayerArmor(Entity entity, float amount) {
        if (entity instanceof PlayerEntity && 100.0f * entity.field_70170_p.field_73012_v.nextFloat() < amount) {
            ((PlayerEntity)entity).field_71071_by.func_234563_a_(DamageSource.field_76377_j, Math.min(20.0f, amount));
        }
    }

    private static double getFallResistance(Entity entity) {
        double ret = 0.0;
        for (ItemStack armor : entity.func_184193_aE()) {
            ret += ((Double)FALL_RESISTANCE_MAP.getOrDefault((Object)armor.func_77973_b(), (Object)0.0)).doubleValue();
        }
        return ret;
    }

    private static double getHazardResistance(Entity entity) {
        double ret = 0.0;
        for (ItemStack armor : entity.func_184193_aE()) {
            ret += ((Double)HAZARD_RESISTANCE_MAP.getOrDefault((Object)armor.func_77973_b(), (Object)0.0)).doubleValue();
        }
        return ret;
    }

    private static double getStingResistance(Entity entity) {
        double ret = 0.0;
        for (ItemStack armor : entity.func_184193_aE()) {
            ret += ((Double)STING_RESISTANCE_MAP.getOrDefault((Object)armor.func_77973_b(), (Object)0.0)).doubleValue();
        }
        return ret;
    }

    public static void registerFallResistArmor(Item armor, double resistance) {
        FALL_RESISTANCE_MAP.put((Object)armor, (Object)resistance);
    }

    public static void registerHazardResistArmor(Item armor, double resistance) {
        HAZARD_RESISTANCE_MAP.put((Object)armor, (Object)resistance);
    }

    public static void registerStingResistArmor(Item armor, double resistance) {
        STING_RESISTANCE_MAP.put((Object)armor, (Object)resistance);
    }

    public static void setup() {
        STING_DAMAGE_TYPES.add("sting");
        STING_DAMAGE_TYPES.add("cactus");
        STING_DAMAGE_TYPES.add("sweetBerryBush");
        HAZARD_DAMAGE_TYPES.add("lightningBolt");
        HAZARD_DAMAGE_TYPES.add("cold");
        HAZARD_DAMAGE_TYPES.add("lightning");
        HAZARD_EFFECTS.add(Effects.field_76436_u);
        HAZARD_EFFECTS.add(Effects.field_82731_v);
        HAZARD_EFFECTS.add(CoreReferences.CHILLED);
        HAZARD_EFFECTS.add(CoreReferences.SHOCKED);
    }
}

