/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.init.CoreConfig;
import cofh.lib.item.ICoFHItem;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.helpers.StringHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemCoFH
extends Item
implements ICoFHItem {
    protected BooleanSupplier showInGroups = Constants.TRUE;
    protected BooleanSupplier showEnchantEffect = Constants.TRUE;
    protected int burnTime = -1;
    protected int enchantability;

    public ItemCoFH(Item.Properties builder) {
        super(builder);
    }

    public ItemCoFH setEnchantability(int enchantability) {
        this.enchantability = enchantability;
        return this;
    }

    public ItemCoFH setBurnTime(int burnTime) {
        this.burnTime = burnTime;
        return this;
    }

    public ItemCoFH setShowInGroups(BooleanSupplier showInGroups) {
        this.showInGroups = showInGroups;
        return this;
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.showInGroups.getAsBoolean()) {
            return;
        }
        super.func_150895_a(group, items);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ArrayList<ITextComponent> additionalTooltips = new ArrayList<ITextComponent>();
        this.tooltipDelegate(stack, worldIn, additionalTooltips, flagIn);
        if (!additionalTooltips.isEmpty()) {
            if (Screen.func_231173_s_() || CoreConfig.alwaysShowDetails) {
                tooltip.addAll(additionalTooltips);
            } else if (CoreConfig.holdShiftForDetails) {
                tooltip.add((ITextComponent)StringHelper.getTextComponent("info.cofh.hold_shift_for_details").func_240699_a_(TextFormatting.GRAY));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.showEnchantEffect.getAsBoolean() && stack.func_77948_v();
    }

    public boolean func_77616_k(ItemStack stack) {
        return this.getItemEnchantability(stack) > 0;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.enchantability;
    }

    public int getBurnTime(ItemStack itemStack) {
        return this.burnTime;
    }
}

