/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.block.impl;

import cofh.lib.util.constants.Constants;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AttachedStemBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class SoilBlock
extends Block {
    protected static final VoxelShape SHAPE_TILLED = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    public SoilBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)Constants.CHARGED, (Comparable)Integer.valueOf(0)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{Constants.CHARGED});
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        BlockPos abovePos = pos.func_177984_a();
        BlockState aboveState = worldIn.func_180495_p(abovePos);
        if (aboveState.func_177230_c() instanceof IPlantable && aboveState.func_204519_t()) {
            int charge = (Integer)state.func_177229_b((Property)Constants.CHARGED);
            int boost = 1 + charge;
            for (int i = 0; i < boost; ++i) {
                aboveState.func_227034_b_(worldIn, abovePos, rand);
            }
            if (rand.nextInt(boost) > 0) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)Constants.CHARGED, (Comparable)Integer.valueOf(Math.max(0, charge - 1))), 2);
            }
        }
    }

    public static void charge(BlockState state, World worldIn, BlockPos pos) {
        int charge = (Integer)state.func_177229_b((Property)Constants.CHARGED);
        if (charge < 4) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)Constants.CHARGED, (Comparable)Integer.valueOf(charge + 1)), 2);
        } else if (worldIn instanceof ServerWorld) {
            state.func_177230_c().func_225534_a_(state, (ServerWorld)worldIn, pos, worldIn.field_73012_v);
        }
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        return this.canSustainPlant(state, world, pos, facing, plantable, false);
    }

    protected boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable, boolean tilled) {
        if (plantable.getPlant(world, pos.func_177972_a(facing)).func_177230_c() instanceof AttachedStemBlock) {
            return true;
        }
        PlantType type = plantable.getPlantType(world, pos.func_177984_a());
        if (type == PlantType.CROP) {
            return tilled;
        }
        if (type == PlantType.CAVE || type == PlantType.DESERT || type == PlantType.PLAINS || type == Constants.FUNGUS) {
            return !tilled;
        }
        if (type == PlantType.BEACH) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos qPos = pos.func_177972_a(direction);
                if (!world.func_204610_c(qPos).func_206884_a((ITag)FluidTags.field_206959_a) && world.func_180495_p(qPos).func_177230_c() != Blocks.field_185778_de) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFertile(BlockState state, IBlockReader world, BlockPos pos) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isViewBlocking(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return true;
    }
}

