/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.inventory;

import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.inventory.ManagedItemHandler;
import cofh.lib.inventory.SimpleItemHandler;
import cofh.lib.inventory.SimpleItemInv;
import cofh.lib.util.IInventoryCallback;
import cofh.lib.util.StorageGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class ManagedItemInv
extends SimpleItemInv {
    protected List<ItemStorageCoFH> inputSlots = new ArrayList<ItemStorageCoFH>();
    protected List<ItemStorageCoFH> catalystSlots = new ArrayList<ItemStorageCoFH>();
    protected List<ItemStorageCoFH> outputSlots = new ArrayList<ItemStorageCoFH>();
    protected List<ItemStorageCoFH> internalSlots = new ArrayList<ItemStorageCoFH>();
    protected IItemHandler inputHandler;
    protected IItemHandler outputHandler;
    protected IItemHandler accessibleHandler;
    protected IItemHandler internalHandler;
    protected IItemHandler allHandler;

    public ManagedItemInv(IInventoryCallback tile) {
        super(tile);
    }

    public ManagedItemInv(IInventoryCallback tile, String tag) {
        super(tile, tag);
    }

    public void addSlots(StorageGroup group, int amount) {
        for (int i = 0; i < amount; ++i) {
            this.addSlot(new ItemStorageCoFH(), group);
        }
    }

    public void addSlots(StorageGroup group, int amount, Predicate<ItemStack> validator) {
        for (int i = 0; i < amount; ++i) {
            this.addSlot(new ItemStorageCoFH(validator), group);
        }
    }

    public void addSlot(ItemStorageCoFH slot, StorageGroup group) {
        if (this.allHandler != null) {
            return;
        }
        this.slots.add(slot);
        switch (group) {
            case CATALYST: {
                this.catalystSlots.add(slot);
            }
            case INPUT: {
                this.inputSlots.add(slot);
                break;
            }
            case OUTPUT: {
                this.outputSlots.add(slot);
                break;
            }
            case INTERNAL: {
                this.internalSlots.add(slot);
                break;
            }
            case ACCESSIBLE: {
                this.inputSlots.add(slot);
                this.outputSlots.add(slot);
                break;
            }
        }
    }

    protected void optimize() {
        ((ArrayList)this.slots).trimToSize();
        ((ArrayList)this.inputSlots).trimToSize();
        ((ArrayList)this.catalystSlots).trimToSize();
        ((ArrayList)this.outputSlots).trimToSize();
        ((ArrayList)this.internalSlots).trimToSize();
    }

    public void initHandlers() {
        this.optimize();
        this.inputHandler = new ManagedItemHandler(this.tile, this.inputSlots, Collections.emptyList());
        this.outputHandler = new ManagedItemHandler(this.tile, Collections.emptyList(), this.outputSlots);
        this.accessibleHandler = new ManagedItemHandler(this.tile, this.inputSlots, this.outputSlots).restrict();
        this.internalHandler = new SimpleItemHandler(this.tile, this.internalSlots);
        this.allHandler = new SimpleItemHandler(this.tile, this.slots);
    }

    public boolean hasInputSlots() {
        return this.inputSlots.size() > 0;
    }

    public boolean hasOutputSlots() {
        return this.outputSlots.size() > 0;
    }

    public boolean hasAccessibleSlots() {
        return this.hasInputSlots() || this.hasOutputSlots();
    }

    public List<ItemStorageCoFH> getInputSlots() {
        return this.inputSlots;
    }

    public List<ItemStorageCoFH> getOutputSlots() {
        return this.outputSlots;
    }

    public List<ItemStorageCoFH> getInternalSlots() {
        return this.internalSlots;
    }

    public IItemHandler getHandler(StorageGroup group) {
        if (this.allHandler == null) {
            this.initHandlers();
        }
        switch (group) {
            case INPUT: {
                return this.inputHandler;
            }
            case OUTPUT: {
                return this.outputHandler;
            }
            case ACCESSIBLE: {
                return this.accessibleHandler;
            }
            case INTERNAL: {
                return this.internalHandler;
            }
            case ALL: {
                return this.allHandler;
            }
        }
        return EmptyHandler.INSTANCE;
    }
}

