/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.lib.capability.CapabilityArchery;
import cofh.lib.capability.IArcheryAmmoItem;
import cofh.lib.capability.IArcheryBowItem;
import cofh.lib.capability.templates.ArcheryAmmoItemWrapper;
import cofh.lib.capability.templates.ArcheryBowItemWrapper;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.references.EnsorcReferences;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.stats.Stats;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public final class ArcheryHelper {
    private ArcheryHelper() {
    }

    public static boolean validBow(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151031_f || stack.getCapability(CapabilityArchery.BOW_ITEM_CAPABILITY).isPresent();
    }

    public static boolean isArrow(ItemStack stack) {
        return stack.func_77973_b() instanceof ArrowItem;
    }

    public static boolean isSimpleArrow(ItemStack stack) {
        return stack.func_77973_b().equals(Items.field_151032_g);
    }

    public static boolean fireArrow(ItemStack bow, ItemStack ammo, PlayerEntity shooter, int charge, World world) {
        boolean infinite;
        IArcheryBowItem bowCap = (IArcheryBowItem)bow.getCapability(CapabilityArchery.BOW_ITEM_CAPABILITY).orElse((Object)new ArcheryBowItemWrapper(bow));
        IArcheryAmmoItem ammoCap = (IArcheryAmmoItem)ammo.getCapability(CapabilityArchery.AMMO_ITEM_CAPABILITY).orElse((Object)new ArcheryAmmoItemWrapper(ammo));
        boolean bl = infinite = shooter.field_71075_bZ.field_75098_d || ammoCap.isInfinite(bow, shooter) || ArcheryHelper.isArrow(ammo) && ((ArrowItem)ammo.func_77973_b()).isInfinite(ammo, bow, shooter) || ammo.func_190926_b() && Utils.getItemEnchantmentLevel(Enchantments.field_185312_x, bow) > 0;
        if (!ammo.func_190926_b() || infinite) {
            if (ammo.func_190926_b()) {
                ammo = new ItemStack((IItemProvider)Items.field_151032_g);
            }
            float arrowVelocity = BowItem.func_185059_b((int)charge);
            float accuracyMod = bowCap.getAccuracyModifier(shooter);
            float damageMod = bowCap.getDamageModifier(shooter);
            float velocityMod = bowCap.getVelocityModifier(shooter);
            if (arrowVelocity >= 0.1f) {
                if (Utils.isServerWorld(world)) {
                    int encVolley = Utils.getItemEnchantmentLevel(EnsorcReferences.VOLLEY, bow);
                    int encTrueshot = Utils.getItemEnchantmentLevel(EnsorcReferences.TRUESHOT, bow);
                    int encPunch = Utils.getItemEnchantmentLevel(Enchantments.field_185310_v, bow);
                    int encPower = Utils.getItemEnchantmentLevel(Enchantments.field_185309_u, bow);
                    int encFlame = Utils.getItemEnchantmentLevel(Enchantments.field_185311_w, bow);
                    if (encTrueshot > 0) {
                        accuracyMod *= 1.5f / (float)(1 + encTrueshot);
                        damageMod *= 1.0f + 0.25f * (float)encTrueshot;
                        arrowVelocity = MathHelper.clamp(0.1f, arrowVelocity + 0.05f * (float)encTrueshot, 1.75f);
                    }
                    int numArrows = encVolley > 0 ? 3 : 1;
                    float volleyPitch = encVolley > 0 ? MathHelper.clamp(90.0f + shooter.field_70125_A / (float)encVolley, 0.0f, 5.0f) : 0.0f;
                    BowItem bowItem = bow.func_77973_b() instanceof BowItem ? (BowItem)bow.func_77973_b() : null;
                    for (int shot = 0; shot < numArrows; ++shot) {
                        AbstractArrowEntity arrow = ArcheryHelper.createArrow(world, ammo, shooter);
                        if (bowItem != null) {
                            arrow = bowItem.customArrow(arrow);
                        }
                        arrow.func_234612_a_((Entity)shooter, shooter.field_70125_A - volleyPitch * (float)shot, shooter.field_70177_z, 0.0f, arrowVelocity * 3.0f * velocityMod, accuracyMod);
                        arrow.func_70239_b(arrow.func_70242_d() * (double)damageMod);
                        if (arrowVelocity >= 1.0f) {
                            arrow.func_70243_d(true);
                        }
                        if (encTrueshot > 0) {
                            arrow.func_213872_b((byte)encTrueshot);
                        }
                        if (encPower > 0 && arrow.func_70242_d() > 0.0) {
                            arrow.func_70239_b(arrow.func_70242_d() + (double)encPower * 0.5 + 0.5);
                        }
                        if (encPunch > 0) {
                            arrow.func_70240_a(encPunch);
                        }
                        if (encFlame > 0) {
                            arrow.func_70015_d(100);
                        }
                        if (infinite || shot > 0) {
                            arrow.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                        }
                        world.func_217376_c((Entity)arrow);
                    }
                    bowCap.onArrowLoosed(shooter);
                }
                world.func_184148_a(null, shooter.func_226277_ct_(), shooter.func_226278_cu_(), shooter.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (world.field_73012_v.nextFloat() * 0.4f + 1.2f) + arrowVelocity * 0.5f);
                if (!infinite && !shooter.field_71075_bZ.field_75098_d) {
                    ammoCap.onArrowLoosed(shooter);
                    if (ammo.func_190926_b()) {
                        shooter.field_71071_by.func_184437_d(ammo);
                    }
                }
                shooter.func_71029_a(Stats.field_75929_E.func_199076_b((Object)bow.func_77973_b()));
            }
            return true;
        }
        return false;
    }

    public static AbstractArrowEntity createArrow(World world, ItemStack ammo, PlayerEntity shooter) {
        LazyOptional ammoCap = ammo.getCapability(CapabilityArchery.AMMO_ITEM_CAPABILITY);
        return ammoCap.map(cap -> cap.createArrowEntity(world, shooter)).orElse(ArcheryHelper.createDefaultArrow(world, ammo, shooter));
    }

    public static AbstractArrowEntity createDefaultArrow(World world, ItemStack ammo, PlayerEntity shooter) {
        return ArcheryHelper.isArrow(ammo) ? ((ArrowItem)ammo.func_77973_b()).func_200887_a(world, ammo, (LivingEntity)shooter) : ((ArrowItem)Items.field_151032_g).func_200887_a(world, ammo, (LivingEntity)shooter);
    }

    public static ItemStack findAmmo(PlayerEntity shooter) {
        ItemStack offHand = shooter.func_184592_cb();
        ItemStack mainHand = shooter.func_184614_ca();
        if (offHand.getCapability(CapabilityArchery.AMMO_ITEM_CAPABILITY).map(cap -> !cap.isEmpty(shooter)).orElse(false).booleanValue() || ArcheryHelper.isArrow(offHand)) {
            return offHand;
        }
        if (mainHand.getCapability(CapabilityArchery.AMMO_ITEM_CAPABILITY).map(cap -> !cap.isEmpty(shooter)).orElse(false).booleanValue() || ArcheryHelper.isArrow(mainHand)) {
            return mainHand;
        }
        for (ItemStack slot : shooter.field_71071_by.field_70462_a) {
            if (!slot.getCapability(CapabilityArchery.AMMO_ITEM_CAPABILITY).map(cap -> !cap.isEmpty(shooter)).orElse(false).booleanValue() && !ArcheryHelper.isArrow(slot)) continue;
            return slot;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack findArrows(PlayerEntity shooter) {
        ItemStack offHand = shooter.func_184592_cb();
        ItemStack mainHand = shooter.func_184614_ca();
        if (ArcheryHelper.isSimpleArrow(offHand)) {
            return offHand;
        }
        if (ArcheryHelper.isSimpleArrow(mainHand)) {
            return mainHand;
        }
        for (int i = 0; i < shooter.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = shooter.field_71071_by.func_70301_a(i);
            if (!ArcheryHelper.isSimpleArrow(stack)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }
}

