/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.common.logic.entityblocking;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.xalcon.torchmaster.Torchmaster;
import net.xalcon.torchmaster.common.ModCaps;
import net.xalcon.torchmaster.common.commands.TorchInfo;
import net.xalcon.torchmaster.common.logic.entityblocking.IEntityBlockingLight;
import net.xalcon.torchmaster.common.logic.entityblocking.ILightSerializer;
import net.xalcon.torchmaster.common.logic.entityblocking.ITEBLightRegistry;
import net.xalcon.torchmaster.common.logic.entityblocking.LightSerializerRegistry;

public class LightsRegistryCapability
implements ICapabilityProvider,
ICapabilitySerializable<CompoundNBT> {
    private ITEBLightRegistry container = new RegistryContainer();
    private LazyOptional optional = LazyOptional.of(() -> this.container);

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ModCaps.TEB_REGISTRY) {
            return this.optional;
        }
        return LazyOptional.empty();
    }

    public static Callable<ITEBLightRegistry> getDefaultFactory() {
        return () -> new RegistryContainer();
    }

    public CompoundNBT serializeNBT() {
        return (CompoundNBT)this.container.serializeNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.container.deserializeNBT((INBT)nbt);
    }

    private static class RegistryContainer
    implements ITEBLightRegistry {
        private HashMap<String, IEntityBlockingLight> lights = new HashMap();
        private int tickCounter;

        private RegistryContainer() {
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT nbt = new CompoundNBT();
            ILightSerializer serializer = null;
            String cachedSerializerKey = null;
            for (Map.Entry<String, IEntityBlockingLight> lightEntry : this.lights.entrySet()) {
                IEntityBlockingLight light = lightEntry.getValue();
                String lightKey = lightEntry.getKey();
                String serializerKey = light.getLightSerializerKey();
                if (serializerKey == null) {
                    Torchmaster.Log.error("Unable to serialize light '{}', the serializer was null", (Object)lightKey);
                    continue;
                }
                if (!serializerKey.equals(cachedSerializerKey)) {
                    serializer = LightSerializerRegistry.getLightSerializer(serializerKey);
                    cachedSerializerKey = serializerKey;
                }
                if (serializer == null) {
                    Torchmaster.Log.error("Unable to serialize light '{}', the serializer '{}' was not found", (Object)lightKey, (Object)serializerKey);
                    continue;
                }
                try {
                    CompoundNBT lightNbt = serializer.serializeLight(lightKey, light);
                    if (lightNbt == null) {
                        Torchmaster.Log.error("Unable to serialize light '{}', the serializer '{}' returned null", (Object)lightKey, (Object)serializerKey);
                        continue;
                    }
                    lightNbt.func_74778_a("lightSerializerKey", serializerKey);
                    nbt.func_218657_a(lightKey, (INBT)lightNbt);
                }
                catch (Exception ex) {
                    Torchmaster.Log.error("The serializer '{}' threw an error during serialization!", (Object)serializerKey);
                    Torchmaster.Log.error((Object)ex);
                }
            }
            return nbt;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.lights.clear();
            ILightSerializer serializer = null;
            String cachedSerializerKey = null;
            for (String lightKey : nbt.func_150296_c()) {
                CompoundNBT lightNbt = nbt.func_74775_l(lightKey);
                String serializerKey = lightNbt.func_74779_i("lightSerializerKey");
                if (!serializerKey.equals(cachedSerializerKey)) {
                    serializer = LightSerializerRegistry.getLightSerializer(serializerKey);
                    cachedSerializerKey = serializerKey;
                }
                if (serializer == null) {
                    Torchmaster.Log.error("Unable to deserialize the light '{}', the serializer '{}' was not found", (Object)lightKey, (Object)serializerKey);
                    continue;
                }
                try {
                    IEntityBlockingLight light = serializer.deserializeLight(lightKey, lightNbt);
                    if (light == null) {
                        Torchmaster.Log.error("Unable to deserialize the light '{}', the serializer returned null", (Object)lightKey);
                        continue;
                    }
                    this.lights.put(lightKey, light);
                }
                catch (Exception ex) {
                    Torchmaster.Log.error("The serializer '{}' threw an error during deserialization!", (Object)serializerKey);
                    Torchmaster.Log.error((Object)ex);
                }
            }
        }

        @Override
        public boolean shouldBlockEntity(Entity entity, BlockPos pos) {
            for (Map.Entry<String, IEntityBlockingLight> lightEntry : this.lights.entrySet()) {
                IEntityBlockingLight light = lightEntry.getValue();
                if (!light.shouldBlockEntity(entity, pos)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void registerLight(String lightKey, IEntityBlockingLight light) {
            if (lightKey == null) {
                throw new IllegalArgumentException("lightKey must not be null");
            }
            if (light == null) {
                throw new IllegalArgumentException("light must not be null");
            }
            this.lights.put(lightKey, light);
        }

        @Override
        public void unregisterLight(String lightKey) {
            this.lights.remove(lightKey);
        }

        @Override
        @Nullable
        public IEntityBlockingLight getLight(String lightKey) {
            return this.lights.get(lightKey);
        }

        @Override
        public void onGlobalTick(World world) {
            if (this.tickCounter++ < 200) {
                return;
            }
            this.tickCounter = 0;
            this.lights.entrySet().removeIf(l -> ((IEntityBlockingLight)l.getValue()).cleanupCheck(world));
        }

        @Override
        public TorchInfo[] getEntries() {
            return (TorchInfo[])this.lights.values().stream().map(x -> new TorchInfo(x.getName(), x.getPos())).toArray(TorchInfo[]::new);
        }
    }
}

