/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.map.markers;

import java.util.Objects;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.map.CustomDecoration;
import net.mehvahdjukaar.selene.map.CustomDecorationType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class MapWorldMarker<D extends CustomDecoration> {
    private final CustomDecorationType<D, ?> type;
    public BlockPos pos;

    public MapWorldMarker(CustomDecorationType<D, ?> type) {
        this.type = type;
    }

    public void loadFromNBT(CompoundNBT compound) {
        this.pos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("Pos"));
    }

    public CompoundNBT saveToNBT(CompoundNBT compound) {
        compound.func_218657_a("Pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.getPos()));
        return compound;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && this.getClass() == other.getClass()) {
            MapWorldMarker marker = (MapWorldMarker)other;
            return Objects.equals(this.getPos(), marker.getPos());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getPos());
    }

    private String getPosSuffix() {
        return this.pos.func_177958_n() + "," + this.pos.func_177956_o() + "," + this.pos.func_177952_p();
    }

    public CustomDecorationType<D, ?> getType() {
        return this.type;
    }

    public String getTypeId() {
        return this.type.getRegistryId();
    }

    public String getMarkerId() {
        return this.getTypeId() + "-" + this.getPosSuffix();
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    public int getRotation() {
        return 0;
    }

    @Nullable
    protected abstract D doCreateDecoration(byte var1, byte var2, byte var3);

    @Nullable
    public D createDecorationFromMarker(byte scale, int x, int z, RegistryKey<World> dimension, boolean locked) {
        double worldX = this.getPos().func_177958_n();
        double worldZ = this.getPos().func_177952_p();
        double rotation = this.getRotation();
        int i = 1 << scale;
        float f = (float)(worldX - (double)x) / (float)i;
        float f1 = (float)(worldZ - (double)z) / (float)i;
        byte mapX = (byte)((double)(f * 2.0f) + 0.5);
        byte mapY = (byte)((double)(f1 * 2.0f) + 0.5);
        if (f >= -64.0f && f1 >= -64.0f && f <= 64.0f && f1 <= 64.0f) {
            byte rot = (byte)((rotation += rotation < 0.0 ? -8.0 : 8.0) * 16.0 / 360.0);
            return this.doCreateDecoration(mapX, mapY, rot);
        }
        return null;
    }

    public boolean shouldUpdate(MapWorldMarker<?> other) {
        return false;
    }

    public void updateDecoration(CustomDecoration old) {
    }
}

