/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid;

import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.vsngamer.elevatorid.blocks.ElevatorBlock;
import xyz.vsngamer.elevatorid.init.ModConfig;
import xyz.vsngamer.elevatorid.network.NetworkHandler;
import xyz.vsngamer.elevatorid.network.TeleportHandler;
import xyz.vsngamer.elevatorid.network.TeleportRequest;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="elevatorid")
public class ElevatorHandler {
    private static boolean lastSneaking;

    @SubscribeEvent
    public static void onInput(InputEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || player.func_175149_v() || !player.func_70089_S() || player.field_71158_b == null) {
            return;
        }
        boolean sneaking = player.field_71158_b.field_228350_h_;
        if (lastSneaking != sneaking) {
            lastSneaking = sneaking;
            if (sneaking) {
                ElevatorHandler.tryTeleport(player, Direction.DOWN);
            }
        }
    }

    @SubscribeEvent
    public static void jump(LivingEvent.LivingJumpEvent e) {
        if (e.getEntity() instanceof PlayerEntity && e.getEntity().field_70170_p.field_72995_K) {
            ElevatorHandler.tryTeleport((ClientPlayerEntity)e.getEntity(), Direction.UP);
        }
    }

    private static void tryTeleport(ClientPlayerEntity player, Direction facing) {
        block2: {
            World world = player.func_130014_f_();
            BlockPos fromPos = ElevatorHandler.getOriginElevator(player);
            if (fromPos == null) {
                return;
            }
            BlockPos.Mutable toPos = new BlockPos.Mutable(fromPos.func_177958_n(), fromPos.func_177956_o(), fromPos.func_177952_p());
            ElevatorBlock fromElevator = (ElevatorBlock)world.func_180495_p(fromPos).func_177230_c();
            while (true) {
                toPos.func_185336_p(toPos.func_177956_o() + facing.func_96559_d());
                if (Math.abs(toPos.func_177956_o() - fromPos.func_177956_o()) > (Integer)ModConfig.GENERAL.range.get()) break block2;
                BlockState toState = world.func_180495_p((BlockPos)toPos);
                if (!TeleportHandler.isElevator(toState) || !TeleportHandler.validateTarget((IBlockReader)world, (BlockPos)toPos)) continue;
                ElevatorBlock toElevator = (ElevatorBlock)toState.func_177230_c();
                if (!((Boolean)ModConfig.GENERAL.sameColor.get()).booleanValue() || fromElevator.getColor() == toElevator.getColor()) break;
            }
            NetworkHandler.INSTANCE.sendToServer((Object)new TeleportRequest(fromPos, (BlockPos)toPos));
        }
    }

    private static BlockPos getOriginElevator(ClientPlayerEntity player) {
        World world = player.func_130014_f_();
        BlockPos pos = new BlockPos(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
        for (int i = 0; i < 3; ++i) {
            if (TeleportHandler.isElevator(world.func_180495_p(pos)) && TeleportHandler.validateTarget((IBlockReader)world, pos)) {
                return pos;
            }
            pos = pos.func_177977_b();
        }
        return null;
    }
}

