/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.AbstractOption;
import net.minecraft.client.GameSettings;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.GPUWarningScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.GPUWarning;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GraphicsFanciness;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.optifine.Config;
import net.optifine.Lang;
import net.optifine.gui.GuiAnimationSettingsOF;
import net.optifine.gui.GuiButtonOF;
import net.optifine.gui.GuiDetailSettingsOF;
import net.optifine.gui.GuiOtherSettingsOF;
import net.optifine.gui.GuiPerformanceSettingsOF;
import net.optifine.gui.GuiQualitySettingsOF;
import net.optifine.gui.GuiScreenButtonOF;
import net.optifine.gui.GuiScreenOF;
import net.optifine.gui.TooltipManager;
import net.optifine.gui.TooltipProvider;
import net.optifine.gui.TooltipProviderOptions;
import net.optifine.shaders.gui.GuiShaders;
import net.optifine.util.GuiUtils;
import org.lwjgl.glfw.GLFW;

/*
 * Exception performing whole class analysis ignored.
 */
public class VideoSettingsScreen
extends GuiScreenOF {
    private Screen parentGuiScreen;
    private GameSettings guiGameSettings;
    private static AbstractOption[] videoOptions = new AbstractOption[]{AbstractOption.field_216712_s, AbstractOption.field_216706_m, AbstractOption.field_216709_p, AbstractOption.field_216701_h, AbstractOption.AO_LEVEL, AbstractOption.field_216692_P, AbstractOption.field_216713_t, AbstractOption.field_216683_G, AbstractOption.field_216703_j, AbstractOption.field_216710_q, AbstractOption.DYNAMIC_LIGHTS, AbstractOption.DYNAMIC_FOV};
    private GPUWarning field_241604_x_;
    private static final ITextComponent field_241598_c_ = new TranslationTextComponent("options.graphics.fabulous").func_240699_a_(TextFormatting.ITALIC);
    private static final ITextComponent field_241599_p_ = new TranslationTextComponent("options.graphics.warning.message", new Object[]{field_241598_c_, field_241598_c_});
    private static final ITextComponent field_241600_q_ = new TranslationTextComponent("options.graphics.warning.title").func_240699_a_(TextFormatting.RED);
    private static final ITextComponent field_241601_r_ = new TranslationTextComponent("options.graphics.warning.accept");
    private static final ITextComponent field_241602_s_ = new TranslationTextComponent("options.graphics.warning.cancel");
    private static final ITextComponent field_241603_t_ = new StringTextComponent("\n");
    private TooltipManager tooltipManager = new TooltipManager((Screen)this, (TooltipProvider)new TooltipProviderOptions());
    private List<Widget> buttonList = this.field_230710_m_;
    private Widget buttonGuiScale;

    public VideoSettingsScreen(Screen par1GuiScreen, GameSettings par2GameSettings) {
        super((ITextComponent)new TranslationTextComponent("options.videoTitle"));
        this.parentGuiScreen = par1GuiScreen;
        this.guiGameSettings = par2GameSettings;
        this.field_241604_x_ = this.parentGuiScreen.field_230706_i_.func_241558_U_();
        this.field_241604_x_.func_241702_i_();
        if (this.guiGameSettings.field_238330_f_ == GraphicsFanciness.FABULOUS) {
            this.field_241604_x_.func_241698_e_();
        }
    }

    public void func_231160_c_() {
        this.buttonList.clear();
        for (int i2 = 0; i2 < videoOptions.length; ++i2) {
            AbstractOption opt = videoOptions[i2];
            if (opt == null) continue;
            int x2 = this.field_230708_k_ / 2 - 155 + i2 % 2 * 160;
            int y2 = this.field_230709_l_ / 6 + 21 * (i2 / 2) - 12;
            Widget guiElement = this.func_230480_a_(opt.func_216586_a(this.field_230706_i_.field_71474_y, x2, y2, 150));
            if (opt != AbstractOption.field_216713_t) continue;
            this.buttonGuiScale = guiElement;
        }
        int y3 = this.field_230709_l_ / 6 + 21 * (videoOptions.length / 2) - 12;
        int x3 = 0;
        x3 = this.field_230708_k_ / 2 - 155 + 0;
        this.func_230480_a_((Widget)new GuiScreenButtonOF(231, x3, y3, Lang.get("of.options.shaders")));
        x3 = this.field_230708_k_ / 2 - 155 + 160;
        this.func_230480_a_((Widget)new GuiScreenButtonOF(202, x3, y3, Lang.get("of.options.quality")));
        x3 = this.field_230708_k_ / 2 - 155 + 0;
        this.func_230480_a_((Widget)new GuiScreenButtonOF(201, x3, y3 += 21, Lang.get("of.options.details")));
        x3 = this.field_230708_k_ / 2 - 155 + 160;
        this.func_230480_a_((Widget)new GuiScreenButtonOF(212, x3, y3, Lang.get("of.options.performance")));
        x3 = this.field_230708_k_ / 2 - 155 + 0;
        this.func_230480_a_((Widget)new GuiScreenButtonOF(211, x3, y3 += 21, Lang.get("of.options.animations")));
        x3 = this.field_230708_k_ / 2 - 155 + 160;
        this.func_230480_a_((Widget)new GuiScreenButtonOF(222, x3, y3, Lang.get("of.options.other")));
        y3 += 21;
        this.func_230480_a_((Widget)new GuiButtonOF(200, this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 6 + 168 + 11, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
    }

    protected void actionPerformed(Widget button) {
        if (button == this.buttonGuiScale) {
            this.updateGuiScale();
        }
        this.checkFabulousWarning();
        if (!(button instanceof GuiButtonOF)) {
            return;
        }
        GuiButtonOF gbo = (GuiButtonOF)button;
        this.actionPerformed(gbo, 1);
    }

    private void checkFabulousWarning() {
        if (this.field_241604_x_.func_241700_g_()) {
            String s2;
            String s1;
            ArrayList list = Lists.newArrayList((Object[])new ITextProperties[]{field_241599_p_, field_241603_t_});
            String s3 = this.field_241604_x_.func_241703_j_();
            if (s3 != null) {
                list.add(field_241603_t_);
                list.add(new TranslationTextComponent("options.graphics.warning.renderer", new Object[]{s3}).func_240699_a_(TextFormatting.GRAY));
            }
            if ((s1 = this.field_241604_x_.func_241705_l_()) != null) {
                list.add(field_241603_t_);
                list.add(new TranslationTextComponent("options.graphics.warning.vendor", new Object[]{s1}).func_240699_a_(TextFormatting.GRAY));
            }
            if ((s2 = this.field_241604_x_.func_241704_k_()) != null) {
                list.add(field_241603_t_);
                list.add(new TranslationTextComponent("options.graphics.warning.version", new Object[]{s2}).func_240699_a_(TextFormatting.GRAY));
            }
            this.field_230706_i_.func_147108_a((Screen)new GPUWarningScreen(field_241600_q_, (List)list, ImmutableList.of((Object)new GPUWarningScreen.Option(field_241601_r_, p_241606_1_ -> {
                this.guiGameSettings.field_238330_f_ = GraphicsFanciness.FABULOUS;
                Minecraft.func_71410_x().field_71438_f.func_72712_a();
                this.field_241604_x_.func_241698_e_();
                this.field_230706_i_.func_147108_a((Screen)this);
            }), (Object)new GPUWarningScreen.Option(field_241602_s_, p_241605_1_ -> {
                this.field_241604_x_.func_241699_f_();
                this.field_230706_i_.func_147108_a((Screen)this);
            }))));
        }
    }

    protected void actionPerformedRightClick(Widget button) {
        if (button == this.buttonGuiScale) {
            AbstractOption.field_216713_t.func_216722_a(this.guiGameSettings, -1);
            this.updateGuiScale();
        }
    }

    private void updateGuiScale() {
        this.field_230706_i_.func_213226_a();
        MainWindow mw = this.field_230706_i_.func_228018_at_();
        int btnWidth = GuiUtils.getWidth((Widget)this.buttonGuiScale);
        int btnHeight = GuiUtils.getHeight((Widget)this.buttonGuiScale);
        int x2 = this.buttonGuiScale.field_230690_l_ + (btnWidth - btnHeight);
        int y2 = this.buttonGuiScale.field_230691_m_ + btnHeight / 2;
        GLFW.glfwSetCursorPos((long)mw.func_198092_i(), (double)((double)x2 * mw.func_198100_s()), (double)((double)y2 * mw.func_198100_s()));
    }

    private void actionPerformed(GuiButtonOF button, int val) {
        GuiScreenOF scr;
        if (!button.field_230693_o_) {
            return;
        }
        if (button.id == 200) {
            this.field_230706_i_.field_71474_y.func_74303_b();
            this.field_230706_i_.func_147108_a(this.parentGuiScreen);
        }
        if (button.id == 201) {
            this.field_230706_i_.field_71474_y.func_74303_b();
            scr = new GuiDetailSettingsOF((Screen)this, this.guiGameSettings);
            this.field_230706_i_.func_147108_a((Screen)scr);
        }
        if (button.id == 202) {
            this.field_230706_i_.field_71474_y.func_74303_b();
            scr = new GuiQualitySettingsOF((Screen)this, this.guiGameSettings);
            this.field_230706_i_.func_147108_a((Screen)scr);
        }
        if (button.id == 211) {
            this.field_230706_i_.field_71474_y.func_74303_b();
            scr = new GuiAnimationSettingsOF((Screen)this, this.guiGameSettings);
            this.field_230706_i_.func_147108_a((Screen)scr);
        }
        if (button.id == 212) {
            this.field_230706_i_.field_71474_y.func_74303_b();
            scr = new GuiPerformanceSettingsOF((Screen)this, this.guiGameSettings);
            this.field_230706_i_.func_147108_a((Screen)scr);
        }
        if (button.id == 222) {
            this.field_230706_i_.field_71474_y.func_74303_b();
            scr = new GuiOtherSettingsOF((Screen)this, this.guiGameSettings);
            this.field_230706_i_.func_147108_a((Screen)scr);
        }
        if (button.id == 231) {
            if (Config.isAntialiasing() || Config.isAntialiasingConfigured()) {
                Config.showGuiMessage(Lang.get("of.message.shaders.aa1"), Lang.get("of.message.shaders.aa2"));
                return;
            }
            if (Config.isGraphicsFabulous()) {
                Config.showGuiMessage(Lang.get("of.message.shaders.gf1"), Lang.get("of.message.shaders.gf2"));
                return;
            }
            this.field_230706_i_.field_71474_y.func_74303_b();
            scr = new GuiShaders((Screen)this, this.guiGameSettings);
            this.field_230706_i_.func_147108_a((Screen)scr);
        }
    }

    public void func_231164_f_() {
        this.field_230706_i_.field_71474_y.func_74303_b();
        super.func_231164_f_();
    }

    public void func_230430_a_(MatrixStack matrixStackIn, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStackIn);
        VideoSettingsScreen.func_238472_a_((MatrixStack)matrixStackIn, (FontRenderer)this.field_230706_i_.field_71466_p, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)15, (int)0xFFFFFF);
        String ver = Config.getVersion();
        String ed = "HD_U";
        if (ed.equals("HD")) {
            ver = "OptiFine HD G7";
        }
        if (ed.equals("HD_U")) {
            ver = "OptiFine HD G7 Ultra";
        }
        if (ed.equals("L")) {
            ver = "OptiFine G7 Light";
        }
        VideoSettingsScreen.func_238476_c_((MatrixStack)matrixStackIn, (FontRenderer)this.field_230706_i_.field_71466_p, (String)ver, (int)2, (int)(this.field_230709_l_ - 10), (int)0x808080);
        String verMc = "Minecraft 1.16.5";
        int lenMc = this.field_230706_i_.field_71466_p.func_78256_a(verMc);
        VideoSettingsScreen.func_238476_c_((MatrixStack)matrixStackIn, (FontRenderer)this.field_230706_i_.field_71466_p, (String)verMc, (int)(this.field_230708_k_ - lenMc - 2), (int)(this.field_230709_l_ - 10), (int)0x808080);
        super.func_230430_a_(matrixStackIn, mouseX, mouseY, partialTicks);
        this.tooltipManager.drawTooltips(matrixStackIn, mouseX, mouseY, this.buttonList);
    }

    public static String getGuiChatText(ChatScreen guiChat) {
        return guiChat.field_146415_a.func_146179_b();
    }
}

