/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.shaders.Shaders;

public class LightTexture
implements AutoCloseable {
    private final DynamicTexture field_205110_a;
    private final NativeImage field_205111_b;
    private final ResourceLocation field_205112_c;
    private boolean field_205113_d;
    private float field_228449_e_;
    private final GameRenderer field_205116_g;
    private final Minecraft field_205117_h;
    private boolean allowed = true;
    private boolean custom = false;
    private Vector3f tempVector = new Vector3f();
    public static final int MAX_BRIGHTNESS = LightTexture.func_228451_a_((int)15, (int)15);

    public LightTexture(GameRenderer entityRendererIn, Minecraft mcIn) {
        this.field_205116_g = entityRendererIn;
        this.field_205117_h = mcIn;
        this.field_205110_a = new DynamicTexture(16, 16, false);
        this.field_205112_c = this.field_205117_h.func_110434_K().func_110578_a("light_map", this.field_205110_a);
        this.field_205111_b = this.field_205110_a.func_195414_e();
        for (int i2 = 0; i2 < 16; ++i2) {
            for (int j2 = 0; j2 < 16; ++j2) {
                this.field_205111_b.func_195700_a(j2, i2, -1);
            }
        }
        this.field_205110_a.func_110564_a();
    }

    @Override
    public void close() {
        this.field_205110_a.close();
    }

    public void func_205107_a() {
        this.field_228449_e_ = (float)((double)this.field_228449_e_ + (Math.random() - Math.random()) * Math.random() * Math.random() * 0.1);
        this.field_228449_e_ = (float)((double)this.field_228449_e_ * 0.9);
        this.field_205113_d = true;
    }

    public void func_205108_b() {
        RenderSystem.activeTexture((int)33986);
        RenderSystem.disableTexture();
        RenderSystem.activeTexture((int)33984);
        if (Config.isShaders()) {
            Shaders.disableLightmap();
        }
    }

    public void func_205109_c() {
        if (!this.allowed) {
            return;
        }
        RenderSystem.activeTexture((int)33986);
        RenderSystem.matrixMode((int)5890);
        RenderSystem.loadIdentity();
        float f2 = 0.00390625f;
        RenderSystem.scalef((float)0.00390625f, (float)0.00390625f, (float)0.00390625f);
        RenderSystem.translatef((float)8.0f, (float)8.0f, (float)8.0f);
        RenderSystem.matrixMode((int)5888);
        this.field_205117_h.func_110434_K().func_110577_a(this.field_205112_c);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
        RenderSystem.texParameter((int)3553, (int)10242, (int)33071);
        RenderSystem.texParameter((int)3553, (int)10243, (int)33071);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableTexture();
        RenderSystem.activeTexture((int)33984);
        if (Config.isShaders()) {
            Shaders.enableLightmap();
        }
    }

    public void func_205106_a(float partialTicks) {
        if (this.field_205113_d) {
            this.field_205113_d = false;
            this.field_205117_h.func_213239_aq().func_76320_a("lightTex");
            ClientWorld clientworld = this.field_205117_h.field_71441_e;
            if (clientworld != null) {
                this.custom = false;
                if (Config.isCustomColors()) {
                    boolean nightVision;
                    boolean bl = nightVision = this.field_205117_h.field_71439_g.func_70644_a(Effects.field_76439_r) || this.field_205117_h.field_71439_g.func_70644_a(Effects.field_205136_C);
                    if (CustomColors.updateLightmap((ClientWorld)clientworld, (float)this.field_228449_e_, (NativeImage)this.field_205111_b, (boolean)nightVision, (float)partialTicks)) {
                        this.field_205110_a.func_110564_a();
                        this.field_205113_d = false;
                        this.field_205117_h.func_213239_aq().func_76319_b();
                        this.custom = true;
                        return;
                    }
                }
                float f2 = clientworld.func_228326_g_(1.0f);
                float f1 = clientworld.func_228332_n_() > 0 ? 1.0f : f2 * 0.95f + 0.05f;
                float f3 = this.field_205117_h.field_71439_g.func_203719_J();
                float f22 = this.field_205117_h.field_71439_g.func_70644_a(Effects.field_76439_r) ? GameRenderer.func_180438_a((LivingEntity)this.field_205117_h.field_71439_g, (float)partialTicks) : (f3 > 0.0f && this.field_205117_h.field_71439_g.func_70644_a(Effects.field_205136_C) ? f3 : 0.0f);
                Vector3f vector3f = new Vector3f(f2, f2, 1.0f);
                vector3f.func_229190_a_(new Vector3f(1.0f, 1.0f, 1.0f), 0.35f);
                float f4 = this.field_228449_e_ + 1.5f;
                Vector3f vector3f1 = new Vector3f();
                for (int i2 = 0; i2 < 16; ++i2) {
                    for (int j2 = 0; j2 < 16; ++j2) {
                        float f10;
                        float f5 = this.func_228452_a_((World)clientworld, i2) * f1;
                        float f6 = this.func_228452_a_((World)clientworld, j2) * f4;
                        float f7 = f6 * ((f6 * 0.6f + 0.4f) * 0.6f + 0.4f);
                        float f8 = f6 * (f6 * f6 * 0.6f + 0.4f);
                        vector3f1.func_195905_a(f6, f7, f8);
                        if (clientworld.func_239132_a_().func_241684_d_()) {
                            vector3f1.func_229190_a_(this.getTempVector3f(0.99f, 1.12f, 1.0f), 0.25f);
                        } else {
                            Vector3f vector3f2 = this.getTempCopy(vector3f);
                            vector3f2.func_195898_a(f5);
                            vector3f1.func_229189_a_(vector3f2);
                            vector3f1.func_229190_a_(this.getTempVector3f(0.75f, 0.75f, 0.75f), 0.04f);
                            if (this.field_205116_g.func_205002_d(partialTicks) > 0.0f) {
                                float f9 = this.field_205116_g.func_205002_d(partialTicks);
                                Vector3f vector3f3 = this.getTempCopy(vector3f1);
                                vector3f3.func_229192_b_(0.7f, 0.6f, 0.6f);
                                vector3f1.func_229190_a_(vector3f3, f9);
                            }
                        }
                        vector3f1.func_195901_a(0.0f, 1.0f);
                        if (f22 > 0.0f && (f10 = Math.max(vector3f1.func_195899_a(), Math.max(vector3f1.func_195900_b(), vector3f1.func_195902_c()))) < 1.0f) {
                            float f12 = 1.0f / f10;
                            Vector3f vector3f5 = this.getTempCopy(vector3f1);
                            vector3f5.func_195898_a(f12);
                            vector3f1.func_229190_a_(vector3f5, f22);
                        }
                        float f11 = (float)this.field_205117_h.field_71474_y.field_74333_Y;
                        Vector3f vector3f4 = this.getTempCopy(vector3f1);
                        vector3f4.func_229191_a_(arg_0 -> this.func_228453_b_(arg_0));
                        vector3f1.func_229190_a_(vector3f4, f11);
                        vector3f1.func_229190_a_(this.getTempVector3f(0.75f, 0.75f, 0.75f), 0.04f);
                        vector3f1.func_195901_a(0.0f, 1.0f);
                        vector3f1.func_195898_a(255.0f);
                        int j1 = 255;
                        int k2 = (int)vector3f1.func_195899_a();
                        int l2 = (int)vector3f1.func_195900_b();
                        int i1 = (int)vector3f1.func_195902_c();
                        this.field_205111_b.func_195700_a(j2, i2, 0xFF000000 | i1 << 16 | l2 << 8 | k2);
                    }
                }
                this.field_205110_a.func_110564_a();
                this.field_205117_h.func_213239_aq().func_76319_b();
            }
        }
    }

    private float func_228453_b_(float valueIn) {
        float f2 = 1.0f - valueIn;
        return 1.0f - f2 * f2 * f2 * f2;
    }

    private float func_228452_a_(World worldIn, int lightLevelIn) {
        return worldIn.func_230315_m_().func_236021_a_(lightLevelIn);
    }

    public static int func_228451_a_(int blockLightIn, int skyLightIn) {
        return blockLightIn << 4 | skyLightIn << 20;
    }

    public static int func_228450_a_(int packedLightIn) {
        return (packedLightIn & 0xFFFF) >> 4;
    }

    public static int func_228454_b_(int packedLightIn) {
        return packedLightIn >> 20 & 0xFFFF;
    }

    private Vector3f getTempVector3f(float x2, float y2, float z) {
        this.tempVector.func_195905_a(x2, y2, z);
        return this.tempVector;
    }

    private Vector3f getTempCopy(Vector3f vec) {
        this.tempVector.func_195905_a(vec.func_195899_a(), vec.func_195900_b(), vec.func_195902_c());
        return this.tempVector;
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public void setAllowed(boolean allowed) {
        this.allowed = allowed;
    }

    public boolean isCustom() {
        return this.custom;
    }
}

