/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.FluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.lighting.WorldLightManager;

/*
 * Exception performing whole class analysis ignored.
 */
public class ChunkRenderCache
implements IBlockDisplayReader {
    protected final int field_212400_a;
    protected final int field_212401_b;
    protected final BlockPos field_212402_c;
    protected final int field_212403_d;
    protected final int field_212404_e;
    protected final int field_212405_f;
    protected final Chunk[][] field_212406_g;
    protected final BlockState[] field_217340_h;
    protected final FluidState[] field_217341_i;
    protected final World field_212408_i;

    @Nullable
    public static ChunkRenderCache func_212397_a(World worldIn, BlockPos from, BlockPos to, int padding) {
        return ChunkRenderCache.generateCache((World)worldIn, (BlockPos)from, (BlockPos)to, (int)padding, (boolean)true);
    }

    public static ChunkRenderCache generateCache(World worldIn, BlockPos from, BlockPos to, int padding, boolean checkEmpty) {
        int i2 = from.func_177958_n() - padding >> 4;
        int j2 = from.func_177952_p() - padding >> 4;
        int k2 = to.func_177958_n() + padding >> 4;
        int l2 = to.func_177952_p() + padding >> 4;
        Chunk[][] achunk = new Chunk[k2 - i2 + 1][l2 - j2 + 1];
        for (int i1 = i2; i1 <= k2; ++i1) {
            for (int j1 = j2; j1 <= l2; ++j1) {
                achunk[i1 - i2][j1 - j2] = worldIn.func_212866_a_(i1, j1);
            }
        }
        if (checkEmpty && ChunkRenderCache.func_241718_a_((BlockPos)from, (BlockPos)to, (int)i2, (int)j2, (Chunk[][])achunk)) {
            return null;
        }
        boolean k1 = true;
        BlockPos blockpos1 = from.func_177982_a(-1, -1, -1);
        BlockPos blockpos = to.func_177982_a(1, 1, 1);
        return new ChunkRenderCache(worldIn, i2, j2, achunk, blockpos1, blockpos);
    }

    public static boolean func_241718_a_(BlockPos posFrom, BlockPos posTo, int chunkX, int chunkZ, Chunk[][] chunksIn) {
        for (int i2 = posFrom.func_177958_n() >> 4; i2 <= posTo.func_177958_n() >> 4; ++i2) {
            for (int j2 = posFrom.func_177952_p() >> 4; j2 <= posTo.func_177952_p() >> 4; ++j2) {
                Chunk chunk = chunksIn[i2 - chunkX][j2 - chunkZ];
                if (chunk.func_76606_c(posFrom.func_177956_o(), posTo.func_177956_o())) continue;
                return false;
            }
        }
        return true;
    }

    public ChunkRenderCache(World worldIn, int chunkStartXIn, int chunkStartZIn, Chunk[][] chunksIn, BlockPos startPos, BlockPos endPos) {
        this.field_212408_i = worldIn;
        this.field_212400_a = chunkStartXIn;
        this.field_212401_b = chunkStartZIn;
        this.field_212406_g = chunksIn;
        this.field_212402_c = startPos;
        this.field_212403_d = endPos.func_177958_n() - startPos.func_177958_n() + 1;
        this.field_212404_e = endPos.func_177956_o() - startPos.func_177956_o() + 1;
        this.field_212405_f = endPos.func_177952_p() - startPos.func_177952_p() + 1;
        this.field_217340_h = null;
        this.field_217341_i = null;
    }

    protected final int func_212398_a(BlockPos pos) {
        return this.func_217339_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    protected int func_217339_a(int xIn, int yIn, int zIn) {
        int i2 = xIn - this.field_212402_c.func_177958_n();
        int j2 = yIn - this.field_212402_c.func_177956_o();
        int k2 = zIn - this.field_212402_c.func_177952_p();
        return k2 * this.field_212403_d * this.field_212404_e + j2 * this.field_212403_d + i2;
    }

    public BlockState func_180495_p(BlockPos pos) {
        int i2 = (pos.func_177958_n() >> 4) - this.field_212400_a;
        int j2 = (pos.func_177952_p() >> 4) - this.field_212401_b;
        return this.field_212406_g[i2][j2].func_180495_p(pos);
    }

    public FluidState func_204610_c(BlockPos pos) {
        int i2 = (pos.func_177958_n() >> 4) - this.field_212400_a;
        int j2 = (pos.func_177952_p() >> 4) - this.field_212401_b;
        return this.field_212406_g[i2][j2].func_204610_c(pos);
    }

    public float func_230487_a_(Direction directionIn, boolean shadeIn) {
        return this.field_212408_i.func_230487_a_(directionIn, shadeIn);
    }

    public WorldLightManager func_225524_e_() {
        return this.field_212408_i.func_225524_e_();
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        return this.func_212399_a(pos, Chunk.CreateEntityType.IMMEDIATE);
    }

    @Nullable
    public TileEntity func_212399_a(BlockPos pos, Chunk.CreateEntityType creationType) {
        int i2 = (pos.func_177958_n() >> 4) - this.field_212400_a;
        int j2 = (pos.func_177952_p() >> 4) - this.field_212401_b;
        return this.field_212406_g[i2][j2].func_177424_a(pos, creationType);
    }

    public int func_225525_a_(BlockPos blockPosIn, ColorResolver colorResolverIn) {
        return this.field_212408_i.func_225525_a_(blockPosIn, colorResolverIn);
    }

    public Biome getBiome(BlockPos pos) {
        return this.field_212408_i.func_226691_t_(pos);
    }

    public Chunk getChunk(int ix, int iz) {
        return this.field_212406_g[ix][iz];
    }
}

