/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class ResourcePack
implements IResourcePack {
    private static final Logger field_195772_b = LogManager.getLogger();
    public final File field_195771_a;

    public ResourcePack(File resourcePackFileIn) {
        this.field_195771_a = resourcePackFileIn;
    }

    private static String func_195765_c(ResourcePackType type, ResourceLocation location) {
        return String.format("%s/%s/%s", type.func_198956_a(), location.func_110624_b(), location.func_110623_a());
    }

    protected static String func_195767_a(File file1, File file2) {
        return file1.toURI().relativize(file2.toURI()).getPath();
    }

    public InputStream func_195761_a(ResourcePackType type, ResourceLocation location) throws IOException {
        return this.func_195766_a(ResourcePack.func_195765_c((ResourcePackType)type, (ResourceLocation)location));
    }

    public boolean func_195764_b(ResourcePackType type, ResourceLocation location) {
        return this.func_195768_c(ResourcePack.func_195765_c((ResourcePackType)type, (ResourceLocation)location));
    }

    protected abstract InputStream func_195766_a(String var1) throws IOException;

    public InputStream func_195763_b(String fileName) throws IOException {
        if (!fileName.contains("/") && !fileName.contains("\\")) {
            return this.func_195766_a(fileName);
        }
        throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
    }

    protected abstract boolean func_195768_c(String var1);

    protected void func_195769_d(String namespace) {
        field_195772_b.warn("ResourcePack: ignored non-lowercase namespace: {} in {}", (Object)namespace, (Object)this.field_195771_a);
    }

    @Nullable
    public <T> T func_195760_a(IMetadataSectionSerializer<T> deserializer) throws IOException {
        Object object;
        try (InputStream inputstream = this.func_195766_a("pack.mcmeta");){
            object = ResourcePack.func_195770_a(deserializer, (InputStream)inputstream);
        }
        return (T)object;
    }

    @Nullable
    public static <T> T func_195770_a(IMetadataSectionSerializer<T> deserializer, InputStream inputStream) {
        JsonObject jsonobject;
        try (BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            jsonobject = JSONUtils.func_212743_a((Reader)bufferedreader);
        }
        catch (JsonParseException | IOException ioexception) {
            field_195772_b.error("Couldn't load {} metadata", (Object)deserializer.func_110483_a(), (Object)ioexception);
            return null;
        }
        if (!jsonobject.has(deserializer.func_110483_a())) {
            return null;
        }
        try {
            return (T)deserializer.func_195812_a(JSONUtils.func_152754_s((JsonObject)jsonobject, (String)deserializer.func_110483_a()));
        }
        catch (JsonParseException jsonparseexception) {
            field_195772_b.error("Couldn't load {} metadata", (Object)deserializer.func_110483_a(), (Object)jsonparseexception);
            return null;
        }
    }

    public String func_195762_a() {
        return this.field_195771_a.getName();
    }
}

