/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChunkDataPacket;
import net.minecraft.network.play.server.SMountEntityPacket;
import net.minecraft.network.play.server.SSetPassengersPacket;
import net.minecraft.network.play.server.SUpdateChunkPositionPacket;
import net.minecraft.network.play.server.SUpdateLightPacket;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.Util;
import net.minecraft.util.concurrent.DelegatedTaskExecutor;
import net.minecraft.util.concurrent.ITaskExecutor;
import net.minecraft.util.concurrent.ThreadTaskExecutor;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.palette.UpgradeData;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkPrimerWrapper;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.ChunkTaskPriorityQueue;
import net.minecraft.world.chunk.ChunkTaskPriorityQueueSorter;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.chunk.PlayerGenerationTracker;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.chunk.storage.ChunkLoader;
import net.minecraft.world.chunk.storage.ChunkSerializer;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.ServerWorldLightManager;
import net.minecraft.world.server.TicketType;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.SaveFormat;
import net.optifine.reflect.Reflector;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class ChunkManager
extends ChunkLoader
implements ChunkHolder.IPlayerProvider {
    private static final Logger field_219250_d = LogManager.getLogger();
    public static final int field_219249_a = 33 + ChunkStatus.func_222600_b();
    private final Long2ObjectLinkedOpenHashMap<ChunkHolder> field_219251_e = new Long2ObjectLinkedOpenHashMap();
    private volatile Long2ObjectLinkedOpenHashMap<ChunkHolder> field_219252_f = this.field_219251_e.clone();
    private final Long2ObjectLinkedOpenHashMap<ChunkHolder> field_219253_g = new Long2ObjectLinkedOpenHashMap();
    private final LongSet field_219254_h = new LongOpenHashSet();
    private final ServerWorld field_219255_i;
    private final ServerWorldLightManager field_219256_j;
    private final ThreadTaskExecutor<Runnable> field_219257_k;
    private final ChunkGenerator field_219258_l;
    private final Supplier<DimensionSavedDataManager> field_219259_m;
    private final PointOfInterestManager field_219260_n;
    private final LongSet field_219261_o = new LongOpenHashSet();
    private boolean field_219262_p;
    private final ChunkTaskPriorityQueueSorter field_219263_q;
    private final ITaskExecutor<ChunkTaskPriorityQueueSorter.FunctionEntry<Runnable>> field_219264_r;
    private final ITaskExecutor<ChunkTaskPriorityQueueSorter.FunctionEntry<Runnable>> field_219265_s;
    private final IChunkStatusListener field_219266_t;
    private final ProxyTicketManager field_219267_u;
    private final AtomicInteger field_219268_v = new AtomicInteger();
    private final TemplateManager field_219269_w;
    private final File field_219270_x;
    private final PlayerGenerationTracker field_219271_y = new PlayerGenerationTracker();
    private final Int2ObjectMap<EntityTracker> field_219272_z = new Int2ObjectOpenHashMap();
    private final Long2ByteMap field_241087_z_ = new Long2ByteOpenHashMap();
    private final Queue<Runnable> field_223181_A = Queues.newConcurrentLinkedQueue();
    private int field_219247_A;

    public ChunkManager(ServerWorld worldIn, SaveFormat.LevelSave levelSaveIn, DataFixer dataFixerIn, TemplateManager templateManagerIn, Executor executorIn, ThreadTaskExecutor<Runnable> taskExecutorIn, IChunkLightProvider lightProviderIn, ChunkGenerator chunkGeneratorIn, IChunkStatusListener statusListenerIn, Supplier<DimensionSavedDataManager> p_i232602_10_, int p_i232602_11_, boolean p_i232602_12_) {
        super(new File(levelSaveIn.func_237291_a_(worldIn.func_234923_W_()), "region"), dataFixerIn, p_i232602_12_);
        this.field_219269_w = templateManagerIn;
        this.field_219270_x = levelSaveIn.func_237291_a_(worldIn.func_234923_W_());
        this.field_219255_i = worldIn;
        this.field_219258_l = chunkGeneratorIn;
        this.field_219257_k = taskExecutorIn;
        DelegatedTaskExecutor delegatedtaskexecutor = DelegatedTaskExecutor.func_213144_a((Executor)executorIn, (String)"worldgen");
        ITaskExecutor itaskexecutor = ITaskExecutor.func_213140_a((String)"main", arg_0 -> taskExecutorIn.func_212871_a_(arg_0));
        this.field_219266_t = statusListenerIn;
        DelegatedTaskExecutor delegatedtaskexecutor1 = DelegatedTaskExecutor.func_213144_a((Executor)executorIn, (String)"light");
        this.field_219263_q = new ChunkTaskPriorityQueueSorter((List)ImmutableList.of((Object)delegatedtaskexecutor, (Object)itaskexecutor, (Object)delegatedtaskexecutor1), executorIn, Integer.MAX_VALUE);
        this.field_219264_r = this.field_219263_q.func_219087_a((ITaskExecutor)delegatedtaskexecutor, false);
        this.field_219265_s = this.field_219263_q.func_219087_a(itaskexecutor, false);
        this.field_219256_j = new ServerWorldLightManager(lightProviderIn, this, this.field_219255_i.func_230315_m_().func_218272_d(), delegatedtaskexecutor1, this.field_219263_q.func_219087_a((ITaskExecutor)delegatedtaskexecutor1, false));
        this.field_219267_u = new ProxyTicketManager(this, executorIn, taskExecutorIn);
        this.field_219259_m = p_i232602_10_;
        this.field_219260_n = new PointOfInterestManager(new File(this.field_219270_x, "poi"), dataFixerIn, p_i232602_12_);
        this.func_219175_a(p_i232602_11_);
    }

    private static double func_219217_a(ChunkPos chunkPosIn, Entity entityIn) {
        double d0 = chunkPosIn.field_77276_a * 16 + 8;
        double d1 = chunkPosIn.field_77275_b * 16 + 8;
        double d2 = d0 - entityIn.func_226277_ct_();
        double d3 = d1 - entityIn.func_226281_cx_();
        return d2 * d2 + d3 * d3;
    }

    private static int func_219215_b(ChunkPos pos, ServerPlayerEntity player, boolean p_219215_2_) {
        int j2;
        int i2;
        if (p_219215_2_) {
            SectionPos sectionpos = player.func_213842_M();
            i2 = sectionpos.func_218149_a();
            j2 = sectionpos.func_218148_c();
        } else {
            i2 = MathHelper.func_76128_c((double)(player.func_226277_ct_() / 16.0));
            j2 = MathHelper.func_76128_c((double)(player.func_226281_cx_() / 16.0));
        }
        return ChunkManager.func_219232_a((ChunkPos)pos, (int)i2, (int)j2);
    }

    private static int func_219232_a(ChunkPos chunkPosIn, int x2, int y2) {
        int i2 = chunkPosIn.field_77276_a - x2;
        int j2 = chunkPosIn.field_77275_b - y2;
        return Math.max(Math.abs(i2), Math.abs(j2));
    }

    protected ServerWorldLightManager func_219207_a() {
        return this.field_219256_j;
    }

    @Nullable
    protected ChunkHolder func_219220_a(long chunkPosIn) {
        return (ChunkHolder)this.field_219251_e.get(chunkPosIn);
    }

    @Nullable
    protected ChunkHolder func_219219_b(long chunkPosIn) {
        return (ChunkHolder)this.field_219252_f.get(chunkPosIn);
    }

    protected IntSupplier func_219191_c(long chunkPosIn) {
        return () -> {
            ChunkHolder chunkholder = this.func_219219_b(chunkPosIn);
            return chunkholder == null ? ChunkTaskPriorityQueue.field_219419_a - 1 : Math.min(chunkholder.func_219281_j(), ChunkTaskPriorityQueue.field_219419_a - 1);
        };
    }

    public String func_219170_a(ChunkPos pos) {
        ChunkHolder chunkholder = this.func_219219_b(pos.func_201841_a());
        if (chunkholder == null) {
            return "null";
        }
        String s2 = chunkholder.func_219299_i() + "\n";
        ChunkStatus chunkstatus = chunkholder.func_219285_d();
        IChunk ichunk = chunkholder.func_219287_e();
        if (chunkstatus != null) {
            s2 = s2 + "St: \u00a7" + chunkstatus.func_222584_c() + chunkstatus + '\u00a7' + "r\n";
        }
        if (ichunk != null) {
            s2 = s2 + "Ch: \u00a7" + ichunk.func_201589_g().func_222584_c() + ichunk.func_201589_g() + '\u00a7' + "r\n";
        }
        ChunkHolder.LocationType chunkholder$locationtype = chunkholder.func_219300_g();
        s2 = s2 + "\u00a7" + chunkholder$locationtype.ordinal() + chunkholder$locationtype;
        return s2 + '\u00a7' + "r";
    }

    private CompletableFuture<Either<List<IChunk>, ChunkHolder.IChunkLoadingError>> func_219236_a(ChunkPos pos, int p_219236_2_, IntFunction<ChunkStatus> p_219236_3_) {
        ArrayList list = Lists.newArrayList();
        int i2 = pos.field_77276_a;
        int j2 = pos.field_77275_b;
        for (int k2 = -p_219236_2_; k2 <= p_219236_2_; ++k2) {
            for (int l2 = -p_219236_2_; l2 <= p_219236_2_; ++l2) {
                int i1 = Math.max(Math.abs(l2), Math.abs(k2));
                ChunkPos chunkpos = new ChunkPos(i2 + l2, j2 + k2);
                long j1 = chunkpos.func_201841_a();
                ChunkHolder chunkholder = this.func_219220_a(j1);
                if (chunkholder == null) {
                    return CompletableFuture.completedFuture(Either.right((Object)new /* Unavailable Anonymous Inner Class!! */));
                }
                ChunkStatus chunkstatus = p_219236_3_.apply(i1);
                CompletableFuture completablefuture = chunkholder.func_219276_a(chunkstatus, this);
                list.add(completablefuture);
            }
        }
        CompletableFuture completablefuture1 = Util.func_215079_b((List)list);
        return completablefuture1.thenApply(p_219227_4_ -> {
            ArrayList list1 = Lists.newArrayList();
            int k1 = 0;
            for (Either either : p_219227_4_) {
                Optional optional = either.left();
                if (!optional.isPresent()) {
                    int l1 = k1;
                    return Either.right((Object)new /* Unavailable Anonymous Inner Class!! */);
                }
                list1.add(optional.get());
                ++k1;
            }
            return Either.left((Object)list1);
        });
    }

    public CompletableFuture<Either<Chunk, ChunkHolder.IChunkLoadingError>> func_219188_b(ChunkPos p_219188_1_) {
        return this.func_219236_a(p_219188_1_, 2, p_219218_0_ -> ChunkStatus.field_222617_m).thenApplyAsync(p_219242_0_ -> p_219242_0_.mapLeft(p_219238_0_ -> (Chunk)p_219238_0_.get(p_219238_0_.size() / 2)), (Executor)this.field_219257_k);
    }

    @Nullable
    private ChunkHolder func_219213_a(long chunkPosIn, int newLevel, @Nullable ChunkHolder holder, int oldLevel) {
        if (oldLevel > field_219249_a && newLevel > field_219249_a) {
            return holder;
        }
        if (holder != null) {
            holder.func_219292_a(newLevel);
        }
        if (holder != null) {
            if (newLevel > field_219249_a) {
                this.field_219261_o.add(chunkPosIn);
            } else {
                this.field_219261_o.remove(chunkPosIn);
            }
        }
        if (newLevel <= field_219249_a && holder == null) {
            holder = (ChunkHolder)this.field_219253_g.remove(chunkPosIn);
            if (holder != null) {
                holder.func_219292_a(newLevel);
            } else {
                holder = new ChunkHolder(new ChunkPos(chunkPosIn), newLevel, (WorldLightManager)this.field_219256_j, (ChunkHolder.IListener)this.field_219263_q, (ChunkHolder.IPlayerProvider)this);
            }
            this.field_219251_e.put(chunkPosIn, (Object)holder);
            this.field_219262_p = true;
        }
        return holder;
    }

    public void close() throws IOException {
        try {
            this.field_219263_q.close();
            this.field_219260_n.close();
        }
        finally {
            super.close();
        }
    }

    protected void func_219177_a(boolean flush) {
        if (flush) {
            List list = this.field_219252_f.values().stream().filter(ChunkHolder::func_219289_k).peek(ChunkHolder::func_219303_l).collect(Collectors.toList());
            MutableBoolean mutableboolean = new MutableBoolean();
            do {
                mutableboolean.setFalse();
                list.stream().map(p_222974_1_ -> {
                    CompletableFuture completablefuture;
                    do {
                        completablefuture = p_222974_1_.func_219302_f();
                        this.field_219257_k.func_213161_c(completablefuture::isDone);
                    } while (completablefuture != p_222974_1_.func_219302_f());
                    return (IChunk)completablefuture.join();
                }).filter(p_222952_0_ -> p_222952_0_ instanceof ChunkPrimerWrapper || p_222952_0_ instanceof Chunk).filter(arg_0 -> this.func_219229_a(arg_0)).forEach(p_222959_1_ -> mutableboolean.setTrue());
            } while (mutableboolean.isTrue());
            this.func_223155_b(() -> true);
            this.func_227079_i_();
            field_219250_d.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", (Object)this.field_219270_x.getName());
        } else {
            this.field_219252_f.values().stream().filter(ChunkHolder::func_219289_k).forEach(p_222965_1_ -> {
                IChunk ichunk = p_222965_1_.func_219302_f().getNow(null);
                if (ichunk instanceof ChunkPrimerWrapper || ichunk instanceof Chunk) {
                    this.func_219229_a(ichunk);
                    p_222965_1_.func_219303_l();
                }
            });
        }
    }

    protected void func_219204_a(BooleanSupplier hasMoreTime) {
        IProfiler iprofiler = this.field_219255_i.func_217381_Z();
        iprofiler.func_76320_a("poi");
        this.field_219260_n.func_219115_a(hasMoreTime);
        iprofiler.func_219895_b("chunk_unload");
        if (!this.field_219255_i.func_217402_u()) {
            this.func_223155_b(hasMoreTime);
        }
        iprofiler.func_76319_b();
    }

    private void func_223155_b(BooleanSupplier hasMoreTime) {
        Runnable runnable;
        LongIterator longiterator = this.field_219261_o.iterator();
        int i2 = 0;
        while (longiterator.hasNext() && (hasMoreTime.getAsBoolean() || i2 < 200 || this.field_219261_o.size() > 2000)) {
            long j2 = longiterator.nextLong();
            ChunkHolder chunkholder = (ChunkHolder)this.field_219251_e.remove(j2);
            if (chunkholder != null) {
                this.field_219253_g.put(j2, (Object)chunkholder);
                this.field_219262_p = true;
                ++i2;
                this.func_219212_a(j2, chunkholder);
            }
            longiterator.remove();
        }
        while ((hasMoreTime.getAsBoolean() || this.field_223181_A.size() > 2000) && (runnable = (Runnable)this.field_223181_A.poll()) != null) {
            runnable.run();
        }
    }

    private void func_219212_a(long chunkPosIn, ChunkHolder chunkHolderIn) {
        CompletableFuture completablefuture = chunkHolderIn.func_219302_f();
        ((CompletableFuture)completablefuture.thenAcceptAsync(p_219185_5_ -> {
            CompletableFuture completablefuture1 = chunkHolderIn.func_219302_f();
            if (completablefuture1 != completablefuture) {
                this.func_219212_a(chunkPosIn, chunkHolderIn);
            } else if (this.field_219253_g.remove(chunkPosIn, (Object)chunkHolderIn) && p_219185_5_ != null) {
                if (p_219185_5_ instanceof Chunk) {
                    ((Chunk)p_219185_5_).func_177417_c(false);
                    if (Reflector.ChunkEvent_Unload_Constructor.exists()) {
                        Reflector.postForgeBusEvent(Reflector.ChunkEvent_Unload_Constructor, (Chunk)p_219185_5_);
                    }
                }
                this.func_219229_a(p_219185_5_);
                if (this.field_219254_h.remove(chunkPosIn) && p_219185_5_ instanceof Chunk) {
                    Chunk chunk = (Chunk)p_219185_5_;
                    this.field_219255_i.func_217466_a(chunk);
                }
                this.field_219256_j.func_215581_a(p_219185_5_.func_76632_l());
                this.field_219256_j.func_215588_z_();
                this.field_219266_t.func_219508_a(p_219185_5_.func_76632_l(), (ChunkStatus)null);
            }
        }, this.field_223181_A::add)).whenComplete((p_223171_1_, p_223171_2_) -> {
            if (p_223171_2_ != null) {
                field_219250_d.error("Failed to save chunk " + chunkHolderIn.func_219277_h(), p_223171_2_);
            }
        });
    }

    protected boolean func_219245_b() {
        if (!this.field_219262_p) {
            return false;
        }
        this.field_219252_f = this.field_219251_e.clone();
        this.field_219262_p = false;
        return true;
    }

    public CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> func_219244_a(ChunkHolder chunkHolderIn, ChunkStatus chunkStatusIn) {
        ChunkPos chunkpos = chunkHolderIn.func_219277_h();
        if (chunkStatusIn == ChunkStatus.field_223226_a_) {
            return this.func_223172_f(chunkpos);
        }
        CompletableFuture completablefuture = chunkHolderIn.func_219276_a(chunkStatusIn.func_222593_e(), this);
        return completablefuture.thenComposeAsync(p_223180_4_ -> {
            IChunk ichunk;
            Optional optional = p_223180_4_.left();
            if (!optional.isPresent()) {
                return CompletableFuture.completedFuture(p_223180_4_);
            }
            if (chunkStatusIn == ChunkStatus.field_222614_j) {
                this.field_219267_u.func_219356_a(TicketType.field_219492_e, chunkpos, 33 + ChunkStatus.func_222599_a((ChunkStatus)ChunkStatus.field_222613_i), (Object)chunkpos);
            }
            if ((ichunk = (IChunk)optional.get()).func_201589_g().func_209003_a(chunkStatusIn)) {
                CompletableFuture completablefuture1 = chunkStatusIn == ChunkStatus.field_222614_j ? this.func_223156_b(chunkHolderIn, chunkStatusIn) : chunkStatusIn.func_223201_a(this.field_219255_i, this.field_219269_w, this.field_219256_j, p_223175_2_ -> this.func_219200_b(chunkHolderIn), ichunk);
                this.field_219266_t.func_219508_a(chunkpos, chunkStatusIn);
                return completablefuture1;
            }
            return this.func_223156_b(chunkHolderIn, chunkStatusIn);
        }, (Executor)this.field_219257_k);
    }

    private CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> func_223172_f(ChunkPos chunkPosIn) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.field_219255_i.func_217381_Z().func_230035_c_("chunkLoad");
                CompoundNBT compoundnbt = this.func_219178_f(chunkPosIn);
                if (compoundnbt != null) {
                    boolean flag;
                    boolean bl = flag = compoundnbt.func_150297_b("Level", 10) && compoundnbt.func_74775_l("Level").func_150297_b("Status", 8);
                    if (flag) {
                        ChunkPrimer ichunk = ChunkSerializer.func_222656_a((ServerWorld)this.field_219255_i, (TemplateManager)this.field_219269_w, (PointOfInterestManager)this.field_219260_n, (ChunkPos)chunkPosIn, (CompoundNBT)compoundnbt);
                        ichunk.func_177432_b(this.field_219255_i.func_82737_E());
                        this.func_241088_a_(chunkPosIn, ichunk.func_201589_g().func_202129_d());
                        return Either.left((Object)ichunk);
                    }
                    field_219250_d.error("Chunk file at {} is missing level data, skipping", (Object)chunkPosIn);
                }
            }
            catch (ReportedException reportedexception) {
                Throwable throwable = reportedexception.getCause();
                if (!(throwable instanceof IOException)) {
                    this.func_241089_g_(chunkPosIn);
                    throw reportedexception;
                }
                field_219250_d.error("Couldn't load chunk {}", (Object)chunkPosIn, (Object)throwable);
            }
            catch (Exception exception) {
                field_219250_d.error("Couldn't load chunk {}", (Object)chunkPosIn, (Object)exception);
            }
            this.func_241089_g_(chunkPosIn);
            return Either.left((Object)new ChunkPrimer(chunkPosIn, UpgradeData.field_196994_a));
        }, (Executor)this.field_219257_k);
    }

    private void func_241089_g_(ChunkPos p_241089_1_) {
        this.field_241087_z_.put(p_241089_1_.func_201841_a(), (byte)-1);
    }

    private byte func_241088_a_(ChunkPos p_241088_1_, ChunkStatus.Type p_241088_2_) {
        return this.field_241087_z_.put(p_241088_1_.func_201841_a(), (byte)(p_241088_2_ == ChunkStatus.Type.PROTOCHUNK ? -1 : 1));
    }

    private CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> func_223156_b(ChunkHolder chunkHolderIn, ChunkStatus chunkStatusIn) {
        ChunkPos chunkpos = chunkHolderIn.func_219277_h();
        CompletableFuture completablefuture = this.func_219236_a(chunkpos, chunkStatusIn.func_202128_c(), p_219195_2_ -> this.func_219205_a(chunkStatusIn, p_219195_2_));
        this.field_219255_i.func_217381_Z().func_230036_c_(() -> "chunkGenerate " + chunkStatusIn.func_222596_d());
        return completablefuture.thenComposeAsync(p_219235_4_ -> (CompletionStage)p_219235_4_.map(p_223148_4_ -> {
            try {
                CompletableFuture completablefuture1 = chunkStatusIn.func_223198_a(this.field_219255_i, this.field_219258_l, this.field_219269_w, this.field_219256_j, p_222954_2_ -> this.func_219200_b(chunkHolderIn), p_223148_4_);
                this.field_219266_t.func_219508_a(chunkpos, chunkStatusIn);
                return completablefuture1;
            }
            catch (Exception exception) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)exception, (String)"Exception generating new chunk");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Chunk to be generated");
                crashreportcategory.func_71507_a("Location", (Object)String.format("%d,%d", chunkpos.field_77276_a, chunkpos.field_77275_b));
                crashreportcategory.func_71507_a("Position hash", (Object)ChunkPos.func_77272_a((int)chunkpos.field_77276_a, (int)chunkpos.field_77275_b));
                crashreportcategory.func_71507_a("Generator", (Object)this.field_219258_l);
                throw new ReportedException(crashreport);
            }
        }, p_219211_2_ -> {
            this.func_219209_c(chunkpos);
            return CompletableFuture.completedFuture(Either.right((Object)p_219211_2_));
        }), p_219216_2_ -> this.field_219264_r.func_212871_a_((Object)ChunkTaskPriorityQueueSorter.func_219081_a((ChunkHolder)chunkHolderIn, (Runnable)p_219216_2_)));
    }

    protected void func_219209_c(ChunkPos p_219209_1_) {
        this.field_219257_k.func_212871_a_(Util.func_215075_a(() -> this.field_219267_u.func_219345_b(TicketType.field_219492_e, p_219209_1_, 33 + ChunkStatus.func_222599_a((ChunkStatus)ChunkStatus.field_222613_i), (Object)p_219209_1_), () -> "release light ticket " + p_219209_1_));
    }

    private ChunkStatus func_219205_a(ChunkStatus p_219205_1_, int p_219205_2_) {
        ChunkStatus chunkstatus = p_219205_2_ == 0 ? p_219205_1_.func_222593_e() : ChunkStatus.func_222581_a((int)(ChunkStatus.func_222599_a((ChunkStatus)p_219205_1_) + p_219205_2_));
        return chunkstatus;
    }

    private CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> func_219200_b(ChunkHolder p_219200_1_) {
        CompletableFuture completablefuture = p_219200_1_.func_219301_a(ChunkStatus.field_222617_m.func_222593_e());
        return completablefuture.thenApplyAsync(p_219193_2_ -> {
            ChunkStatus chunkstatus = ChunkHolder.func_219278_b((int)p_219200_1_.func_219299_i());
            return !chunkstatus.func_209003_a(ChunkStatus.field_222617_m) ? ChunkHolder.field_219306_a : p_219193_2_.mapLeft(p_219237_2_ -> {
                Chunk chunk;
                ChunkPos chunkpos = p_219200_1_.func_219277_h();
                if (p_219237_2_ instanceof ChunkPrimerWrapper) {
                    chunk = ((ChunkPrimerWrapper)p_219237_2_).func_217336_u();
                } else {
                    chunk = new Chunk((World)this.field_219255_i, (ChunkPrimer)p_219237_2_);
                    p_219200_1_.func_219294_a(new ChunkPrimerWrapper(chunk));
                }
                chunk.func_217314_a(() -> ChunkHolder.func_219286_c((int)p_219200_1_.func_219299_i()));
                chunk.func_217318_w();
                if (this.field_219254_h.add(chunkpos.func_201841_a())) {
                    chunk.func_177417_c(true);
                    this.field_219255_i.func_147448_a(chunk.func_177434_r().values());
                    Iterable list = null;
                    ClassInheritanceMultiMap[] aclassinheritancemultimap = chunk.func_177429_s();
                    int i2 = aclassinheritancemultimap.length;
                    for (int j2 = 0; j2 < i2; ++j2) {
                        for (Entity entity : aclassinheritancemultimap[j2]) {
                            if (entity instanceof PlayerEntity || this.field_219255_i.func_217440_f(entity)) continue;
                            if (list == null) {
                                list = Lists.newArrayList((Object[])new Entity[]{entity});
                                continue;
                            }
                            list.add(entity);
                        }
                    }
                    if (list != null) {
                        list.forEach(arg_0 -> ((Chunk)chunk).func_76622_b(arg_0));
                    }
                    if (Reflector.ChunkEvent_Load_Constructor.exists()) {
                        Reflector.postForgeBusEvent(Reflector.ChunkEvent_Load_Constructor, chunk);
                    }
                }
                return chunk;
            });
        }, p_219228_2_ -> this.field_219265_s.func_212871_a_((Object)ChunkTaskPriorityQueueSorter.func_219069_a((Runnable)p_219228_2_, (long)p_219200_1_.func_219277_h().func_201841_a(), () -> ((ChunkHolder)p_219200_1_).func_219299_i())));
    }

    public CompletableFuture<Either<Chunk, ChunkHolder.IChunkLoadingError>> func_219179_a(ChunkHolder p_219179_1_) {
        ChunkPos chunkpos = p_219179_1_.func_219277_h();
        CompletableFuture completablefuture = this.func_219236_a(chunkpos, 1, p_219172_0_ -> ChunkStatus.field_222617_m);
        CompletionStage completablefuture1 = completablefuture.thenApplyAsync(p_219239_0_ -> p_219239_0_.flatMap(p_219208_0_ -> {
            Chunk chunk = (Chunk)p_219208_0_.get(p_219208_0_.size() / 2);
            chunk.func_201595_A();
            return Either.left((Object)chunk);
        }), p_219230_2_ -> this.field_219265_s.func_212871_a_((Object)ChunkTaskPriorityQueueSorter.func_219081_a((ChunkHolder)p_219179_1_, (Runnable)p_219230_2_)));
        ((CompletableFuture)completablefuture1).thenAcceptAsync(p_219176_2_ -> p_219176_2_.mapLeft(p_219196_2_ -> {
            this.field_219268_v.getAndIncrement();
            IPacket[] ipacket = new IPacket[2];
            this.func_219097_a(chunkpos, false).forEach(p_219233_3_ -> this.func_219180_a(p_219233_3_, ipacket, p_219196_2_));
            return Either.left((Object)p_219196_2_);
        }), p_219202_2_ -> this.field_219265_s.func_212871_a_((Object)ChunkTaskPriorityQueueSorter.func_219081_a((ChunkHolder)p_219179_1_, (Runnable)p_219202_2_)));
        return completablefuture1;
    }

    public CompletableFuture<Either<Chunk, ChunkHolder.IChunkLoadingError>> func_222961_b(ChunkHolder p_222961_1_) {
        return p_222961_1_.func_219276_a(ChunkStatus.field_222617_m, this).thenApplyAsync(p_222976_0_ -> p_222976_0_.mapLeft(p_222955_0_ -> {
            Chunk chunk = (Chunk)p_222955_0_;
            chunk.func_222879_B();
            return chunk;
        }), p_222962_2_ -> this.field_219265_s.func_212871_a_((Object)ChunkTaskPriorityQueueSorter.func_219081_a((ChunkHolder)p_222961_1_, (Runnable)p_222962_2_)));
    }

    public int func_219174_c() {
        return this.field_219268_v.get();
    }

    private boolean func_219229_a(IChunk chunkIn) {
        this.field_219260_n.func_219112_a(chunkIn.func_76632_l());
        if (!chunkIn.func_201593_f()) {
            return false;
        }
        chunkIn.func_177432_b(this.field_219255_i.func_82737_E());
        chunkIn.func_177427_f(false);
        ChunkPos chunkpos = chunkIn.func_76632_l();
        try {
            ChunkStatus chunkstatus = chunkIn.func_201589_g();
            if (chunkstatus.func_202129_d() != ChunkStatus.Type.LEVELCHUNK) {
                if (this.func_241090_h_(chunkpos)) {
                    return false;
                }
                if (chunkstatus == ChunkStatus.field_223226_a_ && chunkIn.func_201609_c().values().stream().noneMatch(StructureStart::func_75069_d)) {
                    return false;
                }
            }
            this.field_219255_i.func_217381_Z().func_230035_c_("chunkSave");
            CompoundNBT compoundnbt = ChunkSerializer.func_222645_a((ServerWorld)this.field_219255_i, (IChunk)chunkIn);
            if (Reflector.ChunkDataEvent_Save_Constructor.exists()) {
                World worldForge = (World)Reflector.call(chunkIn, Reflector.ForgeIChunk_getWorldForge, new Object[0]);
                Reflector.postForgeBusEvent(Reflector.ChunkDataEvent_Save_Constructor, chunkIn, worldForge != null ? worldForge : this.field_219255_i, compoundnbt);
            }
            this.func_219100_a(chunkpos, compoundnbt);
            this.func_241088_a_(chunkpos, chunkstatus.func_202129_d());
            return true;
        }
        catch (Exception exception) {
            field_219250_d.error("Failed to save chunk {},{}", (Object)chunkpos.field_77276_a, (Object)chunkpos.field_77275_b, (Object)exception);
            return false;
        }
    }

    private boolean func_241090_h_(ChunkPos p_241090_1_) {
        CompoundNBT compoundnbt;
        byte b0 = this.field_241087_z_.get(p_241090_1_.func_201841_a());
        if (b0 != 0) {
            return b0 == 1;
        }
        try {
            compoundnbt = this.func_219178_f(p_241090_1_);
            if (compoundnbt == null) {
                this.func_241089_g_(p_241090_1_);
                return false;
            }
        }
        catch (Exception exception) {
            field_219250_d.error("Failed to read chunk {}", (Object)p_241090_1_, (Object)exception);
            this.func_241089_g_(p_241090_1_);
            return false;
        }
        ChunkStatus.Type chunkstatus$type = ChunkSerializer.func_222651_a((CompoundNBT)compoundnbt);
        return this.func_241088_a_(p_241090_1_, chunkstatus$type) == 1;
    }

    protected void func_219175_a(int viewDistance) {
        int i2 = MathHelper.func_76125_a((int)(viewDistance + 1), (int)3, (int)64);
        if (i2 != this.field_219247_A) {
            int j2 = this.field_219247_A;
            this.field_219247_A = i2;
            this.field_219267_u.func_219354_b(this.field_219247_A);
            for (ChunkHolder chunkholder : this.field_219251_e.values()) {
                ChunkPos chunkpos = chunkholder.func_219277_h();
                IPacket[] ipacket = new IPacket[2];
                this.func_219097_a(chunkpos, false).forEach(p_219224_4_ -> {
                    int k2 = ChunkManager.func_219215_b((ChunkPos)chunkpos, (ServerPlayerEntity)p_219224_4_, (boolean)true);
                    boolean flag = k2 <= j2;
                    boolean flag1 = k2 <= this.field_219247_A;
                    this.func_219199_a(p_219224_4_, chunkpos, ipacket, flag, flag1);
                });
            }
        }
    }

    protected void func_219199_a(ServerPlayerEntity player, ChunkPos chunkPosIn, IPacket<?>[] packetCache, boolean wasLoaded, boolean load) {
        if (player.field_70170_p == this.field_219255_i) {
            ChunkHolder chunkholder;
            if (Reflector.ForgeEventFactory_fireChunkWatch.exists()) {
                Reflector.ForgeEventFactory_fireChunkWatch.call(wasLoaded, load, player, chunkPosIn, this.field_219255_i);
            }
            if (load && !wasLoaded && (chunkholder = this.func_219219_b(chunkPosIn.func_201841_a())) != null) {
                Chunk chunk = chunkholder.func_219298_c();
                if (chunk != null) {
                    this.func_219180_a(player, packetCache, chunk);
                }
                DebugPacketSender.func_218802_a((ServerWorld)this.field_219255_i, (ChunkPos)chunkPosIn);
            }
            if (!load && wasLoaded) {
                player.func_213845_a(chunkPosIn);
            }
        }
    }

    public int func_219194_d() {
        return this.field_219252_f.size();
    }

    protected ProxyTicketManager func_219246_e() {
        return this.field_219267_u;
    }

    protected Iterable<ChunkHolder> func_223491_f() {
        return Iterables.unmodifiableIterable((Iterable)this.field_219252_f.values());
    }

    void func_225406_a(Writer p_225406_1_) throws IOException {
        CSVWriter csvwriter = CSVWriter.func_225428_a().func_225423_a("x").func_225423_a("z").func_225423_a("level").func_225423_a("in_memory").func_225423_a("status").func_225423_a("full_status").func_225423_a("accessible_ready").func_225423_a("ticking_ready").func_225423_a("entity_ticking_ready").func_225423_a("ticket").func_225423_a("spawning").func_225423_a("entity_count").func_225423_a("block_entity_count").func_225422_a(p_225406_1_);
        for (Long2ObjectMap.Entry entry : this.field_219252_f.long2ObjectEntrySet()) {
            ChunkPos chunkpos = new ChunkPos(entry.getLongKey());
            ChunkHolder chunkholder = (ChunkHolder)entry.getValue();
            Optional<IChunk> optional = Optional.ofNullable(chunkholder.func_219287_e());
            Optional<Object> optional1 = optional.flatMap(p_225407_0_ -> p_225407_0_ instanceof Chunk ? Optional.of((Chunk)p_225407_0_) : Optional.empty());
            csvwriter.func_225426_a(new Object[]{chunkpos.field_77276_a, chunkpos.field_77275_b, chunkholder.func_219299_i(), optional.isPresent(), optional.map(IChunk::func_201589_g).orElse(null), optional1.map(Chunk::func_217321_u).orElse(null), ChunkManager.func_225402_a((CompletableFuture)chunkholder.func_223492_c()), ChunkManager.func_225402_a((CompletableFuture)chunkholder.func_219296_a()), ChunkManager.func_225402_a((CompletableFuture)chunkholder.func_219297_b()), this.field_219267_u.func_225413_c(entry.getLongKey()), !this.func_219243_d(chunkpos), optional1.map(p_225401_0_ -> Stream.of(p_225401_0_.func_177429_s()).mapToInt(ClassInheritanceMultiMap::size).sum()).orElse(0), optional1.map(p_225405_0_ -> p_225405_0_.func_177434_r().size()).orElse(0)});
        }
    }

    private static String func_225402_a(CompletableFuture<Either<Chunk, ChunkHolder.IChunkLoadingError>> p_225402_0_) {
        try {
            Either<Chunk, ChunkHolder.IChunkLoadingError> either = p_225402_0_.getNow((Either<Chunk, ChunkHolder.IChunkLoadingError>)((Either)null));
            return either != null ? (String)either.map(p_225408_0_ -> "done", p_225400_0_ -> "unloaded") : "not completed";
        }
        catch (CompletionException completionexception) {
            return "failed " + completionexception.getCause().getMessage();
        }
        catch (CancellationException cancellationexception) {
            return "cancelled";
        }
    }

    @Nullable
    private CompoundNBT func_219178_f(ChunkPos pos) throws IOException {
        CompoundNBT compoundnbt = this.func_227078_e_(pos);
        return compoundnbt == null ? null : this.func_235968_a_(this.field_219255_i.func_234923_W_(), this.field_219259_m, compoundnbt);
    }

    boolean func_219243_d(ChunkPos chunkPosIn) {
        long i2 = chunkPosIn.func_201841_a();
        return !this.field_219267_u.func_223494_d(i2) ? true : this.field_219271_y.func_219444_a(i2).noneMatch(p_219201_1_ -> !p_219201_1_.func_175149_v() && ChunkManager.func_219217_a((ChunkPos)chunkPosIn, (Entity)p_219201_1_) < 16384.0);
    }

    private boolean func_219187_b(ServerPlayerEntity player) {
        return player.func_175149_v() && !this.field_219255_i.func_82736_K().func_223586_b(GameRules.field_223613_p);
    }

    void func_219234_a(ServerPlayerEntity player, boolean track) {
        boolean flag = this.func_219187_b(player);
        boolean flag1 = this.field_219271_y.func_219448_c(player);
        int i2 = MathHelper.func_76128_c((double)player.func_226277_ct_()) >> 4;
        int j2 = MathHelper.func_76128_c((double)player.func_226281_cx_()) >> 4;
        if (track) {
            this.field_219271_y.func_219442_a(ChunkPos.func_77272_a((int)i2, (int)j2), player, flag);
            this.func_223489_c(player);
            if (!flag) {
                this.field_219267_u.func_219341_a(SectionPos.func_218157_a((Entity)player), player);
            }
        } else {
            SectionPos sectionpos = player.func_213842_M();
            this.field_219271_y.func_219443_a(sectionpos.func_218155_u().func_201841_a(), player);
            if (!flag1) {
                this.field_219267_u.func_219367_b(sectionpos, player);
            }
        }
        for (int l2 = i2 - this.field_219247_A; l2 <= i2 + this.field_219247_A; ++l2) {
            for (int k2 = j2 - this.field_219247_A; k2 <= j2 + this.field_219247_A; ++k2) {
                ChunkPos chunkpos = new ChunkPos(l2, k2);
                this.func_219199_a(player, chunkpos, new IPacket[2], !track, track);
            }
        }
    }

    private SectionPos func_223489_c(ServerPlayerEntity serverPlayerEntityIn) {
        SectionPos sectionpos = SectionPos.func_218157_a((Entity)serverPlayerEntityIn);
        serverPlayerEntityIn.func_213850_a(sectionpos);
        serverPlayerEntityIn.field_71135_a.func_147359_a((IPacket)new SUpdateChunkPositionPacket(sectionpos.func_218149_a(), sectionpos.func_218148_c()));
        return sectionpos;
    }

    public void func_219183_a(ServerPlayerEntity player) {
        boolean flag2;
        for (EntityTracker chunkmanager$entitytracker : this.field_219272_z.values()) {
            if (EntityTracker.access$000((EntityTracker)chunkmanager$entitytracker) == player) {
                chunkmanager$entitytracker.func_219397_a(this.field_219255_i.func_217369_A());
                continue;
            }
            chunkmanager$entitytracker.func_219400_b(player);
        }
        int l1 = MathHelper.func_76128_c((double)player.func_226277_ct_()) >> 4;
        int i2 = MathHelper.func_76128_c((double)player.func_226281_cx_()) >> 4;
        SectionPos sectionpos = player.func_213842_M();
        SectionPos sectionpos1 = SectionPos.func_218157_a((Entity)player);
        long i3 = sectionpos.func_218155_u().func_201841_a();
        long j2 = sectionpos1.func_218155_u().func_201841_a();
        boolean flag = this.field_219271_y.func_225419_d(player);
        boolean flag1 = this.func_219187_b(player);
        boolean bl = flag2 = sectionpos.func_218146_v() != sectionpos1.func_218146_v();
        if (flag2 || flag != flag1) {
            this.func_223489_c(player);
            if (!flag) {
                this.field_219267_u.func_219367_b(sectionpos, player);
            }
            if (!flag1) {
                this.field_219267_u.func_219341_a(sectionpos1, player);
            }
            if (!flag && flag1) {
                this.field_219271_y.func_219446_a(player);
            }
            if (flag && !flag1) {
                this.field_219271_y.func_219447_b(player);
            }
            if (i3 != j2) {
                this.field_219271_y.func_219445_a(i3, j2, player);
            }
        }
        int k2 = sectionpos.func_218149_a();
        int l2 = sectionpos.func_218148_c();
        if (Math.abs(k2 - l1) <= this.field_219247_A * 2 && Math.abs(l2 - i2) <= this.field_219247_A * 2) {
            int k22 = Math.min(l1, k2) - this.field_219247_A;
            int i32 = Math.min(i2, l2) - this.field_219247_A;
            int j3 = Math.max(l1, k2) + this.field_219247_A;
            int k3 = Math.max(i2, l2) + this.field_219247_A;
            for (int l3 = k22; l3 <= j3; ++l3) {
                for (int k1 = i32; k1 <= k3; ++k1) {
                    ChunkPos chunkpos1 = new ChunkPos(l3, k1);
                    boolean flag5 = ChunkManager.func_219232_a((ChunkPos)chunkpos1, (int)k2, (int)l2) <= this.field_219247_A;
                    boolean flag6 = ChunkManager.func_219232_a((ChunkPos)chunkpos1, (int)l1, (int)i2) <= this.field_219247_A;
                    this.func_219199_a(player, chunkpos1, new IPacket[2], flag5, flag6);
                }
            }
        } else {
            for (int i1 = k2 - this.field_219247_A; i1 <= k2 + this.field_219247_A; ++i1) {
                for (int j1 = l2 - this.field_219247_A; j1 <= l2 + this.field_219247_A; ++j1) {
                    ChunkPos chunkpos = new ChunkPos(i1, j1);
                    boolean flag3 = true;
                    boolean flag4 = false;
                    this.func_219199_a(player, chunkpos, new IPacket[2], true, false);
                }
            }
            for (int j22 = l1 - this.field_219247_A; j22 <= l1 + this.field_219247_A; ++j22) {
                for (int l22 = i2 - this.field_219247_A; l22 <= i2 + this.field_219247_A; ++l22) {
                    ChunkPos chunkpos2 = new ChunkPos(j22, l22);
                    boolean flag7 = false;
                    boolean flag8 = true;
                    this.func_219199_a(player, chunkpos2, new IPacket[2], false, true);
                }
            }
        }
    }

    public Stream<ServerPlayerEntity> func_219097_a(ChunkPos pos, boolean boundaryOnly) {
        return this.field_219271_y.func_219444_a(pos.func_201841_a()).filter(p_219192_3_ -> {
            int i2 = ChunkManager.func_219215_b((ChunkPos)pos, (ServerPlayerEntity)p_219192_3_, (boolean)true);
            if (i2 > this.field_219247_A) {
                return false;
            }
            return !boundaryOnly || i2 == this.field_219247_A;
        });
    }

    protected void func_219210_a(Entity entityIn) {
        boolean multipart = entityIn instanceof EnderDragonPartEntity;
        if (Reflector.PartEntity.exists()) {
            multipart = Reflector.PartEntity.isInstance(entityIn);
        }
        if (!multipart) {
            EntityType entitytype = entityIn.func_200600_R();
            int i2 = entitytype.func_233602_m_() * 16;
            int j2 = entitytype.func_220332_l();
            if (this.field_219272_z.containsKey(entityIn.func_145782_y())) {
                throw (IllegalStateException)Util.func_229757_c_((Throwable)new IllegalStateException("Entity is already tracked!"));
            }
            EntityTracker chunkmanager$entitytracker = new EntityTracker(this, entityIn, i2, j2, entitytype.func_220340_m());
            this.field_219272_z.put(entityIn.func_145782_y(), (Object)chunkmanager$entitytracker);
            chunkmanager$entitytracker.func_219397_a(this.field_219255_i.func_217369_A());
            if (entityIn instanceof ServerPlayerEntity) {
                ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)entityIn;
                this.func_219234_a(serverplayerentity, true);
                for (EntityTracker chunkmanager$entitytracker1 : this.field_219272_z.values()) {
                    if (EntityTracker.access$000((EntityTracker)chunkmanager$entitytracker1) == serverplayerentity) continue;
                    chunkmanager$entitytracker1.func_219400_b(serverplayerentity);
                }
            }
        }
    }

    protected void func_219231_b(Entity entityIn) {
        EntityTracker chunkmanager$entitytracker1;
        if (entityIn instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)entityIn;
            this.func_219234_a(serverplayerentity, false);
            for (EntityTracker chunkmanager$entitytracker : this.field_219272_z.values()) {
                chunkmanager$entitytracker.func_219399_a(serverplayerentity);
            }
        }
        if ((chunkmanager$entitytracker1 = (EntityTracker)this.field_219272_z.remove(entityIn.func_145782_y())) != null) {
            chunkmanager$entitytracker1.func_219396_a();
        }
    }

    protected void func_219169_g() {
        ArrayList list = Lists.newArrayList();
        List list1 = this.field_219255_i.func_217369_A();
        for (EntityTracker chunkmanager$entitytracker : this.field_219272_z.values()) {
            SectionPos sectionpos1;
            SectionPos sectionpos = EntityTracker.access$100((EntityTracker)chunkmanager$entitytracker);
            if (!Objects.equals(sectionpos, sectionpos1 = SectionPos.func_218157_a((Entity)EntityTracker.access$000((EntityTracker)chunkmanager$entitytracker)))) {
                chunkmanager$entitytracker.func_219397_a(list1);
                Entity entity = EntityTracker.access$000((EntityTracker)chunkmanager$entitytracker);
                if (entity instanceof ServerPlayerEntity) {
                    list.add((ServerPlayerEntity)entity);
                }
                EntityTracker.access$102((EntityTracker)chunkmanager$entitytracker, (SectionPos)sectionpos1);
            }
            EntityTracker.access$200((EntityTracker)chunkmanager$entitytracker).func_219453_a();
        }
        if (!list.isEmpty()) {
            for (EntityTracker chunkmanager$entitytracker1 : this.field_219272_z.values()) {
                chunkmanager$entitytracker1.func_219397_a((List)list);
            }
        }
    }

    protected void func_219222_a(Entity entityIn, IPacket<?> p_219222_2_) {
        EntityTracker chunkmanager$entitytracker = (EntityTracker)this.field_219272_z.get(entityIn.func_145782_y());
        if (chunkmanager$entitytracker != null) {
            chunkmanager$entitytracker.func_219391_a(p_219222_2_);
        }
    }

    protected void func_219225_b(Entity entityIn, IPacket<?> p_219225_2_) {
        EntityTracker chunkmanager$entitytracker = (EntityTracker)this.field_219272_z.get(entityIn.func_145782_y());
        if (chunkmanager$entitytracker != null) {
            chunkmanager$entitytracker.func_219392_b(p_219225_2_);
        }
    }

    private void func_219180_a(ServerPlayerEntity player, IPacket<?>[] packetCache, Chunk chunkIn) {
        if (packetCache[0] == null) {
            packetCache[0] = new SChunkDataPacket(chunkIn, 65535);
            packetCache[1] = new SUpdateLightPacket(chunkIn.func_76632_l(), (WorldLightManager)this.field_219256_j, true);
        }
        player.func_213844_a(chunkIn.func_76632_l(), packetCache[0], packetCache[1]);
        DebugPacketSender.func_218802_a((ServerWorld)this.field_219255_i, (ChunkPos)chunkIn.func_76632_l());
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        for (EntityTracker chunkmanager$entitytracker : this.field_219272_z.values()) {
            Entity entity = EntityTracker.access$000((EntityTracker)chunkmanager$entitytracker);
            if (entity == player || entity.field_70176_ah != chunkIn.func_76632_l().field_77276_a || entity.field_70164_aj != chunkIn.func_76632_l().field_77275_b) continue;
            chunkmanager$entitytracker.func_219400_b(player);
            if (entity instanceof MobEntity && ((MobEntity)entity).func_110166_bE() != null) {
                list.add(entity);
            }
            if (entity.func_184188_bt().isEmpty()) continue;
            list1.add(entity);
        }
        if (!list.isEmpty()) {
            for (Entity entity1 : list) {
                player.field_71135_a.func_147359_a((IPacket)new SMountEntityPacket(entity1, ((MobEntity)entity1).func_110166_bE()));
            }
        }
        if (!list1.isEmpty()) {
            for (Entity entity2 : list1) {
                player.field_71135_a.func_147359_a((IPacket)new SSetPassengersPacket(entity2));
            }
        }
    }

    protected PointOfInterestManager func_219189_h() {
        return this.field_219260_n;
    }

    public CompletableFuture<Void> func_222973_a(Chunk chunkIn) {
        return this.field_219257_k.func_222817_e(() -> chunkIn.func_222880_a(this.field_219255_i));
    }

    static /* synthetic */ ServerWorld access$300(ChunkManager x0) {
        return x0.field_219255_i;
    }

    static /* synthetic */ int access$400(ChunkManager x0) {
        return x0.field_219247_A;
    }

    static /* synthetic */ int access$500(ChunkPos x0, ServerPlayerEntity x1, boolean x2) {
        return ChunkManager.func_219215_b((ChunkPos)x0, (ServerPlayerEntity)x1, (boolean)x2);
    }

    static /* synthetic */ LongSet access$600(ChunkManager x0) {
        return x0.field_219261_o;
    }

    static /* synthetic */ ChunkHolder access$700(ChunkManager x0, long x1, int x2, ChunkHolder x3, int x4) {
        return x0.func_219213_a(x1, x2, x3, x4);
    }
}

