/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.optifine.Config;
import net.optifine.model.ModelUtils;

public class SmartLeaves {
    private static elo modelLeavesCullAcacia = null;
    private static elo modelLeavesCullBirch = null;
    private static elo modelLeavesCullDarkOak = null;
    private static elo modelLeavesCullJungle = null;
    private static elo modelLeavesCullOak = null;
    private static elo modelLeavesCullSpruce = null;
    private static List generalQuadsCullAcacia = null;
    private static List generalQuadsCullBirch = null;
    private static List generalQuadsCullDarkOak = null;
    private static List generalQuadsCullJungle = null;
    private static List generalQuadsCullOak = null;
    private static List generalQuadsCullSpruce = null;
    private static elo modelLeavesDoubleAcacia = null;
    private static elo modelLeavesDoubleBirch = null;
    private static elo modelLeavesDoubleDarkOak = null;
    private static elo modelLeavesDoubleJungle = null;
    private static elo modelLeavesDoubleOak = null;
    private static elo modelLeavesDoubleSpruce = null;
    private static final Random RANDOM = new Random();

    public static elo getLeavesModel(elo model, ceh stateIn) {
        if (!Config.isTreesSmart()) {
            return model;
        }
        List<eba> generalQuads = model.a(stateIn, null, RANDOM);
        if (generalQuads == generalQuadsCullAcacia) {
            return modelLeavesDoubleAcacia;
        }
        if (generalQuads == generalQuadsCullBirch) {
            return modelLeavesDoubleBirch;
        }
        if (generalQuads == generalQuadsCullDarkOak) {
            return modelLeavesDoubleDarkOak;
        }
        if (generalQuads == generalQuadsCullJungle) {
            return modelLeavesDoubleJungle;
        }
        if (generalQuads == generalQuadsCullOak) {
            return modelLeavesDoubleOak;
        }
        if (generalQuads == generalQuadsCullSpruce) {
            return modelLeavesDoubleSpruce;
        }
        return model;
    }

    public static boolean isSameLeaves(ceh state1, ceh state2) {
        buo block2;
        if (state1 == state2) {
            return true;
        }
        buo block1 = state1.b();
        return block1 == (block2 = state2.b());
    }

    public static void updateLeavesModels() {
        ArrayList updatedTypes = new ArrayList();
        modelLeavesCullAcacia = SmartLeaves.getModelCull("acacia", updatedTypes);
        modelLeavesCullBirch = SmartLeaves.getModelCull("birch", updatedTypes);
        modelLeavesCullDarkOak = SmartLeaves.getModelCull("dark_oak", updatedTypes);
        modelLeavesCullJungle = SmartLeaves.getModelCull("jungle", updatedTypes);
        modelLeavesCullOak = SmartLeaves.getModelCull("oak", updatedTypes);
        modelLeavesCullSpruce = SmartLeaves.getModelCull("spruce", updatedTypes);
        generalQuadsCullAcacia = SmartLeaves.getGeneralQuadsSafe(modelLeavesCullAcacia);
        generalQuadsCullBirch = SmartLeaves.getGeneralQuadsSafe(modelLeavesCullBirch);
        generalQuadsCullDarkOak = SmartLeaves.getGeneralQuadsSafe(modelLeavesCullDarkOak);
        generalQuadsCullJungle = SmartLeaves.getGeneralQuadsSafe(modelLeavesCullJungle);
        generalQuadsCullOak = SmartLeaves.getGeneralQuadsSafe(modelLeavesCullOak);
        generalQuadsCullSpruce = SmartLeaves.getGeneralQuadsSafe(modelLeavesCullSpruce);
        modelLeavesDoubleAcacia = SmartLeaves.getModelDoubleFace(modelLeavesCullAcacia);
        modelLeavesDoubleBirch = SmartLeaves.getModelDoubleFace(modelLeavesCullBirch);
        modelLeavesDoubleDarkOak = SmartLeaves.getModelDoubleFace(modelLeavesCullDarkOak);
        modelLeavesDoubleJungle = SmartLeaves.getModelDoubleFace(modelLeavesCullJungle);
        modelLeavesDoubleOak = SmartLeaves.getModelDoubleFace(modelLeavesCullOak);
        modelLeavesDoubleSpruce = SmartLeaves.getModelDoubleFace(modelLeavesCullSpruce);
        if (updatedTypes.size() > 0) {
            Config.dbg("Enable face culling: " + Config.arrayToString(updatedTypes.toArray()));
        }
    }

    private static List getGeneralQuadsSafe(elo model) {
        if (model == null) {
            return null;
        }
        return model.a(null, null, RANDOM);
    }

    static elo getModelCull(String type, List updatedTypes) {
        elt modelManager = Config.getModelManager();
        if (modelManager == null) {
            return null;
        }
        vk locState = new vk("blockstates/" + type + "_leaves.json");
        if (!Config.isFromDefaultResourcePack(locState)) {
            return null;
        }
        vk locModel = new vk("models/block/" + type + "_leaves.json");
        if (!Config.isFromDefaultResourcePack(locModel)) {
            return null;
        }
        elu mrl = new elu(type + "_leaves", "normal");
        elo model = modelManager.a(mrl);
        if (model == null || model == modelManager.a()) {
            return null;
        }
        List<eba> listGeneral = model.a(null, null, RANDOM);
        if (listGeneral.size() == 0) {
            return model;
        }
        if (listGeneral.size() != 6) {
            return null;
        }
        for (eba quad : listGeneral) {
            List<eba> listFace = model.a(null, quad.e(), RANDOM);
            if (listFace.size() > 0) {
                return null;
            }
            listFace.add(quad);
        }
        listGeneral.clear();
        updatedTypes.add(type + "_leaves");
        return model;
    }

    private static elo getModelDoubleFace(elo model) {
        if (model == null) {
            return null;
        }
        if (model.a(null, null, RANDOM).size() > 0) {
            Config.warn("SmartLeaves: Model is not cube, general quads: " + model.a(null, null, RANDOM).size() + ", model: " + model);
            return model;
        }
        gc[] faces = gc.n;
        for (int i2 = 0; i2 < faces.length; ++i2) {
            gc face = faces[i2];
            List<eba> quads = model.a(null, face, RANDOM);
            if (quads.size() == 1) continue;
            Config.warn("SmartLeaves: Model is not cube, side: " + (Object)((Object)face) + ", quads: " + quads.size() + ", model: " + model);
            return model;
        }
        elo model2 = ModelUtils.duplicateModel(model);
        List[] faceQuads = new List[faces.length];
        for (int i3 = 0; i3 < faces.length; ++i3) {
            gc face = faces[i3];
            List<eba> quads = model2.a(null, face, RANDOM);
            eba quad = quads.get(0);
            eba quad2 = new eba((int[])quad.b().clone(), quad.d(), quad.e(), quad.getSprite(), quad.f());
            int[] vd = quad2.b();
            int[] vd2 = (int[])vd.clone();
            int step = vd.length / 4;
            System.arraycopy(vd, 0 * step, vd2, 3 * step, step);
            System.arraycopy(vd, 1 * step, vd2, 2 * step, step);
            System.arraycopy(vd, 2 * step, vd2, 1 * step, step);
            System.arraycopy(vd, 3 * step, vd2, 0 * step, step);
            System.arraycopy(vd2, 0, vd, 0, vd2.length);
            quads.add(quad2);
        }
        return model2;
    }
}

