/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.optifine.Config;
import net.optifine.model.BakedQuadRetextured;
import net.optifine.model.ModelUtils;

public class BlockModelUtils {
    private static final float VERTEX_COORD_ACCURACY = 1.0E-6f;
    private static final Random RANDOM = new Random(0L);

    public static elo makeModelCube(String spriteName, int tintIndex) {
        ekc sprite = Config.getTextureMap().getUploadedSprite(spriteName);
        return BlockModelUtils.makeModelCube(sprite, tintIndex);
    }

    public static elo makeModelCube(ekc sprite, int tintIndex) {
        ArrayList generalQuads = new ArrayList();
        gc[] facings = gc.n;
        HashMap faceQuads = new HashMap();
        for (int i2 = 0; i2 < facings.length; ++i2) {
            gc facing = facings[i2];
            ArrayList<eba> quads = new ArrayList<eba>();
            quads.add(BlockModelUtils.makeBakedQuad(facing, sprite, tintIndex));
            faceQuads.put(facing, quads);
        }
        ebk itemOverrideList = ebk.a;
        elx bakedModel = new elx(generalQuads, faceQuads, true, true, true, sprite, ebm.a, itemOverrideList);
        return bakedModel;
    }

    public static elo joinModelsCube(elo modelBase, elo modelAdd) {
        ArrayList<eba> generalQuads = new ArrayList<eba>();
        generalQuads.addAll(modelBase.a(null, null, RANDOM));
        generalQuads.addAll(modelAdd.a(null, null, RANDOM));
        gc[] facings = gc.n;
        HashMap faceQuads = new HashMap();
        for (int i2 = 0; i2 < facings.length; ++i2) {
            gc facing = facings[i2];
            ArrayList<eba> quads = new ArrayList<eba>();
            quads.addAll(modelBase.a(null, facing, RANDOM));
            quads.addAll(modelAdd.a(null, facing, RANDOM));
            faceQuads.put(facing, quads);
        }
        boolean ao = modelBase.a();
        boolean builtIn = modelBase.d();
        ekc sprite = modelBase.e();
        ebm transforms = modelBase.f();
        ebk itemOverrideList = modelBase.g();
        elx bakedModel = new elx(generalQuads, faceQuads, ao, builtIn, true, sprite, transforms, itemOverrideList);
        return bakedModel;
    }

    public static eba makeBakedQuad(gc facing, ekc sprite, int tintIndex) {
        g posFrom = new g(0.0f, 0.0f, 0.0f);
        g posTo = new g(16.0f, 16.0f, 16.0f);
        ebe uv2 = new ebe(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0);
        ebc face = new ebc(facing, tintIndex, "#" + facing.a(), uv2);
        elp modelRotation = elp.a;
        ebd partRotation = null;
        boolean shade = true;
        vk modelLoc = sprite.l();
        ebh faceBakery = new ebh();
        eba quad = faceBakery.a(posFrom, posTo, face, sprite, facing, (elv)modelRotation, partRotation, shade, modelLoc);
        return quad;
    }

    public static elo makeModel(String modelName, String spriteOldName, String spriteNewName) {
        ekb textureMap = Config.getTextureMap();
        ekc spriteOld = textureMap.getUploadedSprite(spriteOldName);
        ekc spriteNew = textureMap.getUploadedSprite(spriteNewName);
        return BlockModelUtils.makeModel(modelName, spriteOld, spriteNew);
    }

    public static elo makeModel(String modelName, ekc spriteOld, ekc spriteNew) {
        if (spriteOld == null || spriteNew == null) {
            return null;
        }
        elt modelManager = Config.getModelManager();
        if (modelManager == null) {
            return null;
        }
        elu mrl = new elu(modelName, "");
        elo model = modelManager.a(mrl);
        if (model == null || model == modelManager.a()) {
            return null;
        }
        elo modelNew = ModelUtils.duplicateModel(model);
        gc[] faces = gc.n;
        for (int i2 = 0; i2 < faces.length; ++i2) {
            gc face = faces[i2];
            List<eba> quads = modelNew.a(null, face, RANDOM);
            BlockModelUtils.replaceTexture(quads, spriteOld, spriteNew);
        }
        List<eba> quadsGeneral = modelNew.a(null, null, RANDOM);
        BlockModelUtils.replaceTexture(quadsGeneral, spriteOld, spriteNew);
        return modelNew;
    }

    private static void replaceTexture(List<eba> quads, ekc spriteOld, ekc spriteNew) {
        ArrayList<eba> quadsNew = new ArrayList<eba>();
        for (eba quad : quads) {
            if (quad.getSprite() == spriteOld) {
                quad = new BakedQuadRetextured(quad, spriteNew);
            }
            quadsNew.add(quad);
        }
        quads.clear();
        quads.addAll(quadsNew);
    }

    public static void snapVertexPosition(g pos) {
        pos.a(BlockModelUtils.snapVertexCoord(pos.a()), BlockModelUtils.snapVertexCoord(pos.b()), BlockModelUtils.snapVertexCoord(pos.c()));
    }

    private static float snapVertexCoord(float x2) {
        if (x2 > -1.0E-6f && x2 < 1.0E-6f) {
            return 0.0f;
        }
        if (x2 > 0.999999f && x2 < 1.000001f) {
            return 1.0f;
        }
        return x2;
    }

    public static dci getOffsetBoundingBox(dci aabb, ceg.b offsetType, fx pos) {
        int x2 = pos.u();
        int z = pos.w();
        long k2 = (long)(x2 * 3129871) ^ (long)z * 116129781L;
        k2 = k2 * k2 * 42317861L + k2 * 11L;
        double dx = ((double)((float)(k2 >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dz = ((double)((float)(k2 >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dy = 0.0;
        if (offsetType == ceg.b.c) {
            dy = ((double)((float)(k2 >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
        }
        return aabb.d(dx, dy, dz);
    }
}

