/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrcrayfish.configured.client.screen.IBackgroundTexture;
import com.mrcrayfish.configured.client.screen.ILabelProvider;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ListMenuScreen
extends Screen
implements IBackgroundTexture {
    public static final ResourceLocation CONFIGURED_LOGO = new ResourceLocation("configured", "textures/gui/logo.png");
    protected final Screen parent;
    protected final ResourceLocation background;
    protected final int itemHeight;
    protected EntryList list;
    protected List<Item> entries;
    protected List<IReorderingProcessor> activeTooltip;
    protected FocusedTextFieldWidget activeTextField;
    protected FocusedTextFieldWidget searchTextField;

    protected ListMenuScreen(Screen parent, ITextComponent title, ResourceLocation background, int itemHeight) {
        super(title);
        this.parent = parent;
        this.background = background;
        this.itemHeight = itemHeight;
    }

    protected void func_231160_c_() {
        ArrayList<Item> entries = new ArrayList<Item>();
        this.constructEntries(entries);
        this.entries = ImmutableList.copyOf(entries);
        this.list = new EntryList(this.entries);
        this.list.func_244605_b(!ListMenuScreen.isPlayingGame());
        this.field_230705_e_.add(this.list);
        this.searchTextField = new FocusedTextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 110, 22, 220, 20, (ITextComponent)new StringTextComponent("Search"));
        this.searchTextField.func_212954_a(s -> {
            ScreenUtil.updateSearchTextFieldSuggestion(this.searchTextField, s, this.entries);
            this.list.func_230942_a_(s.isEmpty() ? this.entries : (Collection)this.entries.stream().filter(item -> !(item instanceof IIgnoreSearch) && item.getLabel().toLowerCase(Locale.ENGLISH).contains(s.toLowerCase(Locale.ENGLISH))).collect(Collectors.toList()));
            if (!s.isEmpty()) {
                this.list.func_230932_a_(0.0);
            }
        });
        this.field_230705_e_.add(this.searchTextField);
        ScreenUtil.updateSearchTextFieldSuggestion(this.searchTextField, "", this.entries);
    }

    protected abstract void constructEntries(List<Item> var1);

    @Override
    public ResourceLocation getBackgroundTexture() {
        return this.background;
    }

    public void setActiveTooltip(List<IReorderingProcessor> tooltip) {
        this.activeTooltip = tooltip;
    }

    protected void updateTooltip(int mouseX, int mouseY) {
        if (ScreenUtil.isMouseWithin(10, 13, 23, 23, mouseX, mouseY)) {
            this.setActiveTooltip(this.field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)new TranslationTextComponent("configured.gui.info"), 200));
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.activeTooltip = null;
        this.func_230446_a_(matrixStack);
        this.list.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.searchTextField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        ListMenuScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)7, (int)0xFFFFFF);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.field_230706_i_.func_110434_K().func_110577_a(CONFIGURED_LOGO);
        AbstractGui.func_238464_a_((MatrixStack)matrixStack, (int)10, (int)13, (int)this.func_230927_p_(), (float)0.0f, (float)0.0f, (int)23, (int)23, (int)32, (int)32);
        this.updateTooltip(mouseX, mouseY);
        if (this.activeTooltip != null) {
            this.func_238654_b_(matrixStack, this.activeTooltip, mouseX, mouseY);
        } else {
            for (IGuiEventListener widget : this.func_231039_at__()) {
                if (!(widget instanceof Button) || !((Button)widget).func_230449_g_()) continue;
                ((Button)widget).func_230443_a_(matrixStack, mouseX, mouseY);
                break;
            }
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (ScreenUtil.isMouseWithin(10, 13, 23, 23, (int)mouseX, (int)mouseY)) {
            Style style = Style.field_240709_b_.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/configured"));
            this.func_230455_a_(style);
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public static boolean isPlayingGame() {
        return Minecraft.func_71410_x().field_71439_g != null;
    }

    protected static interface IIgnoreSearch {
    }

    @OnlyIn(value=Dist.CLIENT)
    protected class FocusedTextFieldWidget
    extends TextFieldWidget {
        public FocusedTextFieldWidget(FontRenderer fontRenderer, int x, int y, int width, int height, ITextComponent label) {
            super(fontRenderer, x, y, width, height, label);
        }

        public void func_146195_b(boolean focused) {
            super.func_146195_b(focused);
            if (focused) {
                if (ListMenuScreen.this.activeTextField != null && ListMenuScreen.this.activeTextField != this) {
                    ListMenuScreen.this.activeTextField.func_146195_b(false);
                }
                ListMenuScreen.this.activeTextField = this;
            }
        }
    }

    public class TitleItem
    extends Item
    implements IIgnoreSearch {
        public TitleItem(ITextComponent title) {
            super(title);
        }

        public TitleItem(String title) {
            super((ITextComponent)new StringTextComponent(title).func_240699_a_(TextFormatting.BOLD).func_240699_a_(TextFormatting.YELLOW));
        }

        public void func_230432_a_(MatrixStack matrixStack, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            AbstractGui.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)((ListMenuScreen)ListMenuScreen.this).field_230706_i_.field_71466_p, (ITextComponent)this.label, (int)(left + width / 2), (int)(top + 5), (int)0xFFFFFF);
        }
    }

    protected abstract class Item
    extends AbstractOptionList.Entry<Item>
    implements ILabelProvider {
        protected final ITextComponent label;
        protected List<IReorderingProcessor> tooltip;

        public Item(ITextComponent label) {
            this.label = label;
        }

        public Item(String label) {
            this.label = new StringTextComponent(label);
        }

        @Override
        public String getLabel() {
            return this.label.func_150261_e();
        }

        public void setTooltip(ITextComponent text, int maxWidth) {
            this.tooltip = ((ListMenuScreen)ListMenuScreen.this).field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)text, maxWidth);
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return Collections.emptyList();
        }
    }

    protected class EntryList
    extends AbstractOptionList<Item>
    implements IBackgroundTexture {
        public EntryList(List<Item> entries) {
            super(ListMenuScreen.this.field_230706_i_, ListMenuScreen.this.field_230708_k_, ListMenuScreen.this.field_230709_l_, 50, ListMenuScreen.this.field_230709_l_ - 36, ListMenuScreen.this.itemHeight);
            entries.forEach(arg_0 -> ((EntryList)this).func_230513_b_(arg_0));
        }

        protected int func_230952_d_() {
            return this.field_230670_d_ / 2 + 144;
        }

        public int func_230949_c_() {
            return 260;
        }

        @Override
        public ResourceLocation getBackgroundTexture() {
            return ListMenuScreen.this.background;
        }

        public void func_230942_a_(Collection<Item> entries) {
            super.func_230942_a_(entries);
        }

        public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.renderToolTips(matrixStack, mouseX, mouseY);
        }

        private void renderToolTips(MatrixStack matrixStack, int mouseX, int mouseY) {
            Item item2;
            if (this.func_231047_b_(mouseX, mouseY) && mouseX < ListMenuScreen.this.list.func_230968_n_() + ListMenuScreen.this.list.func_230949_c_() - 67 && (item2 = (Item)this.func_230933_a_(mouseX, mouseY)) != null) {
                ListMenuScreen.this.setActiveTooltip(item2.tooltip);
            }
            this.func_231039_at__().forEach(item -> item.func_231039_at__().forEach(o -> {
                if (o instanceof Button) {
                    ((Button)o).func_230443_a_(matrixStack, mouseX, mouseY);
                }
            }));
        }
    }
}

