/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.legendarytooltips;

import com.anthonyhilyard.iceberg.util.Selectors;
import com.electronwill.nightconfig.core.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="legendarytooltips", bus=Mod.EventBusSubscriber.Bus.MOD)
public class LegendaryTooltipsConfig {
    public static final ForgeConfigSpec SPEC;
    public static final LegendaryTooltipsConfig INSTANCE;
    public final ForgeConfigSpec.BooleanValue nameSeparator;
    public final ForgeConfigSpec.BooleanValue bordersMatchRarity;
    public final ForgeConfigSpec.BooleanValue tooltipShadow;
    public final ForgeConfigSpec.BooleanValue shineEffect;
    public final ForgeConfigSpec.LongValue[] startColors = new ForgeConfigSpec.LongValue[16];
    public final ForgeConfigSpec.LongValue[] endColors = new ForgeConfigSpec.LongValue[16];
    private final ForgeConfigSpec.ConfigValue<List<? extends Integer>> framePriorities;
    private final List<ForgeConfigSpec.ConfigValue<List<? extends String>>> itemSelectors = new ArrayList<ForgeConfigSpec.ConfigValue<List<? extends String>>>(16);
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> blacklist;
    private static final Map<ItemStack, Integer> frameLevelCache;

    public LegendaryTooltipsConfig(ForgeConfigSpec.Builder build) {
        int i;
        build.comment("Client Configuration").push("client").push("visual_options");
        this.nameSeparator = build.comment(" Whether item names in tooltips should have a line under them separating them from the rest of the tooltip.").define("name_separator", true);
        this.bordersMatchRarity = build.comment(" If enabled, tooltip border colors will match item rarity colors (except for custom borders).").define("borders_match_rarity", true);
        this.tooltipShadow = build.comment(" If enabled, tooltips will display a drop shadow.").define("tooltip_shadow", true);
        this.shineEffect = build.comment(" If enabled, items showing a custom border will have a special shine effect when hovered over.").define("shine_effect", true);
        build.pop().comment(String.format(" Custom borders are broken into %d \"levels\", with level 0 being intended for the \"best\" or \"rarest\" items. Only level 0 has a custom border built-in, but others can be added with resource packs.", 16)).push("custom_borders");
        build.comment(" The start and end border colors of each levels' borders. Note that they can be entered as a hex code in the format \"0xAARRGGBB\" or \"0xRRGGBB\" for convenience.").push("colors");
        for (i = 0; i < 16; ++i) {
            this.startColors[i] = build.defineInRange(String.format("level%d_start_color", i), 4288244002L, 0L, 0xFFFFFFFFL);
            this.endColors[i] = build.defineInRange(String.format("level%d_end_color", i), 4284103197L, 0L, 0xFFFFFFFFL);
        }
        build.pop().comment(" Set border priorities here.  This should be a list of numbers that correspond to border levels, with numbers coming first being higher priority.");
        build.push("priorities");
        this.framePriorities = build.defineList("priorities", () -> IntStream.rangeClosed(0, 15).boxed().collect(Collectors.toList()), e -> (Integer)e >= 0 && (Integer)e < 16);
        build.pop().comment(" Entry types:\n   Item name - Use item name for vanilla items or include mod name for modded items.  Examples: \"minecraft:stick\", \"iron_ore\"\n   Tag - $ followed by tag name.  Examples: \"$forge:stone\" or \"$planks\"\n   Mod name - @ followed by mod identifier.  Examples: \"@spoiledeggs\"\n   Rarity - ! followed by item's rarity.  This is ONLY vanilla rarities.  Examples: \"!uncommon\", \"!rare\", \"!epic\"\n   Item name color - # followed by color hex code, the hex code must match exactly.  Examples: \"#23F632\"\n   Display name - % followed by any text.  Will match any item with this text in its tooltip display name.  Examples: \"%[Uncommon]\"\n   Tooltip text - ^ followed by any text.  Will match any item with this text anywhere in the tooltip text (besides the name).  Examples: \"^Legendary\"\n   NBT tag - & followed by tag name and optional comparator (=, >, <, or !=) and value, in the format <tag><comparator><value> or just <tag>.  Examples: \"&Damage=0\", \"&Tier>1\", \"&Broken\", \"&map!=128\"");
        build.push("definitions");
        this.itemSelectors.add((ForgeConfigSpec.ConfigValue<List<? extends String>>)build.defineListAllowEmpty(Arrays.asList("level0_entries"), () -> Arrays.asList("!epic", "!rare"), e -> Selectors.validateSelector((String)((String)e))));
        for (i = 1; i < 16; ++i) {
            this.itemSelectors.add((ForgeConfigSpec.ConfigValue<List<? extends String>>)build.defineListAllowEmpty(Arrays.asList(String.format("level%d_entries", i)), () -> new ArrayList(), e -> Selectors.validateSelector((String)((String)e))));
        }
        this.blacklist = build.comment(" Enter blacklist selectors here using the same format as above.  Any items that match these selectors will NOT show a border.").defineListAllowEmpty(Arrays.asList("blacklist"), () -> Arrays.asList(new String[0]), e -> Selectors.validateSelector((String)((String)e)));
        build.pop().pop().pop();
    }

    public int getFrameLevelForItem(ItemStack item) {
        if (frameLevelCache.containsKey(item)) {
            return frameLevelCache.get(item);
        }
        for (String entry : (List)this.blacklist.get()) {
            if (!Selectors.itemMatches((ItemStack)item, (String)entry)) continue;
            frameLevelCache.put(item, -2);
            return -2;
        }
        for (int i = 0; i < 16; ++i) {
            if (i >= ((List)this.framePriorities.get()).size()) continue;
            int frameIndex = (Integer)((List)this.framePriorities.get()).get(i);
            for (String entry : (List)this.itemSelectors.get(frameIndex).get()) {
                if (!Selectors.itemMatches((ItemStack)item, (String)entry)) continue;
                frameLevelCache.put(item, frameIndex);
                return frameIndex;
            }
        }
        frameLevelCache.put(item, -1);
        return -1;
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Reloading e) {
        if (e.getConfig().getModId().equals("legendarytooltips")) {
            frameLevelCache.clear();
        }
    }

    public int getCustomBorderStartColor(int level) {
        if (level >= 0 && level <= 15 && this.startColors[level] != null) {
            int startColor = (int)((Long)this.startColors[level].get()).longValue();
            if (startColor > 0 && startColor <= 0xFFFFFF) {
                return startColor | 0xFF000000;
            }
            return startColor;
        }
        return -1;
    }

    public int getCustomBorderEndColor(int level) {
        if (level >= 0 && level <= 15 && this.endColors[level] != null) {
            int endColor = (int)((Long)this.endColors[level].get()).longValue();
            if (endColor > 0 && endColor <= 0xFFFFFF) {
                return endColor | 0xFF000000;
            }
            return endColor;
        }
        return -1;
    }

    static {
        frameLevelCache = new HashMap<ItemStack, Integer>();
        Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(LegendaryTooltipsConfig::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        INSTANCE = (LegendaryTooltipsConfig)specPair.getLeft();
    }
}

