/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import wily.betterfurnaces.BetterFurnacesReforged;

@Mod.EventBusSubscriber
public class Config {
    public static final String CATEGORY_GENERAL = "general";
    public static final String CATEGORY_FURNACE = "furnaces";
    public static final String CATEGORY_MODDED_FURNACE = "modded_furnaces";
    public static final String CATEGORY_JEI = "jei";
    public static final String CATEGORY_UPDATES = "updates";
    public static final String CATEGORY_MISC = "misc";
    public static ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec CLIENT_CONFIG;
    public static ForgeConfigSpec.IntValue cache_capacity;
    public static ForgeConfigSpec.IntValue furnaceXPDropValue;
    public static ForgeConfigSpec.IntValue furnaceXPDropValue2;
    public static ForgeConfigSpec.IntValue copperTierSpeed;
    public static ForgeConfigSpec.IntValue ironTierSpeed;
    public static ForgeConfigSpec.IntValue goldTierSpeed;
    public static ForgeConfigSpec.IntValue diamondTierSpeed;
    public static ForgeConfigSpec.IntValue netherhotTierSpeed;
    public static ForgeConfigSpec.IntValue extremeTierSpeed;
    public static ForgeConfigSpec.IntValue ultimateTierSpeed;
    public static ForgeConfigSpec.BooleanValue enableJeiPlugin;
    public static ForgeConfigSpec.BooleanValue enableJeiCatalysts;
    public static ForgeConfigSpec.BooleanValue enableJeiClickArea;
    public static ForgeConfigSpec.IntValue xpFluidType;
    public static ForgeConfigSpec.BooleanValue checkUpdates;
    public static ForgeConfigSpec.BooleanValue showErrors;

    public static String getLiquidXPType() {
        if ((Integer)xpFluidType.get() == 0) {
            return "mob_grinding_utils:fluid_xp";
        }
        if ((Integer)xpFluidType.get() == 1) {
            return "industrialforegoing:essence";
        }
        if ((Integer)xpFluidType.get() == 2) {
            return "cyclic:xpjuice";
        }
        if ((Integer)xpFluidType.get() == 3) {
            return "reliquary:xp_juice";
        }
        return "mob_grinding_utils:fluid_xp";
    }

    public static String getLiquidXPMod() {
        if ((Integer)xpFluidType.get() == 0) {
            return "mob_grinding_utils";
        }
        if ((Integer)xpFluidType.get() == 1) {
            return "industrialforegoing";
        }
        if ((Integer)xpFluidType.get() == 2) {
            return "cyclic";
        }
        if ((Integer)xpFluidType.get() == 3) {
            return "reliquary";
        }
        return "mob_grinding_utils";
    }

    private static void setupFurnacesConfig(ForgeConfigSpec.Builder COMMON_BUILDER, ForgeConfigSpec.Builder CLIENT_BUILDER) {
        cache_capacity = CLIENT_BUILDER.comment(" The capacity of the recipe cache, higher values use more memory.\n Default: 10").defineInRange("recipe_cache", 10, 1, 100);
        copperTierSpeed = CLIENT_BUILDER.comment(" Number of ticks to complete one smelting operation.\n 200 ticks is what a regular furnace takes.\n Default: 120(Only work with Ultimate Furnaces addon)").defineInRange("copper_tier.speed", 180, 2, 72000);
        ironTierSpeed = CLIENT_BUILDER.comment(" Number of ticks to complete one smelting operation.\n 200 ticks is what a regular furnace takes.\n Default: 150").defineInRange("iron_tier.speed", 150, 2, 72000);
        goldTierSpeed = CLIENT_BUILDER.comment(" Number of ticks to complete one smelting operation.\n 200 ticks is what a regular furnace takes.\n Default: 100").defineInRange("gold_tier.speed", 100, 2, 72000);
        diamondTierSpeed = CLIENT_BUILDER.comment(" Number of ticks to complete one smelting operation.\n 200 ticks is what a regular furnace takes.\n Default: 80").defineInRange("diamond_tier.speed", 80, 2, 72000);
        netherhotTierSpeed = CLIENT_BUILDER.comment(" Number of ticks to complete one smelting operation.\n 200 ticks is what a regular furnace takes.\n Default: 20").defineInRange("netherhot_tier.speed", 20, 2, 72000);
        extremeTierSpeed = CLIENT_BUILDER.comment(" Number of ticks to complete one smelting operation.\n 200 ticks is what a regular furnace takes.\n Default: 4").defineInRange("extreme_tier.speed", 4, 2, 72000);
        ultimateTierSpeed = CLIENT_BUILDER.comment(" Number of ticks to complete one smelting operation.\n 200 ticks is what a regular furnace takes.\n Default: 1 (Only work with Ultimate Furnaces addon)").defineInRange("ultimate_tier.speed", 1, 1, 72000);
        furnaceXPDropValue = CLIENT_BUILDER.comment(" This value indicates when the furnace should 'overload' and spit out the xp stored. \n Default: 10, Recipes").defineInRange("furnace_xp_drop.value", 10, 1, 500);
        furnaceXPDropValue2 = CLIENT_BUILDER.comment(" This value indicates when the furnace should 'overload' and spit out the xp stored. \n Default: 100000, Single recipe uses").defineInRange("furnace_xp_drop.value_two", 100000, 1, 1000000);
        xpFluidType = CLIENT_BUILDER.comment(" Value referring to the mod used for the xp fluid generated with the Xp Tank Upgrade. \n 0 = Mob Grinding Utils(Default) \n 1 = Industrial Foregoing \n 2 = Cyclic \n 3 = Reliquary").defineInRange("upgrade.xp_fluid_type", 0, 0, 3);
    }

    private static void setupJEIConfig(ForgeConfigSpec.Builder COMMON_BUILDER, ForgeConfigSpec.Builder CLIENT_BUILDER) {
        enableJeiPlugin = CLIENT_BUILDER.comment(" Enable or disable the JeiPlugin of BetterFurnaces.").define("jei.enable_jei", true);
        enableJeiCatalysts = CLIENT_BUILDER.comment(" Enable or disable the Catalysts in Jei for BetterFurnaces.").define("jei.enable_jei_catalysts", true);
        enableJeiClickArea = CLIENT_BUILDER.comment(" Enable or disable the Click Area inside the GUI in all of BetterFurnaces furnaces and forges.").define("jei.enable_jei_click_area", true);
    }

    private static void setupUpdatesConfig(ForgeConfigSpec.Builder COMMON_BUILDER, ForgeConfigSpec.Builder CLIENT_BUILDER) {
        checkUpdates = CLIENT_BUILDER.comment(" true = check for updates, false = don't check for updates.\n Default: true.").define("check_updates.updates", true);
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        BetterFurnacesReforged.LOGGER.debug("Loading config file {}", (Object)path);
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        BetterFurnacesReforged.LOGGER.debug("Built TOML config for {}", (Object)path.toString());
        configData.load();
        BetterFurnacesReforged.LOGGER.debug("Loaded TOML config file {}", (Object)path.toString());
        spec.setConfig((CommentedConfig)configData);
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
    }

    @SubscribeEvent
    public static void onReload(ModConfig.Reloading configEvent) {
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        Config.loadConfig(CLIENT_CONFIG, FMLPaths.CONFIGDIR.get().resolve("betterfurnacesreforged-client.toml"));
        Config.loadConfig(COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("betterfurnacesreforged.toml"));
    }

    @Nullable
    public static PlayerEntity getPlayer(IWorld world) {
        if (world == null) {
            return null;
        }
        if (world.func_217371_b(UUID.fromString("89f4f7f8-8ed5-479d-b04e-f7f843f14963")) != null) {
            return world.func_217371_b(UUID.fromString("89f4f7f8-8ed5-479d-b04e-f7f843f14963"));
        }
        if (world.func_217371_b(UUID.fromString("2b27a3a3-e2d6-468a-92e2-70f6f15b6e41")) != null) {
            return world.func_217371_b(UUID.fromString("2b27a3a3-e2d6-468a-92e2-70f6f15b6e41"));
        }
        return null;
    }

    static {
        ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
        ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
        CLIENT_BUILDER.comment("Settings").push(CATEGORY_GENERAL);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.comment("Furnace Settings").push(CATEGORY_FURNACE);
        Config.setupFurnacesConfig(COMMON_BUILDER, CLIENT_BUILDER);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.comment("Modded Furnace Settings").push(CATEGORY_MODDED_FURNACE);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.comment("JEI Settings").push(CATEGORY_JEI);
        Config.setupJEIConfig(COMMON_BUILDER, CLIENT_BUILDER);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.comment("Misc").push(CATEGORY_MISC);
        showErrors = CLIENT_BUILDER.comment(" Show furnace settings errors in chat, used for debugging").define("misc.errors", false);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.comment("Update Checker Settings").push(CATEGORY_UPDATES);
        Config.setupUpdatesConfig(COMMON_BUILDER, CLIENT_BUILDER);
        CLIENT_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
        CLIENT_CONFIG = CLIENT_BUILDER.build();
    }
}

