/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.blocks;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;
import wily.betterfurnaces.items.ItemUpgradeFuelEfficiency;
import wily.betterfurnaces.tileentity.BlockCobblestoneGeneratorTile;

public abstract class BlockCobblestoneGenerator
extends Block {
    public static final String COBBLESTONE_GENERATOR = "cobblestone_generator";
    public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;
    public static final IntegerProperty TYPE = IntegerProperty.func_177719_a((String)"state", (int)0, (int)3);

    public BlockCobblestoneGenerator(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)TYPE, (Comparable)Integer.valueOf(0)));
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return ToolType.PICKAXE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return 0;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196010_d().func_176734_d());
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        List dropsOriginal = super.func_220076_a(state, builder);
        if (!dropsOriginal.isEmpty()) {
            return dropsOriginal;
        }
        return Collections.singletonList(new ItemStack((IItemProvider)this, 1));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        ItemStack stack = player.func_184586_b(handIn).func_77946_l();
        ItemStack hand = player.func_184586_b(handIn);
        BlockCobblestoneGeneratorTile te = (BlockCobblestoneGeneratorTile)world.func_175625_s(pos);
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (hand.func_77973_b() == Items.field_151129_at || hand.func_77973_b() == Items.field_151131_as || hand.func_77973_b() instanceof ItemUpgradeFuelEfficiency) {
            this.interactInsert(world, pos, player, handIn, stack);
        } else {
            this.interactWith(world, pos, player);
        }
        return ActionResultType.SUCCESS;
    }

    private void interactWith(World world, BlockPos pos, PlayerEntity player) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof INamedContainerProvider) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)tileEntity), (BlockPos)tileEntity.func_174877_v());
            player.func_195066_a(Stats.field_188061_aa);
        }
    }

    private ActionResultType interactInsert(World world, BlockPos pos, PlayerEntity player, Hand handIn, ItemStack stack) {
        ItemStack hand = player.func_184586_b(handIn);
        if (hand.func_77973_b() != Items.field_151129_at && hand.func_77973_b() != Items.field_151131_as && !(hand.func_77973_b() instanceof ItemUpgradeFuelEfficiency)) {
            return ActionResultType.SUCCESS;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BlockCobblestoneGeneratorTile)) {
            return ActionResultType.SUCCESS;
        }
        ItemStack newStack = new ItemStack((IItemProvider)stack.func_77973_b(), 1);
        newStack.func_77982_d(stack.func_77978_p());
        if (player.func_184586_b(handIn).func_77973_b() instanceof ItemUpgradeFuelEfficiency) {
            if (!((IInventory)te).func_70301_a(3).func_190926_b() && !player.func_184812_l_()) {
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (ItemStack)((IInventory)te).func_70301_a(3));
            }
            ((IInventory)te).func_70299_a(3, newStack);
        }
        if (hand.func_77973_b() == Items.field_151129_at) {
            if (!((IInventory)te).func_70301_a(0).func_190926_b() && !player.func_184812_l_()) {
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (ItemStack)((IInventory)te).func_70301_a(0));
            }
            ((IInventory)te).func_70299_a(0, newStack);
        }
        if (hand.func_77973_b() == Items.field_151131_as) {
            if (!((IInventory)te).func_70301_a(1).func_190926_b() && !player.func_184812_l_()) {
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (ItemStack)((IInventory)te).func_70301_a(1));
            }
            ((IInventory)te).func_70299_a(1, newStack);
        }
        world.func_184133_a(null, te.func_174877_v(), SoundEvents.field_187725_r, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!player.func_184812_l_()) {
            player.func_184586_b(handIn).func_190918_g(1);
        }
        ((BlockCobblestoneGeneratorTile)te).onUpdateSent();
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState oldState, boolean p_196243_5_) {
        if (state.func_177230_c() != oldState.func_177230_c()) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof BlockCobblestoneGeneratorTile) {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((BlockCobblestoneGeneratorTile)te));
                world.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, world, pos, oldState, p_196243_5_);
        }
    }

    public BlockRenderType getRenderType(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208155_H, TYPE});
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new BlockCobblestoneGeneratorTile.BlockCobblestoneGeneratorTileDefinition();
    }
}

