/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.blocks;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.network.NetworkHooks;
import wily.betterfurnaces.init.Registration;
import wily.betterfurnaces.items.ItemUpgrade;
import wily.betterfurnaces.items.ItemUpgradeEnergyFuel;
import wily.betterfurnaces.items.ItemUpgradeLiquidFuel;
import wily.betterfurnaces.tileentity.BlockForgeTileBase;
import wily.betterfurnaces.tileentity.BlockSmeltingTileBase;

public abstract class BlockForgeBase
extends Block
implements IWaterLoggable {
    public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final BooleanProperty COLORED = BooleanProperty.func_177716_a((String)"colored");
    public static final BooleanProperty SHOW_ORIENTATION = BooleanProperty.func_177716_a((String)"show_orientation");
    public static final VoxelShape FORGE_SHAPE = VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)VoxelShapes.func_216384_a((VoxelShape)BlockForgeBase.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{BlockForgeBase.func_208617_a((double)15.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0), BlockForgeBase.func_208617_a((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0), BlockForgeBase.func_208617_a((double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0), BlockForgeBase.func_208617_a((double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0), BlockForgeBase.func_208617_a((double)1.75, (double)15.0, (double)1.75, (double)14.5, (double)15.0, (double)14.5), BlockForgeBase.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), BlockForgeBase.func_208617_a((double)1.0, (double)0.5, (double)1.0, (double)15.0, (double)15.0, (double)15.0)}), (IBooleanFunction)IBooleanFunction.field_223238_i_);

    public BlockForgeBase(AbstractBlock.Properties properties) {
        super(properties.func_226896_b_().func_235856_e_(BlockForgeBase::getOrientation));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.SOUTH)).func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)COLORED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SHOW_ORIENTATION, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return FORGE_SHAPE;
    }

    public static boolean getOrientation(BlockState state, IBlockReader world, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)SHOW_ORIENTATION);
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return ToolType.PICKAXE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q) != false ? 14 : 0;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        Direction facing = ctx.func_196010_d().func_176734_d();
        boolean flag = ctx.func_195991_k().func_204610_c(ctx.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)facing)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        List dropsOriginal = super.func_220076_a(state, builder);
        if (!dropsOriginal.isEmpty()) {
            return dropsOriginal;
        }
        return Collections.singletonList(new ItemStack((IItemProvider)this, 1));
    }

    public void func_180633_a(World world, BlockPos pos, BlockState p_180633_3_, @Nullable LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            BlockForgeTileBase te = (BlockForgeTileBase)world.func_175625_s(pos);
            if (stack.func_82837_s()) {
                te.setCustomName(stack.func_151000_E());
            }
            te.totalCookTime = (Integer)te.getCookTimeConfig().get();
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        ItemStack stack = player.func_184586_b(handIn).func_77946_l();
        ItemStack hand = player.func_184586_b(handIn);
        BlockForgeTileBase te = (BlockForgeTileBase)world.func_175625_s(pos);
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (hand.func_77973_b() instanceof ItemUpgrade && !player.func_213453_ef()) {
            return this.interactUpgrade(world, pos, player, handIn, stack);
        }
        if (te.hasUpgrade((Item)Registration.LIQUID.get()) && hand.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent() && BlockSmeltingTileBase.isItemFuel(hand) && !player.func_213453_ef()) {
            FluidStack fluid = ((IFluidHandlerItem)hand.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).resolve().get()).getFluidInTank(1);
            FluidActionResult res = FluidUtil.tryEmptyContainer((ItemStack)hand, (IFluidHandler)((IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).resolve().get()), (int)1000, (PlayerEntity)player, (boolean)true);
            if (fluid != null && ForgeHooks.getBurnTime((ItemStack)hand) > 0 && res.isSuccess()) {
                world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187633_N, SoundCategory.PLAYERS, 0.6f, 0.8f);
                if (!player.func_184812_l_()) {
                    player.func_184611_a(handIn, res.result);
                }
            }
        } else {
            this.interactWith(world, pos, player);
        }
        return ActionResultType.SUCCESS;
    }

    private ActionResultType interactUpgrade(World world, BlockPos pos, PlayerEntity player, Hand handIn, ItemStack stack) {
        Item hand = player.func_184586_b(handIn).func_77973_b();
        if (!(hand instanceof ItemUpgrade)) {
            return ActionResultType.SUCCESS;
        }
        if (!(world.func_175625_s(pos) instanceof BlockForgeTileBase)) {
            return ActionResultType.SUCCESS;
        }
        BlockForgeTileBase te = (BlockForgeTileBase)world.func_175625_s(pos);
        ItemStack newStack = new ItemStack((IItemProvider)stack.func_77973_b(), 1);
        newStack.func_77982_d(stack.func_77978_p());
        if (hand instanceof ItemUpgradeLiquidFuel || hand instanceof ItemUpgradeEnergyFuel) {
            if (!te.func_70301_a(10).func_190926_b() && !player.func_184812_l_()) {
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (ItemStack)te.func_70301_a(10));
            }
            te.func_70299_a(10, newStack);
            world.func_184133_a(null, te.func_174877_v(), SoundEvents.field_187725_r, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!player.func_184812_l_()) {
                player.func_184586_b(handIn).func_190918_g(1);
            }
        } else {
            if (te.hasUpgradeType((ItemUpgrade)stack.func_77973_b())) {
                if (!player.func_184812_l_()) {
                    InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (ItemStack)te.getUpgradeTypeSlotItem((ItemUpgrade)stack.func_77973_b()));
                } else {
                    te.getUpgradeTypeSlotItem((ItemUpgrade)stack.func_77973_b()).func_190918_g(1);
                }
            }
            for (int upg : te.UPGRADES()) {
                if (!te.IisItemValidForSlot(upg, stack) || stack.func_190926_b() || upg == 10) continue;
                if (!te.func_70301_a(upg).func_190926_b() && upg == te.UPGRADES()[te.UPGRADES().length - 1]) {
                    if (!player.func_184812_l_()) {
                        InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (ItemStack)te.func_70301_a(upg));
                    } else {
                        te.func_70301_a(upg).func_190918_g(1);
                    }
                }
                if (!te.func_70301_a(upg).func_190926_b()) continue;
                te.func_70299_a(upg, newStack);
                if (!player.func_184812_l_()) {
                    player.func_184586_b(handIn).func_190918_g(1);
                }
                world.func_184133_a(null, te.func_174877_v(), SoundEvents.field_187725_r, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
        te.onUpdateSent();
        return ActionResultType.SUCCESS;
    }

    private void interactWith(World world, BlockPos pos, PlayerEntity player) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof INamedContainerProvider) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)tileEntity), (BlockPos)tileEntity.func_174877_v());
            player.func_195066_a(Stats.field_188061_aa);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q)).booleanValue()) {
            if (world.func_175625_s(pos) == null) {
                return;
            }
            if (!(world.func_175625_s(pos) instanceof BlockForgeTileBase)) {
                return;
            }
            BlockForgeTileBase tile = (BlockForgeTileBase)world.func_175625_s(pos);
            if (state.func_177229_b((Property)BlockStateProperties.field_208155_H) == Direction.UP) {
                double d0 = (double)pos.func_177958_n() + 0.5;
                double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0;
                double d2 = (double)pos.func_177952_p() + 0.5;
                double d4 = rand.nextDouble() * 0.6 - 0.3;
                if (rand.nextDouble() < 0.1) {
                    world.func_184134_a(d0, (double)pos.func_177956_o(), d2, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                }
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0 - 0.52, d1, d2 + d4, 0.0, 0.0, 0.0);
                world.func_195594_a((IParticleData)ParticleTypes.field_239811_B_, d0 - 0.52, d1, d2 + d4, 0.0, 0.0, 0.0);
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0 + 0.52, d1, d2 + d4, 0.0, 0.0, 0.0);
                world.func_195594_a((IParticleData)ParticleTypes.field_239811_B_, d0 + 0.52, d1, d2 + d4, 0.0, 0.0, 0.0);
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0 + d4, d1, d2 - 0.52, 0.0, 0.0, 0.0);
                world.func_195594_a((IParticleData)ParticleTypes.field_239811_B_, d0 + d4, d1, d2 - 0.52, 0.0, 0.0, 0.0);
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0 + d4, d1, d2 + 0.52, 0.0, 0.0, 0.0);
                world.func_195594_a((IParticleData)ParticleTypes.field_239811_B_, d0 + d4, d1, d2 + 0.52, 0.0, 0.0, 0.0);
            } else {
                for (int l = 0; l < 3; ++l) {
                    double d0 = (float)pos.func_177958_n() + rand.nextFloat();
                    double d1 = (float)pos.func_177956_o() + rand.nextFloat();
                    double d2 = (float)pos.func_177952_p() + rand.nextFloat();
                    int i1 = rand.nextInt(2) * 2 - 1;
                    double d3 = ((double)rand.nextFloat() - 0.5) * 0.2;
                    double d4 = ((double)rand.nextFloat() - 0.5) * 0.2;
                    double d5 = ((double)rand.nextFloat() - 0.5) * 0.2;
                    world.func_195594_a((IParticleData)ParticleTypes.field_197617_j, d0, d1, d2, d3, d4, d5);
                }
            }
        }
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState oldState, boolean p_196243_5_) {
        if (state.func_177230_c() != oldState.func_177230_c()) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof BlockForgeTileBase) {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((BlockForgeTileBase)te));
                ((BlockForgeTileBase)te).grantStoredRecipeExperience(world, Vector3d.func_237489_a_((Vector3i)pos));
                world.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, world, pos, oldState, p_196243_5_);
        }
    }

    public int getComparatorInputOverride(BlockState state, World world, BlockPos pos) {
        return Container.func_94526_b((IInventory)((IInventory)world.func_175625_s(pos)));
    }

    public BlockState func_185499_a(BlockState p_185499_1_, Rotation p_185499_2_) {
        if (p_185499_2_ == Rotation.CLOCKWISE_90 || p_185499_2_ == Rotation.COUNTERCLOCKWISE_90) {
            if ((Direction)p_185499_1_.func_177229_b((Property)FACING) == Direction.WEST || (Direction)p_185499_1_.func_177229_b((Property)FACING) == Direction.EAST) {
                return (BlockState)p_185499_1_.func_206870_a((Property)FACING, (Comparable)Direction.UP);
            }
            if ((Direction)p_185499_1_.func_177229_b((Property)FACING) == Direction.UP || (Direction)p_185499_1_.func_177229_b((Property)FACING) == Direction.DOWN) {
                return (BlockState)p_185499_1_.func_206870_a((Property)FACING, (Comparable)Direction.WEST);
            }
        }
        return p_185499_1_;
    }

    private int calculateOutput(World worldIn, BlockPos pos, BlockState state) {
        BlockForgeTileBase tile = (BlockForgeTileBase)worldIn.func_175625_s(pos);
        int i = this.getComparatorInputOverride(state, worldIn, pos);
        if (tile != null) {
            int j = tile.furnaceSettings.get(9);
            return tile.furnaceSettings.get(8) == 4 ? Math.max(i - j, 0) : i;
        }
        return 0;
    }

    public boolean func_149744_f(BlockState p_149744_1_) {
        return true;
    }

    public int func_180656_a(BlockState p_180656_1_, IBlockReader p_180656_2_, BlockPos p_180656_3_, Direction p_180656_4_) {
        return super.func_176211_b(p_180656_1_, p_180656_2_, p_180656_3_, p_180656_4_);
    }

    public int func_176211_b(BlockState blockState, IBlockReader world, BlockPos pos, Direction direction) {
        BlockForgeTileBase furnace = (BlockForgeTileBase)world.func_175625_s(pos);
        if (furnace != null) {
            int mode = furnace.furnaceSettings.get(8);
            if (mode == 0) {
                return 0;
            }
            if (mode == 1) {
                return 0;
            }
            if (mode == 2) {
                return 0;
            }
            return this.calculateOutput(furnace.func_145831_w(), pos, blockState);
        }
        return 0;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208155_H, WATERLOGGED, BlockStateProperties.field_208190_q, COLORED, SHOW_ORIENTATION});
    }
}

