/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.cfup;

import java.io.InputStreamReader;
import java.net.URL;
import java.util.Properties;
import wily.betterfurnaces.BetterFurnacesReforged;
import wily.betterfurnaces.cfup.UpCheck;

public class UpThreadCheck
extends Thread {
    public UpThreadCheck() {
        this.setName("BetterFurnaces Update Checker");
        this.setDaemon(true);
        this.start();
    }

    @Override
    public void run() {
        BetterFurnacesReforged.LOGGER.info("Starting Update Check...");
        try {
            URL newestURL = new URL("https://raw.githubusercontent.com/Wilyicaro/BetterFurnacesReforged/1.16.5/update/versions.properties");
            Properties updateProperties = new Properties();
            updateProperties.load(new InputStreamReader(newestURL.openStream()));
            String currentMcVersion = "1.16.5";
            String newestVersionProp = updateProperties.getProperty(currentMcVersion);
            UpCheck.updateVersionInt = Integer.parseInt(newestVersionProp);
            UpCheck.updateVersionString = currentMcVersion + "-release" + newestVersionProp;
            int clientVersion = Integer.parseInt("173");
            if (UpCheck.updateVersionInt > clientVersion) {
                UpCheck.needsUpdateNotify = true;
            }
            BetterFurnacesReforged.LOGGER.info("Update Check done!");
        }
        catch (Exception e) {
            BetterFurnacesReforged.LOGGER.error("Update Check failed!", (Throwable)e);
            UpCheck.checkFailed = true;
        }
        if (!UpCheck.checkFailed) {
            if (UpCheck.needsUpdateNotify) {
                BetterFurnacesReforged.LOGGER.info("There is an update for the BetterFurnaces mod!");
                BetterFurnacesReforged.LOGGER.info("Current Version: 1.16.5-173, newest Version: " + UpCheck.updateVersionString + "!");
                BetterFurnacesReforged.LOGGER.info("Download at https://www.curseforge.com/minecraft/mc-mods/better-furnaces-reforged/");
            } else {
                BetterFurnacesReforged.LOGGER.info("Now BetterFurnaces is updated!");
            }
        }
        UpCheck.threadFinished = true;
    }
}

