/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.container;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import wily.betterfurnaces.container.SlotFuel;
import wily.betterfurnaces.container.SlotInput;
import wily.betterfurnaces.container.SlotOutput;
import wily.betterfurnaces.container.SlotUpgrade;
import wily.betterfurnaces.tileentity.BlockSmeltingTileBase;
import wily.betterfurnaces.util.DirectionUtil;

public abstract class BlockFurnaceContainerBase
extends Container {
    public BlockSmeltingTileBase te;
    protected IIntArray fields;
    protected PlayerEntity playerEntity;
    protected IItemHandler playerInventory;
    protected final World world;
    private IRecipeType<? extends AbstractCookingRecipe> recipeType;

    public BlockFurnaceContainerBase(ContainerType<?> containerType, int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player) {
        this(containerType, windowId, world, pos, playerInventory, player, (IIntArray)new IntArray(5));
    }

    public BlockFurnaceContainerBase(ContainerType<?> containerType, int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player, IIntArray fields) {
        super(containerType, windowId);
        this.te = (BlockSmeltingTileBase)world.func_175625_s(pos);
        this.recipeType = this.te.recipeType;
        this.playerEntity = player;
        this.playerInventory = new InvWrapper((IInventory)playerInventory);
        this.world = playerInventory.field_70458_d.field_70170_p;
        this.fields = fields;
        this.func_216961_a(this.fields);
        this.func_75146_a(new SlotInput((IInventory)this.te, 0, 54, 18));
        this.func_75146_a(new SlotFuel((IInventory)this.te, 1, 54, 54));
        this.func_75146_a(new SlotOutput(this.playerEntity, (IInventory)this.te, 2, 116, 35));
        this.func_75146_a(new SlotUpgrade((IInventory)this.te, 3, 8, 18));
        this.func_75146_a(new SlotUpgrade((IInventory)this.te, 4, 8, 36));
        this.func_75146_a(new SlotUpgrade((IInventory)this.te, 5, 8, 54));
        this.layoutPlayerInventorySlots(8, 84);
        BlockFurnaceContainerBase.func_216962_a((IInventory)this.te, (int)6);
        BlockFurnaceContainerBase.func_216959_a((IIntArray)this.fields, (int)5);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean showInventoryButtons() {
        return this.te.fields.func_221476_a(4) == 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getRedstoneMode() {
        return this.te.getRedstoneSetting();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getComSub() {
        return this.te.getRedstoneComSub();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean getAutoInput() {
        return this.te.getAutoInput() == 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean getAutoOutput() {
        return this.te.getAutoOutput() == 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent getTooltip(int index) {
        switch (this.te.furnaceSettings.get(index)) {
            case 1: {
                return new TranslationTextComponent("tooltip.betterfurnacesreforged.gui_input");
            }
            case 2: {
                return new TranslationTextComponent("tooltip.betterfurnacesreforged.gui_output");
            }
            case 3: {
                return new TranslationTextComponent("tooltip.betterfurnacesreforged.gui_input_output");
            }
            case 4: {
                return new TranslationTextComponent("tooltip.betterfurnacesreforged.gui_fuel");
            }
        }
        return new TranslationTextComponent("tooltip.betterfurnacesreforged.gui_none");
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSettingTop() {
        return this.te.getSettingTop();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSettingBottom() {
        return this.te.getSettingBottom();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSettingFront() {
        return this.te.getSettingFront();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSettingBack() {
        return this.te.getSettingBack();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSettingLeft() {
        return this.te.getSettingLeft();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSettingRight() {
        return this.te.getSettingRight();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getIndexFront() {
        return this.te.getIndexFront();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getIndexBack() {
        return this.te.getIndexBack();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getIndexLeft() {
        return this.te.getIndexLeft();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getIndexRight() {
        return this.te.getIndexRight();
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockPos getPos() {
        return this.te.func_174877_v();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCookScaled(int pixels) {
        int i = this.fields.func_221476_a(2);
        int j = this.fields.func_221476_a(3);
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBurnLeftScaled(int pixels) {
        int i = this.fields.func_221476_a(1);
        if (i == 0) {
            i = 200;
        }
        return this.fields.func_221476_a(0) * pixels / i;
    }

    public int getFluidStoredScaled(int pixels, boolean isXp) {
        Direction facing = null;
        if (isXp) {
            facing = DirectionUtil.fromId(this.te.getIndexFront());
        }
        int cur = ((IFluidHandler)this.te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing).resolve().get()).getFluidInTank(0).getAmount();
        int max = ((IFluidHandler)this.te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing).resolve().get()).getTankCapacity(0);
        return cur * pixels / max;
    }

    public FluidStack getFluidStackStored(boolean isXp) {
        Direction facing = null;
        if (isXp) {
            facing = DirectionUtil.fromId(this.te.getIndexFront());
        }
        return ((IFluidHandler)this.te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing).resolve().get()).getFluidInTank(0);
    }

    public int getEnergyStoredScaled(int pixels) {
        int cur = ((IEnergyStorage)this.te.getCapability(CapabilityEnergy.ENERGY, null).resolve().get()).getEnergyStored();
        int max = ((IEnergyStorage)this.te.getCapability(CapabilityEnergy.ENERGY, null).resolve().get()).getMaxEnergyStored();
        return cur * pixels / max;
    }

    public int getEnergyStored() {
        return ((IEnergyStorage)this.te.getCapability(CapabilityEnergy.ENERGY, null).resolve().get()).getEnergyStored();
    }

    public int getEnergyMaxStored() {
        return ((IEnergyStorage)this.te.getCapability(CapabilityEnergy.ENERGY, null).resolve().get()).getMaxEnergyStored();
    }

    public int BurnTimeGet() {
        return this.fields.func_221476_a(0);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < 6) {
                if (!this.func_75135_a(itemstack1, 6, this.field_75151_b.size(), true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (!this.func_75135_a(itemstack1, 0, 6, false)) {
                if (index < 33 ? !this.func_75135_a(itemstack1, 33, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 6, 33, false)) {
                    return ItemStack.field_190927_a;
                }
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    protected boolean hasRecipe(ItemStack stack) {
        ItemStack upgrade = (ItemStack)this.func_75138_a().get(3);
        if (this.recipeType != IRecipeType.field_222150_b) {
            this.recipeType = IRecipeType.field_222150_b;
        }
        return this.world.func_199532_z().func_215371_a(this.recipeType, (IInventory)new Inventory(new ItemStack[]{stack}), this.world).isPresent();
    }
}

