/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.Item;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import wily.betterfurnaces.blocks.BlockForgeBase;
import wily.betterfurnaces.container.BlockForgeContainerBase;
import wily.betterfurnaces.init.Registration;
import wily.betterfurnaces.items.ItemUpgrade;
import wily.betterfurnaces.items.ItemUpgradeFactory;
import wily.betterfurnaces.network.Messages;
import wily.betterfurnaces.network.PacketOrientationButton;
import wily.betterfurnaces.network.PacketSettingsButton;
import wily.betterfurnaces.network.PacketShowSettingsButton;
import wily.betterfurnaces.util.FluidRenderUtil;
import wily.betterfurnaces.util.StringHelper;

@OnlyIn(value=Dist.CLIENT)
public abstract class BlockForgeScreenBase<T extends BlockForgeContainerBase>
extends ContainerScreen<T> {
    public ResourceLocation GUI = new ResourceLocation("betterfurnacesreforged:textures/container/forge_gui.png");
    public static final ResourceLocation WIDGETS = new ResourceLocation("betterfurnacesreforged:textures/container/widgets.png");
    PlayerInventory playerInv;
    ITextComponent name;
    public boolean add_button;
    public boolean sub_button;

    private boolean storedFactoryUpgradeType(int type) {
        if (((BlockForgeContainerBase)this.func_212873_a_()).te.hasUpgradeType((ItemUpgrade)Registration.FACTORY.get())) {
            ItemUpgradeFactory stack = (ItemUpgradeFactory)((BlockForgeContainerBase)this.func_212873_a_()).te.getUpgradeTypeSlotItem((ItemUpgrade)Registration.FACTORY.get()).func_77973_b();
            if (type == 1) {
                return stack.canInput;
            }
            if (type == 2) {
                return stack.canOutput;
            }
            if (type == 3) {
                return stack.pipeSide;
            }
            if (type == 4) {
                return stack.redstoneSignal;
            }
        }
        return false;
    }

    public int getXSize() {
        return 176;
    }

    public int getYSize() {
        return 206;
    }

    public int getGuiLeft() {
        return (this.field_230708_k_ - this.getXSize()) / 2;
    }

    public int getGuiTop() {
        return (this.field_230709_l_ - this.getYSize()) / 2;
    }

    public BlockForgeScreenBase(T t, PlayerInventory inv, ITextComponent name) {
        super(t, inv, name);
        this.playerInv = inv;
        this.name = name;
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrix);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrix, mouseX, mouseY);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
    }

    protected void func_230451_b_(MatrixStack matrix, int mouseX, int mouseY) {
        ITextComponent invname = this.playerInv.func_145748_c_();
        int actualMouseX = mouseX - (this.field_230708_k_ - this.getXSize()) / 2;
        int actualMouseY = mouseY - (this.field_230709_l_ - this.getYSize()) / 2;
        this.field_230706_i_.field_71466_p.func_243248_b(matrix, invname, (float)(this.getXSize() / 2 - this.field_230706_i_.field_71466_p.func_78256_a(invname.getString()) / 2), (float)(this.getYSize() - 112), 0x404040);
        this.field_230706_i_.field_71466_p.func_243248_b(matrix, this.name, (float)(7 + this.getXSize() / 2 - this.field_230706_i_.field_71466_p.func_78256_a(this.name.getString()) / 2), 26.0f, 0x404040);
        if (((BlockForgeContainerBase)this.func_212873_a_()).te.hasUpgrade((Item)Registration.LIQUID.get()) && mouseX > this.getGuiLeft() + 26 && mouseX < this.getGuiLeft() + 45 && mouseY > this.getGuiTop() + 98 && mouseY < this.getGuiTop() + 128) {
            this.func_238652_a_(matrix, (ITextComponent)new StringTextComponent(((BlockForgeContainerBase)this.func_212873_a_()).getFluidStackStored(false).getDisplayName().getString() + ": " + ((BlockForgeContainerBase)this.func_212873_a_()).getFluidStackStored(false).getAmount() + " mB"), actualMouseX, actualMouseY);
        }
        if (((BlockForgeContainerBase)this.func_212873_a_()).te.hasUpgrade((Item)Registration.ENERGY.get()) && mouseX > this.getGuiLeft() + 8 && mouseX < this.getGuiLeft() + 24 && mouseY > this.getGuiTop() + 62 && mouseY < this.getGuiTop() + 96) {
            this.func_238652_a_(matrix, (ITextComponent)new StringTextComponent(((BlockForgeContainerBase)this.func_212873_a_()).getEnergyStored() / 1000 + " kFE/" + ((BlockForgeContainerBase)this.func_212873_a_()).getEnergyMaxStored() / 1000 + "kFE"), actualMouseX, actualMouseY);
        }
        if (((BlockForgeContainerBase)this.func_212873_a_()).te.hasUpgrade((Item)Registration.XP.get()) && mouseX > this.getGuiLeft() + 126 && mouseX < this.getGuiLeft() + 142 && mouseY > this.getGuiTop() + 102 && mouseY < this.getGuiTop() + 118) {
            this.func_238652_a_(matrix, (ITextComponent)new StringTextComponent(((BlockForgeContainerBase)this.func_212873_a_()).getFluidStackStored(true).getDisplayName().getString() + ": " + ((BlockForgeContainerBase)this.func_212873_a_()).getFluidStackStored(true).getAmount() + " mB"), actualMouseX, actualMouseY);
        }
        this.addTooltips(matrix, actualMouseX, actualMouseY);
    }

    private void addTooltips(MatrixStack matrix, int mouseX, int mouseY) {
        if (!((BlockForgeContainerBase)this.func_212873_a_()).showInventoryButtons()) {
            if (mouseX >= 7 && mouseX <= 24 && mouseY >= 44 && mouseY <= 57) {
                this.func_238652_a_(matrix, (ITextComponent)new TranslationTextComponent("tooltip.betterfurnacesreforged.gui_open"), mouseX, mouseY);
            }
        } else {
            if (this.storedFactoryUpgradeType(3)) {
                ArrayList list;
                if (mouseX >= 7 && mouseX <= 24 && mouseY >= 44 && mouseY <= 57) {
                    this.func_243308_b(matrix, StringHelper.getShiftInfoGui(), mouseX, mouseY);
                } else if (mouseX >= -15 && mouseX <= -2 && mouseY >= 58 && mouseY <= 71) {
                    this.func_238652_a_(matrix, (ITextComponent)new TranslationTextComponent("tooltip.betterfurnacesreforged.gui_show_orientation"), mouseX, mouseY);
                } else if (mouseX >= -47 && mouseX <= -34 && mouseY >= 58 && mouseY <= 71) {
                    if (this.storedFactoryUpgradeType(1)) {
                        list = Lists.newArrayList();
                        list.add(new TranslationTextComponent("tooltip.betterfurnacesreforged.gui_auto_input"));
                        list.add(new StringTextComponent("" + ((BlockForgeContainerBase)this.func_212873_a_()).getAutoInput()));
                        this.func_243308_b(matrix, list, mouseX, mouseY);
                    }
                } else if (mouseX >= -31 && mouseX <= -18 && mouseY >= 58 && mouseY <= 71) {
                    if (this.storedFactoryUpgradeType(2)) {
                        list = Lists.newArrayList();
                        list.add(new TranslationTextComponent("tooltip.betterfurnacesreforged.gui_auto_output"));
                        list.add(new StringTextComponent("" + ((BlockForgeContainerBase)this.func_212873_a_()).getAutoOutput()));
                        this.func_243308_b(matrix, list, mouseX, mouseY);
                    }
                } else if (mouseX >= -31 && mouseX <= -18 && mouseY >= 74 && mouseY <= 87) {
                    list = Lists.newArrayList();
                    list.add(new TranslationTextComponent("tooltip.betterfurnacesreforged.gui_top"));
                    list.add(((BlockForgeContainerBase)this.func_212873_a_()).getTooltip(((BlockForgeContainerBase)this.func_212873_a_()).te.getIndexTop()));
                    this.func_243308_b(matrix, list, mouseX, mouseY);
                } else if (mouseX >= -31 && mouseX <= -18 && mouseY >= 102 && mouseY <= 115) {
                    list = Lists.newArrayList();
                    list.add(new TranslationTextComponent("tooltip.betterfurnacesreforged.gui_bottom"));
                    list.add(((BlockForgeContainerBase)this.func_212873_a_()).getTooltip(((BlockForgeContainerBase)this.func_212873_a_()).te.getIndexBottom()));
                    this.func_243308_b(matrix, list, mouseX, mouseY);
                } else if (mouseX >= -31 && mouseX <= -18 && mouseY >= 88 && mouseY <= 101) {
                    list = Lists.newArrayList();
                    if (BlockForgeScreenBase.isShiftKeyDown()) {
                        list.add(new TranslationTextComponent("tooltip.betterfurnacesreforged.gui_reset"));
                    } else {
                        list.add(new TranslationTextComponent("tooltip.betterfurnacesreforged.gui_front"));
                        list.add(((BlockForgeContainerBase)this.func_212873_a_()).getTooltip(((BlockForgeContainerBase)this.func_212873_a_()).getIndexFront()));
                    }
                    this.func_243308_b(matrix, list, mouseX, mouseY);
                } else if (mouseX >= -45 && mouseX <= -32 && mouseY >= 88 && mouseY <= 101) {
                    list = Lists.newArrayList();
                    list.add(new TranslationTextComponent("tooltip.betterfurnacesreforged.gui_left"));
                    list.add(((BlockForgeContainerBase)this.func_212873_a_()).getTooltip(((BlockForgeContainerBase)this.func_212873_a_()).getIndexLeft()));
                    this.func_243308_b(matrix, list, mouseX, mouseY);
                } else if (mouseX >= -17 && mouseX <= -4 && mouseY >= 88 && mouseY <= 101) {
                    list = Lists.newArrayList();
                    list.add(new TranslationTextComponent("tooltip.betterfurnacesreforged.gui_right"));
                    list.add(((BlockForgeContainerBase)this.func_212873_a_()).getTooltip(((BlockForgeContainerBase)this.func_212873_a_()).getIndexRight()));
                    this.func_243308_b(matrix, list, mouseX, mouseY);
                } else if (mouseX >= -45 && mouseX <= -32 && mouseY >= 102 && mouseY <= 115) {
                    list = Lists.newArrayList();
                    list.add(new TranslationTextComponent("tooltip.betterfurnacesreforged.gui_back"));
                    list.add(((BlockForgeContainerBase)this.func_212873_a_()).getTooltip(((BlockForgeContainerBase)this.func_212873_a_()).getIndexBack()));
                    this.func_243308_b(matrix, list, mouseX, mouseY);
                }
            }
            if (this.storedFactoryUpgradeType(4)) {
                if (((BlockForgeContainerBase)this.func_212873_a_()).showInventoryButtons() && ((BlockForgeContainerBase)this.func_212873_a_()).getRedstoneMode() == 4) {
                    int comSub = ((BlockForgeContainerBase)this.func_212873_a_()).getComSub();
                    int i = comSub > 9 ? 28 : 31;
                    this.field_230706_i_.field_71466_p.func_243248_b(matrix, (ITextComponent)new StringTextComponent("" + comSub), (float)(i - 42), 118.0f, TextFormatting.WHITE.func_211163_e().intValue());
                }
                if (mouseX >= -47 && mouseX <= -34 && mouseY >= 118 && mouseY <= 131) {
                    ArrayList list = Lists.newArrayList();
                    list.add(new TranslationTextComponent("tooltip.betterfurnacesreforged.gui_redstone_ignored"));
                    this.func_243308_b(matrix, list, mouseX, mouseY);
                } else if (mouseX >= -31 && mouseX <= -18 && mouseY >= 118 && mouseY <= 131) {
                    ArrayList list = Lists.newArrayList();
                    if (BlockForgeScreenBase.isShiftKeyDown()) {
                        list.add(new TranslationTextComponent("tooltip.betterfurnacesreforged.gui_redstone_low"));
                    } else {
                        list.add(new TranslationTextComponent("tooltip.betterfurnacesreforged.gui_redstone_high"));
                    }
                    this.func_243308_b(matrix, list, mouseX, mouseY);
                } else if (mouseX >= -15 && mouseX <= -2 && mouseY >= 118 && mouseY <= 131) {
                    ArrayList list = Lists.newArrayList();
                    list.add(new TranslationTextComponent("tooltip.betterfurnacesreforged.gui_redstone_comparator"));
                    this.func_243308_b(matrix, list, mouseX, mouseY);
                } else if (mouseX >= -47 && mouseX <= -34 && mouseY >= 134 && mouseY <= 147) {
                    ArrayList list = Lists.newArrayList();
                    list.add(new TranslationTextComponent("tooltip.betterfurnacesreforged.gui_redstone_comparator_sub"));
                    this.func_243308_b(matrix, list, mouseX, mouseY);
                }
            }
        }
    }

    protected void func_230450_a_(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        FluidStack fluid;
        int i;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(this.GUI);
        int relX = (this.field_230708_k_ - this.getXSize()) / 2;
        int relY = (this.field_230709_l_ - this.getYSize()) / 2;
        this.func_238474_b_(matrix, relX, relY, 0, 0, this.getXSize(), this.getYSize());
        if (((BlockForgeContainerBase)this.func_212873_a_()).BurnTimeGet() > 0) {
            i = ((BlockForgeContainerBase)this.func_212873_a_()).getBurnLeftScaled(13);
            this.func_238474_b_(matrix, this.getGuiLeft() + 28, this.getGuiTop() + 93 - i, 176, 12 - i, 14, i + 1);
            this.func_238474_b_(matrix, this.getGuiLeft() + 46, this.getGuiTop() + 93 - i, 176, 12 - i, 14, i + 1);
            this.func_238474_b_(matrix, this.getGuiLeft() + 64, this.getGuiTop() + 93 - i, 176, 12 - i, 14, i + 1);
        }
        i = ((BlockForgeContainerBase)this.func_212873_a_()).getCookScaled(24);
        this.func_238474_b_(matrix, this.getGuiLeft() + 80, this.getGuiTop() + 80, 176, 14, i + 1, 16);
        if (((BlockForgeContainerBase)this.func_212873_a_()).te.hasUpgrade((Item)Registration.ENERGY.get())) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(WIDGETS);
            i = ((BlockForgeContainerBase)this.func_212873_a_()).getEnergyStoredScaled(34);
            this.func_238474_b_(matrix, this.getGuiLeft() + 8, this.getGuiTop() + 62, 240, 0, 16, 34);
            this.func_238474_b_(matrix, this.getGuiLeft() + 8, this.getGuiTop() + 62, 240, 34, 16, 34 - i);
        }
        if (((BlockForgeContainerBase)this.func_212873_a_()).te.hasUpgrade((Item)Registration.LIQUID.get())) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(WIDGETS);
            this.func_238474_b_(matrix, this.getGuiLeft() + 26, this.getGuiTop() + 98, 192, 38, 20, 22);
            fluid = ((BlockForgeContainerBase)this.func_212873_a_()).getFluidStackStored(false);
            i = ((BlockForgeContainerBase)this.func_212873_a_()).getFluidStoredScaled(21, false);
            if (i > 0) {
                TextureAtlasSprite fluidSprite = (TextureAtlasSprite)this.field_230706_i_.func_228015_a_(PlayerContainer.field_226615_c_).apply(fluid.getFluid().getAttributes().getStillTexture(fluid));
                this.field_230706_i_.func_110434_K().func_110577_a(fluidSprite.func_229241_m_().func_229223_g_());
                BlockForgeScreenBase.func_238470_a_((MatrixStack)matrix, (int)(this.getGuiLeft() + 26), (int)(this.getGuiTop() + 98), (int)this.func_230927_p_(), (int)20, (int)22, (TextureAtlasSprite)fluidSprite);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(WIDGETS);
                this.func_238474_b_(matrix, this.getGuiLeft() + 26, this.getGuiTop() + 98, 192, 38, 20, 22 - i);
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(WIDGETS);
            this.func_238474_b_(matrix, this.getGuiLeft() + 26, this.getGuiTop() + 98, 192, 16, 20, 22);
        }
        if (((BlockForgeContainerBase)this.func_212873_a_()).te.hasUpgrade((Item)Registration.XP.get())) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(WIDGETS);
            this.func_238474_b_(matrix, this.getGuiLeft() + 126, this.getGuiTop() + 102, 208, 0, 16, 16);
            fluid = ((BlockForgeContainerBase)this.func_212873_a_()).getFluidStackStored(true);
            i = ((BlockForgeContainerBase)this.func_212873_a_()).getFluidStoredScaled(16, true);
            if (i > 0) {
                FluidRenderUtil.renderTiledFluid(matrix, this, 126, 102, 16, 16, fluid, false);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(WIDGETS);
                this.func_238474_b_(matrix, this.getGuiLeft() + 126, this.getGuiTop() + 102, 208, 0, 16, 16 - i);
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(WIDGETS);
            this.func_238474_b_(matrix, this.getGuiLeft() + 126, this.getGuiTop() + 102, 192, 0, 16, 16);
        }
        if (((BlockForgeContainerBase)this.func_212873_a_()).te.hasUpgradeType((ItemUpgrade)Registration.FACTORY.get())) {
            this.field_230706_i_.func_110434_K().func_110577_a(WIDGETS);
            int actualMouseX = mouseX - (this.field_230708_k_ - this.getXSize()) / 2;
            int actualMouseY = mouseY - (this.field_230709_l_ - this.getYSize()) / 2;
            this.addInventoryButtons(matrix, actualMouseX, actualMouseY);
            if (this.storedFactoryUpgradeType(4)) {
                this.addRedstoneButtons(matrix, actualMouseX, actualMouseY);
            }
        }
    }

    private void addRedstoneButtons(MatrixStack matrix, int mouseX, int mouseY) {
        if (((BlockForgeContainerBase)this.func_212873_a_()).showInventoryButtons()) {
            this.blitRedstone(matrix);
            if (((BlockForgeContainerBase)this.func_212873_a_()).getRedstoneMode() == 4) {
                int comSub = ((BlockForgeContainerBase)this.func_212873_a_()).getComSub();
                boolean flag = BlockForgeScreenBase.isShiftKeyDown();
                if (flag) {
                    if (comSub > 0) {
                        this.sub_button = true;
                        if (mouseX >= -31 && mouseX <= -18 && mouseY >= 86 && mouseY <= 147) {
                            this.func_238474_b_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 134, 14, 0, 14, 14);
                        } else {
                            this.func_238474_b_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 134, 0, 0, 14, 14);
                        }
                    } else {
                        this.sub_button = false;
                        this.func_238474_b_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 134, 28, 0, 14, 14);
                    }
                } else if (comSub < 15) {
                    this.add_button = true;
                    if (mouseX >= -31 && mouseX <= -18 && mouseY >= 134 && mouseY <= 147) {
                        this.func_238474_b_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 134, 14, 14, 14, 14);
                    } else {
                        this.func_238474_b_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 134, 0, 14, 14, 14);
                    }
                } else {
                    this.add_button = false;
                    this.func_238474_b_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 134, 28, 14, 14, 14);
                }
            }
        }
    }

    private void addInventoryButtons(MatrixStack matrix, int mouseX, int mouseY) {
        if (!((BlockForgeContainerBase)this.func_212873_a_()).showInventoryButtons()) {
            this.func_238474_b_(matrix, this.getGuiLeft() + 7, this.getGuiTop() + 44, 0, 28, 18, 14);
            if (mouseX >= 7 && mouseX <= 24 && mouseY >= 44 && mouseY <= 57) {
                this.func_238474_b_(matrix, this.getGuiLeft() + 7, this.getGuiTop() + 44, 18, 28, 18, 14);
            }
        } else if (((BlockForgeContainerBase)this.func_212873_a_()).showInventoryButtons()) {
            this.func_238474_b_(matrix, this.getGuiLeft() + 7, this.getGuiTop() + 44, 18, 28, 18, 14);
            this.func_238474_b_(matrix, this.getGuiLeft() - 53, this.getGuiTop() + 52, 0, 47, 59, 107);
            if (this.storedFactoryUpgradeType(1)) {
                this.func_238474_b_(matrix, this.getGuiLeft() - 47, this.getGuiTop() + 58, 56, 157, 14, 14);
                if (mouseX >= -47 && mouseX <= -34 && mouseY >= 58 && mouseY <= 71 || ((BlockForgeContainerBase)this.func_212873_a_()).getAutoInput()) {
                    this.func_238474_b_(matrix, this.getGuiLeft() - 47, this.getGuiTop() + 58, 0, 189, 14, 14);
                }
            }
            if (this.storedFactoryUpgradeType(2)) {
                this.func_238474_b_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 58, 70, 157, 14, 14);
                if (mouseX >= -31 && mouseX <= -18 && mouseY >= 58 && mouseY <= 71 || ((BlockForgeContainerBase)this.func_212873_a_()).getAutoOutput()) {
                    this.func_238474_b_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 58, 14, 189, 14, 14);
                }
            }
            if (this.storedFactoryUpgradeType(3)) {
                this.func_238474_b_(matrix, this.getGuiLeft() - 15, this.getGuiTop() + 58, 168, 189, 14, 14);
                if (mouseX >= -15 && mouseX <= -2 && mouseY >= 58 && mouseY <= 71 || ((Boolean)((BlockForgeContainerBase)this.func_212873_a_()).te.func_195044_w().func_177229_b((Property)BlockForgeBase.SHOW_ORIENTATION)).booleanValue()) {
                    this.func_238474_b_(matrix, this.getGuiLeft() - 15, this.getGuiTop() + 58, 182, 189, 14, 14);
                }
                this.blitIO(matrix);
            }
        }
    }

    private void blitRedstone(MatrixStack matrix) {
        int setting;
        boolean flag = BlockForgeScreenBase.isShiftKeyDown();
        this.func_238474_b_(matrix, this.getGuiLeft() - 47, this.getGuiTop() + 118, 28, 203, 14, 14);
        this.func_238474_b_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 118, 42, 203, 14, 14);
        this.func_238474_b_(matrix, this.getGuiLeft() - 15, this.getGuiTop() + 118, 56, 203, 14, 14);
        this.func_238474_b_(matrix, this.getGuiLeft() - 47, this.getGuiTop() + 134, 70, 203, 14, 14);
        if (flag) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 118, 84, 189, 14, 14);
        }
        if ((setting = ((BlockForgeContainerBase)this.func_212873_a_()).getRedstoneMode()) == 0) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 47, this.getGuiTop() + 118, 28, 189, 14, 14);
        } else if (setting == 1 && !flag) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 118, 42, 189, 14, 14);
        } else if (setting == 2) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 118, 98, 189, 14, 14);
        } else if (setting == 3) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 15, this.getGuiTop() + 118, 56, 189, 14, 14);
        } else if (setting == 4) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 47, this.getGuiTop() + 134, 70, 189, 14, 14);
        }
    }

    private void blitIO(MatrixStack matrix) {
        int[] settings = new int[]{0, 0, 0, 0, 0, 0};
        int setting = ((BlockForgeContainerBase)this.func_212873_a_()).getSettingTop();
        if (setting == 0) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 74, 84, 157, 14, 14);
        } else if (setting == 1) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 74, 0, 157, 14, 14);
        } else if (setting == 2) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 74, 14, 157, 14, 14);
        } else if (setting == 3) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 74, 28, 157, 14, 14);
        } else if (setting == 4) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 74, 42, 157, 14, 14);
        }
        settings[((BlockForgeContainerBase)this.func_212873_a_()).te.getIndexTop()] = setting;
        setting = ((BlockForgeContainerBase)this.func_212873_a_()).getSettingBottom();
        if (setting == 0) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 102, 84, 157, 14, 14);
        } else if (setting == 1) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 102, 0, 157, 14, 14);
        } else if (setting == 2) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 102, 14, 157, 14, 14);
        } else if (setting == 3) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 102, 28, 157, 14, 14);
        } else if (setting == 4) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 102, 42, 157, 14, 14);
        }
        settings[((BlockForgeContainerBase)this.func_212873_a_()).te.getIndexBottom()] = setting;
        setting = ((BlockForgeContainerBase)this.func_212873_a_()).getSettingFront();
        if (setting == 0) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 88, 84, 157, 14, 14);
        } else if (setting == 1) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 88, 0, 157, 14, 14);
        } else if (setting == 2) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 88, 14, 157, 14, 14);
        } else if (setting == 3) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 88, 28, 157, 14, 14);
        } else if (setting == 4) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 88, 42, 157, 14, 14);
        }
        settings[((BlockForgeContainerBase)this.func_212873_a_()).getIndexFront()] = setting;
        setting = ((BlockForgeContainerBase)this.func_212873_a_()).getSettingBack();
        if (setting == 0) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 45, this.getGuiTop() + 102, 84, 157, 14, 14);
        } else if (setting == 1) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 45, this.getGuiTop() + 102, 0, 157, 14, 14);
        } else if (setting == 2) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 45, this.getGuiTop() + 102, 14, 157, 14, 14);
        } else if (setting == 3) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 45, this.getGuiTop() + 102, 28, 157, 14, 14);
        } else if (setting == 4) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 45, this.getGuiTop() + 102, 42, 157, 14, 14);
        }
        settings[((BlockForgeContainerBase)this.func_212873_a_()).getIndexBack()] = setting;
        setting = ((BlockForgeContainerBase)this.func_212873_a_()).getSettingLeft();
        if (setting == 0) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 45, this.getGuiTop() + 88, 84, 157, 14, 14);
        } else if (setting == 1) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 45, this.getGuiTop() + 88, 0, 157, 14, 14);
        } else if (setting == 2) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 45, this.getGuiTop() + 88, 14, 157, 14, 14);
        } else if (setting == 3) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 45, this.getGuiTop() + 88, 28, 157, 14, 14);
        } else if (setting == 4) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 45, this.getGuiTop() + 88, 42, 157, 14, 14);
        }
        settings[((BlockForgeContainerBase)this.func_212873_a_()).getIndexLeft()] = setting;
        setting = ((BlockForgeContainerBase)this.func_212873_a_()).getSettingRight();
        if (setting == 0) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 17, this.getGuiTop() + 88, 84, 157, 14, 14);
        } else if (setting == 1) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 17, this.getGuiTop() + 88, 0, 157, 14, 14);
        } else if (setting == 2) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 17, this.getGuiTop() + 88, 14, 157, 14, 14);
        } else if (setting == 3) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 17, this.getGuiTop() + 88, 28, 157, 14, 14);
        } else if (setting == 4) {
            this.func_238474_b_(matrix, this.getGuiLeft() - 17, this.getGuiTop() + 88, 42, 157, 14, 14);
        }
        settings[((BlockForgeContainerBase)this.func_212873_a_()).getIndexRight()] = setting;
        boolean input = false;
        boolean output = false;
        boolean both = false;
        boolean fuel = false;
        for (int set : settings) {
            if (set == 1) {
                input = true;
                continue;
            }
            if (set == 2) {
                output = true;
                continue;
            }
            if (set == 3) {
                both = true;
                continue;
            }
            if (set != 4) continue;
            fuel = true;
        }
        if (input || both) {
            this.func_238474_b_(matrix, this.getGuiLeft() + 26, this.getGuiTop() + 61, 0, 171, 18, 18);
            this.func_238474_b_(matrix, this.getGuiLeft() + 44, this.getGuiTop() + 61, 0, 171, 18, 18);
            this.func_238474_b_(matrix, this.getGuiLeft() + 62, this.getGuiTop() + 61, 0, 171, 18, 18);
        }
        if (output || both) {
            this.func_238474_b_(matrix, this.getGuiLeft() + 103, this.getGuiTop() + 75, 0, 229, 62, 26);
        }
        if (fuel) {
            this.func_238474_b_(matrix, this.getGuiLeft() + 7, this.getGuiTop() + 99, 18, 171, 18, 18);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        double actualMouseX = mouseX - (double)((this.field_230708_k_ - this.getXSize()) / 2);
        double actualMouseY = mouseY - (double)((this.field_230709_l_ - this.getYSize()) / 2);
        if (this.storedFactoryUpgradeType(4)) {
            this.mouseClickedRedstoneButtons(actualMouseX, actualMouseY);
        }
        this.mouseClickedInventoryButtons(button, actualMouseX, actualMouseY);
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public void mouseClickedInventoryButtons(int button, double mouseX, double mouseY) {
        boolean flag;
        boolean bl = flag = button == 1;
        if (!((BlockForgeContainerBase)this.func_212873_a_()).showInventoryButtons()) {
            if (mouseX >= 7.0 && mouseX <= 24.0 && mouseY >= 44.0 && mouseY <= 57.0) {
                Messages.INSTANCE.sendToServer((Object)new PacketShowSettingsButton(((BlockForgeContainerBase)this.func_212873_a_()).getPos(), 1));
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            }
        } else {
            if (mouseX >= 7.0 && mouseX <= 24.0 && mouseY >= 44.0 && mouseY <= 57.0) {
                Messages.INSTANCE.sendToServer((Object)new PacketShowSettingsButton(((BlockForgeContainerBase)this.func_212873_a_()).getPos(), 0));
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            }
            if (this.storedFactoryUpgradeType(3)) {
                if (mouseX >= -15.0 && mouseX <= -2.0 && mouseY >= 58.0 && mouseY <= 71.0) {
                    if (!((Boolean)((BlockForgeContainerBase)this.func_212873_a_()).te.func_195044_w().func_177229_b((Property)BlockForgeBase.SHOW_ORIENTATION)).booleanValue()) {
                        Messages.INSTANCE.sendToServer((Object)new PacketOrientationButton(((BlockForgeContainerBase)this.func_212873_a_()).getPos(), true));
                        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)SoundEvents.field_187909_gi, (float)0.6f, (float)0.3f));
                    } else {
                        Messages.INSTANCE.sendToServer((Object)new PacketOrientationButton(((BlockForgeContainerBase)this.func_212873_a_()).getPos(), false));
                        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)SoundEvents.field_187909_gi, (float)0.6f, (float)0.3f));
                    }
                }
                if (mouseX >= -47.0 && mouseX <= -34.0 && mouseY >= 58.0 && mouseY <= 71.0) {
                    if (this.storedFactoryUpgradeType(1)) {
                        if (!((BlockForgeContainerBase)this.func_212873_a_()).getAutoInput()) {
                            Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockForgeContainerBase)this.func_212873_a_()).getPos(), 6, 1));
                            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)SoundEvents.field_187909_gi, (float)0.6f, (float)0.3f));
                        } else {
                            Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockForgeContainerBase)this.func_212873_a_()).getPos(), 6, 0));
                            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)SoundEvents.field_187909_gi, (float)0.6f, (float)0.3f));
                        }
                    }
                } else if (mouseX >= -31.0 && mouseX <= -18.0 && mouseY >= 58.0 && mouseY <= 71.0 && this.storedFactoryUpgradeType(2)) {
                    if (!((BlockForgeContainerBase)this.func_212873_a_()).getAutoOutput()) {
                        Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockForgeContainerBase)this.func_212873_a_()).getPos(), 7, 1));
                        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)SoundEvents.field_187909_gi, (float)0.6f, (float)0.3f));
                    } else {
                        Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockForgeContainerBase)this.func_212873_a_()).getPos(), 7, 0));
                        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)SoundEvents.field_187909_gi, (float)0.6f, (float)0.3f));
                    }
                }
                if (mouseX >= -31.0 && mouseX <= -18.0 && mouseY >= 74.0 && mouseY <= 87.0) {
                    if (flag) {
                        this.sendToServerInverted(((BlockForgeContainerBase)this.func_212873_a_()).getSettingTop(), ((BlockForgeContainerBase)this.func_212873_a_()).te.getIndexTop());
                    } else {
                        this.sendToServer(((BlockForgeContainerBase)this.func_212873_a_()).getSettingTop(), ((BlockForgeContainerBase)this.func_212873_a_()).te.getIndexTop());
                    }
                } else if (mouseX >= -31.0 && mouseX <= -18.0 && mouseY >= 102.0 && mouseY <= 115.0) {
                    if (flag) {
                        this.sendToServerInverted(((BlockForgeContainerBase)this.func_212873_a_()).getSettingBottom(), ((BlockForgeContainerBase)this.func_212873_a_()).te.getIndexBottom());
                    } else {
                        this.sendToServer(((BlockForgeContainerBase)this.func_212873_a_()).getSettingBottom(), ((BlockForgeContainerBase)this.func_212873_a_()).te.getIndexBottom());
                    }
                } else if (mouseX >= -31.0 && mouseX <= -18.0 && mouseY >= 88.0 && mouseY <= 101.0) {
                    if (BlockForgeScreenBase.isShiftKeyDown()) {
                        Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockForgeContainerBase)this.func_212873_a_()).getPos(), 0, 0));
                        Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockForgeContainerBase)this.func_212873_a_()).getPos(), 1, 0));
                        Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockForgeContainerBase)this.func_212873_a_()).getPos(), 2, 0));
                        Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockForgeContainerBase)this.func_212873_a_()).getPos(), 3, 0));
                        Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockForgeContainerBase)this.func_212873_a_()).getPos(), 4, 0));
                        Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockForgeContainerBase)this.func_212873_a_()).getPos(), 5, 0));
                        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)SoundEvents.field_187909_gi, (float)0.8f, (float)0.3f));
                    } else if (flag) {
                        this.sendToServerInverted(((BlockForgeContainerBase)this.func_212873_a_()).getSettingFront(), ((BlockForgeContainerBase)this.func_212873_a_()).getIndexFront());
                    } else {
                        this.sendToServer(((BlockForgeContainerBase)this.func_212873_a_()).getSettingFront(), ((BlockForgeContainerBase)this.func_212873_a_()).getIndexFront());
                    }
                } else if (mouseX >= -45.0 && mouseX <= -32.0 && mouseY >= 102.0 && mouseY <= 115.0) {
                    if (flag) {
                        this.sendToServerInverted(((BlockForgeContainerBase)this.func_212873_a_()).getSettingBack(), ((BlockForgeContainerBase)this.func_212873_a_()).getIndexBack());
                    } else {
                        this.sendToServer(((BlockForgeContainerBase)this.func_212873_a_()).getSettingBack(), ((BlockForgeContainerBase)this.func_212873_a_()).getIndexBack());
                    }
                } else if (mouseX >= -45.0 && mouseX <= -32.0 && mouseY >= 88.0 && mouseY <= 101.0) {
                    if (flag) {
                        this.sendToServerInverted(((BlockForgeContainerBase)this.func_212873_a_()).getSettingLeft(), ((BlockForgeContainerBase)this.func_212873_a_()).getIndexLeft());
                    } else {
                        this.sendToServer(((BlockForgeContainerBase)this.func_212873_a_()).getSettingLeft(), ((BlockForgeContainerBase)this.func_212873_a_()).getIndexLeft());
                    }
                } else if (mouseX >= -17.0 && mouseX <= -4.0 && mouseY >= 88.0 && mouseY <= 101.0) {
                    if (flag) {
                        this.sendToServerInverted(((BlockForgeContainerBase)this.func_212873_a_()).getSettingRight(), ((BlockForgeContainerBase)this.func_212873_a_()).getIndexRight());
                    } else {
                        this.sendToServer(((BlockForgeContainerBase)this.func_212873_a_()).getSettingRight(), ((BlockForgeContainerBase)this.func_212873_a_()).getIndexRight());
                    }
                }
            }
        }
    }

    private void sendToServer(int setting, int index) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)SoundEvents.field_187909_gi, (float)0.6f, (float)0.3f));
        if (setting <= 0) {
            Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockForgeContainerBase)this.func_212873_a_()).getPos(), index, 1));
        } else if (setting == 1) {
            Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockForgeContainerBase)this.func_212873_a_()).getPos(), index, 2));
        } else if (setting == 2) {
            Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockForgeContainerBase)this.func_212873_a_()).getPos(), index, 3));
        } else if (setting == 3) {
            Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockForgeContainerBase)this.func_212873_a_()).getPos(), index, 4));
        } else if (setting >= 4) {
            Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockForgeContainerBase)this.func_212873_a_()).getPos(), index, 0));
        }
    }

    private void sendToServerInverted(int setting, int index) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)SoundEvents.field_187909_gi, (float)0.3f, (float)0.3f));
        if (setting <= 0) {
            Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockForgeContainerBase)this.func_212873_a_()).getPos(), index, 4));
        } else if (setting == 1) {
            Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockForgeContainerBase)this.func_212873_a_()).getPos(), index, 0));
        } else if (setting == 2) {
            Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockForgeContainerBase)this.func_212873_a_()).getPos(), index, 1));
        } else if (setting == 3) {
            Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockForgeContainerBase)this.func_212873_a_()).getPos(), index, 2));
        } else if (setting >= 4) {
            Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockForgeContainerBase)this.func_212873_a_()).getPos(), index, 3));
        }
    }

    public void mouseClickedRedstoneButtons(double mouseX, double mouseY) {
        if (((BlockForgeContainerBase)this.func_212873_a_()).showInventoryButtons()) {
            if (mouseX >= -31.0 && mouseX <= -18.0 && mouseY >= 132.0 && mouseY <= 147.0 && this.sub_button && BlockForgeScreenBase.isShiftKeyDown()) {
                Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockForgeContainerBase)this.func_212873_a_()).getPos(), 9, ((BlockForgeContainerBase)this.func_212873_a_()).getComSub() - 1));
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)SoundEvents.field_187909_gi, (float)0.3f, (float)0.3f));
            }
            if (mouseX >= -31.0 && mouseX <= -18.0 && mouseY >= 132.0 && mouseY <= 147.0 && this.add_button && !BlockForgeScreenBase.isShiftKeyDown()) {
                Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockForgeContainerBase)this.func_212873_a_()).getPos(), 9, ((BlockForgeContainerBase)this.func_212873_a_()).getComSub() + 1));
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)SoundEvents.field_187909_gi, (float)0.6f, (float)0.3f));
            }
            if (mouseX >= -47.0 && mouseX <= -34.0 && mouseY >= 118.0 && mouseY <= 131.0 && ((BlockForgeContainerBase)this.func_212873_a_()).getRedstoneMode() != 0) {
                Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockForgeContainerBase)this.func_212873_a_()).getPos(), 8, 0));
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)SoundEvents.field_187909_gi, (float)0.6f, (float)0.3f));
            }
            if (mouseX >= -31.0 && mouseX <= -18.0 && mouseY >= 118.0 && mouseY <= 131.0) {
                if (((BlockForgeContainerBase)this.func_212873_a_()).getRedstoneMode() != 1 && !BlockForgeScreenBase.isShiftKeyDown()) {
                    Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockForgeContainerBase)this.func_212873_a_()).getPos(), 8, 1));
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)SoundEvents.field_187909_gi, (float)0.6f, (float)0.3f));
                }
                if (((BlockForgeContainerBase)this.func_212873_a_()).getRedstoneMode() != 2 && BlockForgeScreenBase.isShiftKeyDown()) {
                    Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockForgeContainerBase)this.func_212873_a_()).getPos(), 8, 2));
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)SoundEvents.field_187909_gi, (float)0.6f, (float)0.3f));
                }
            }
            if (mouseX >= -15.0 && mouseX <= -2.0 && mouseY >= 118.0 && mouseY <= 131.0 && ((BlockForgeContainerBase)this.func_212873_a_()).getRedstoneMode() != 3) {
                Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockForgeContainerBase)this.func_212873_a_()).getPos(), 8, 3));
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)SoundEvents.field_187909_gi, (float)0.6f, (float)0.3f));
            }
            if (mouseX >= -47.0 && mouseX <= -34.0 && mouseY >= 134.0 && mouseY <= 147.0 && ((BlockForgeContainerBase)this.func_212873_a_()).getRedstoneMode() != 4) {
                Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockForgeContainerBase)this.func_212873_a_()).getPos(), 8, 4));
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)SoundEvents.field_187909_gi, (float)0.6f, (float)0.3f));
            }
        }
    }

    public static boolean isShiftKeyDown() {
        return BlockForgeScreenBase.isKeyDown(340) || BlockForgeScreenBase.isKeyDown(344);
    }

    public static boolean isKeyDown(int glfw) {
        InputMappings.Input key = InputMappings.Type.KEYSYM.func_197944_a(glfw);
        int keyCode = key.func_197937_c();
        if (keyCode != InputMappings.field_197958_a.func_197937_c()) {
            long windowHandle = Minecraft.func_71410_x().func_228018_at_().func_198092_i();
            try {
                if (key.func_197938_b() == InputMappings.Type.KEYSYM) {
                    return InputMappings.func_216506_a((long)windowHandle, (int)keyCode);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

