/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.items;

import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import wily.betterfurnaces.items.ItemUpgrade;
import wily.betterfurnaces.tileentity.FurnaceSettings;

public class ItemUpgradeFactory
extends ItemUpgrade {
    public boolean canOutput;
    public boolean canInput;
    public boolean pipeSide;
    public boolean redstoneSignal;
    FurnaceSettings furnaceSettings;

    public ItemUpgradeFactory(Item.Properties properties, String tooltip, boolean output, boolean input, boolean pipe, boolean redstone) {
        super(properties, 5, tooltip);
        this.canOutput = output;
        this.canInput = input;
        this.pipeSide = pipe;
        this.redstoneSignal = redstone;
        this.furnaceSettings = new FurnaceSettings(){};
    }

    public void func_77663_a(ItemStack stack, World world, Entity player, int slot, boolean selected) {
        super.func_77663_a(stack, world, player, slot, selected);
        CompoundNBT nbt = stack.func_196082_o();
        if (!(nbt.func_74764_b("Settings") && nbt.func_74764_b("AutoIO") && nbt.func_74764_b("Redstone"))) {
            this.placeConfig();
            this.furnaceSettings.write(nbt);
            stack.func_77982_d(nbt);
        }
    }

    public void placeConfig() {
        if (this.furnaceSettings != null) {
            this.furnaceSettings.set(0, 2);
            this.furnaceSettings.set(1, 1);
            for (Direction dir : Direction.values()) {
                if (dir == Direction.DOWN || dir == Direction.UP) continue;
                this.furnaceSettings.set(dir.ordinal(), 4);
            }
        }
    }
}

