/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import wily.betterfurnaces.init.Registration;
import wily.betterfurnaces.items.ItemUpgrade;
import wily.betterfurnaces.tileentity.BlockSmeltingTileBase;

public class PacketMouseClickPos {
    private int x;
    private int y;
    private int z;
    private int mouseX;
    private int mouseY;

    public PacketMouseClickPos(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.mouseX = buf.readInt();
        this.mouseY = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.mouseX);
        buf.writeInt(this.mouseY);
    }

    public PacketMouseClickPos(BlockPos pos, int mouseX, int mouseY) {
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.mouseX = mouseX;
        this.mouseY = mouseY;
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            BlockPos pos = new BlockPos(this.x, this.y, this.z);
            BlockSmeltingTileBase te = (BlockSmeltingTileBase)player.func_71121_q().func_175625_s(pos);
            if (player.field_70170_p.func_195588_v(pos) && te.hasUpgradeType((ItemUpgrade)Registration.FACTORY.get())) {
                ItemStack stack = te.getUpgradeTypeSlotItem((ItemUpgrade)Registration.FACTORY.get());
                CompoundNBT nbt = stack.func_196082_o();
                int[] mousePos = new int[]{this.mouseX, this.mouseY};
                nbt.func_74783_a("mousePos", mousePos);
                stack.func_77982_d(nbt);
                te.func_145831_w().markAndNotifyBlock(pos, player.func_71121_q().func_175726_f(pos), te.func_145831_w().func_180495_p(pos).func_177230_c().func_176223_P(), te.func_145831_w().func_180495_p(pos), 2, 3);
                te.func_70296_d();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

