/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.tileentity;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import wily.betterfurnaces.blocks.BlockCobblestoneGenerator;
import wily.betterfurnaces.init.Registration;
import wily.betterfurnaces.items.ItemUpgradeFuelEfficiency;
import wily.betterfurnaces.items.ItemUpgradeOreProcessing;
import wily.betterfurnaces.tileentity.TileEntityInventory;

public class BlockCobblestoneGeneratorTile
extends TileEntityInventory
implements ITickableTileEntity {
    public final IIntArray fields = new IIntArray(){

        public int func_221476_a(int index) {
            if (index == 0) {
                return BlockCobblestoneGeneratorTile.this.cobTime;
            }
            if (index == 1) {
                return BlockCobblestoneGeneratorTile.this.resultType;
            }
            if (index == 2) {
                return BlockCobblestoneGeneratorTile.this.actualCobTime;
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            if (index == 0) {
                BlockCobblestoneGeneratorTile.this.cobTime = value;
            }
            if (index == 1) {
                BlockCobblestoneGeneratorTile.this.resultType = value;
            }
            if (index == 2) {
                BlockCobblestoneGeneratorTile.this.actualCobTime = value;
            }
        }

        public int func_221478_a() {
            return 3;
        }
    };
    public final int[] provides = new int[Direction.values().length];
    private final int[] lastProvides = new int[this.provides.length];
    public static final int INPUT = 0;
    public static final int INPUT1 = 1;
    public static final int OUTPUT = 2;
    public static final int UPGRADE = 3;
    private int cobTime;
    private int actualCobTime = this.getCobTime();
    public int resultType = 1;
    LazyOptional<? extends IItemHandler>[] invHandlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST});

    @Override
    public int[] IgetSlotsForFace(Direction side) {
        return new int[0];
    }

    @Override
    public boolean IcanExtractItem(int index, ItemStack stack, Direction direction) {
        return false;
    }

    @Override
    public String IgetName() {
        return "block.betterfurnacesreforged.cobblestone_generator";
    }

    @Override
    public Container IcreateMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new BlockCobblestoneGeneratorContainer(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity, this.fields);
    }

    public BlockCobblestoneGeneratorTile(TileEntityType<?> tileentitytypeIn) {
        super(tileentitytypeIn, 5);
    }

    public void forceUpdateAllStates() {
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (((Integer)state.func_177229_b((Property)BlockCobblestoneGenerator.TYPE)).intValue() != this.cobGen()) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)BlockCobblestoneGenerator.TYPE, (Comparable)Integer.valueOf(this.cobGen())), 3);
        }
    }

    public void func_73660_a() {
        if (this.actualCobTime != this.getCobTime()) {
            this.actualCobTime = this.getCobTime();
        }
        if (this.cobTime > this.getCobTime()) {
            this.cobTime = this.getCobTime();
        }
        ItemStack output = this.func_70301_a(2);
        ItemStack upgrade = this.func_70301_a(3);
        ItemStack upgrade1 = this.func_70301_a(4);
        boolean can = output.func_190916_E() + 1 <= output.func_77976_d();
        boolean can1 = output.func_190926_b();
        boolean can3 = output.func_77973_b() == this.getResult().func_77973_b();
        this.forceUpdateAllStates();
        if ((this.cobGen() == 3 || this.cobTime > 0 && this.cobTime < this.actualCobTime) && (can && can3 || can1)) {
            ++this.cobTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (!output.func_190926_b()) {
                this.AutoIO();
            }
            if (this.cobTime >= this.getCobTime() && (can && can3 || can1)) {
                if (can1) {
                    this.inventory.set(2, (Object)this.getResult());
                    if (upgrade1.func_77973_b() instanceof ItemUpgradeOreProcessing) {
                        this.breakDurabilityItem(upgrade1);
                    }
                } else if (can && can3) {
                    output.func_190917_f(this.getResult().func_190916_E());
                    if (upgrade1.func_77973_b() instanceof ItemUpgradeOreProcessing) {
                        this.breakDurabilityItem(upgrade1);
                    }
                }
                this.func_145831_w().func_184133_a(null, this.func_174877_v(), SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.3f, 0.3f);
                this.cobTime = 0;
                this.breakDurabilityItem(upgrade);
                this.AutoIO();
            }
        }
    }

    protected int cobGen() {
        ItemStack input = (ItemStack)this.inventory.get(0);
        ItemStack input1 = (ItemStack)this.inventory.get(1);
        if (input.func_77973_b() == Items.field_151129_at.getItem() && input1.func_190926_b()) {
            return 1;
        }
        if (input1.func_77973_b() == Items.field_151131_as.getItem() && input.func_190926_b()) {
            return 2;
        }
        if (input.func_77973_b() == Items.field_151129_at.getItem() && input1.func_77973_b() == Items.field_151131_as.getItem()) {
            return 3;
        }
        return 0;
    }

    protected int getCobTime() {
        ItemStack upgrade = (ItemStack)this.inventory.get(3);
        if (upgrade.func_190926_b() && this.resultType < 3) {
            return 80;
        }
        if (upgrade.func_77973_b() instanceof ItemUpgradeFuelEfficiency && this.resultType < 3) {
            return 40;
        }
        if (upgrade.func_190926_b() && this.resultType == 3) {
            return 150;
        }
        if (upgrade.func_77973_b() instanceof ItemUpgradeFuelEfficiency && this.resultType == 3) {
            return 75;
        }
        if (upgrade.func_190926_b() && this.resultType == 4) {
            return 600;
        }
        if (upgrade.func_77973_b() instanceof ItemUpgradeFuelEfficiency && this.resultType == 4) {
            return 300;
        }
        return 0;
    }

    protected ItemStack getResult() {
        ItemStack result = this.resultType == 1 ? new ItemStack((IItemProvider)Items.field_221585_m) : (this.resultType == 2 ? new ItemStack((IItemProvider)Items.field_221574_b) : (this.resultType == 3 ? new ItemStack((IItemProvider)Items.field_234777_rA_) : (this.resultType == 4 ? new ItemStack((IItemProvider)Items.field_221655_bP) : new ItemStack((IItemProvider)Items.field_221585_m))));
        result.func_190920_e(this.getResultCount());
        return result;
    }

    protected int getResultCount() {
        ItemStack upgrade1 = this.func_70301_a(4);
        if (upgrade1.func_77973_b() instanceof ItemUpgradeOreProcessing) {
            return 2;
        }
        return 1;
    }

    protected boolean hasLava() {
        ItemStack input = (ItemStack)this.inventory.get(0);
        return input.func_77973_b() == Items.field_151131_as.getItem();
    }

    protected boolean hasWater() {
        ItemStack input = (ItemStack)this.inventory.get(1);
        return input.func_77973_b() == Items.field_151131_as.getItem();
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        ItemStackHelper.func_191283_b((CompoundNBT)tag, (NonNullList)this.inventory);
        this.cobTime = tag.func_74762_e("CobTime");
        this.resultType = tag.func_74762_e("ResultType");
        this.actualCobTime = tag.func_74762_e("ActualCobTime");
        super.func_230337_a_(state, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        ItemStackHelper.func_191282_a((CompoundNBT)tag, (NonNullList)this.inventory);
        tag.func_74768_a("CobTime", this.cobTime);
        tag.func_74768_a("ResultType", this.resultType);
        tag.func_74768_a("ActualCobTime", this.actualCobTime);
        return tag;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.func_145837_r() && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.DOWN) {
                return this.invHandlers[0].cast();
            }
            if (facing == Direction.UP) {
                return this.invHandlers[1].cast();
            }
            if (facing == Direction.NORTH) {
                return this.invHandlers[2].cast();
            }
            if (facing == Direction.SOUTH) {
                return this.invHandlers[3].cast();
            }
            if (facing == Direction.WEST) {
                return this.invHandlers[4].cast();
            }
            return this.invHandlers[5].cast();
        }
        return super.getCapability(capability, facing);
    }

    @Nonnull
    private ItemStack extractItemInternal(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack existing = this.func_70301_a(slot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
                this.func_70296_d();
                return existing;
            }
            return existing.func_77946_l();
        }
        if (!simulate) {
            this.func_70299_a(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
            this.func_70296_d();
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    private void AutoIO() {
        for (Direction dir : Direction.values()) {
            IItemHandler other;
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177971_a(dir.func_176730_m()));
            if (tile == null || tile == null || (other = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d()).map(other1 -> other1).orElse(null)) == null || other == null || this.func_70301_a(2).func_190926_b() || tile.func_195044_w().func_177230_c().getRegistryName().toString().contains("storagedrawers:")) continue;
            for (int i = 0; i < other.getSlots(); ++i) {
                ItemStack stack = this.extractItemInternal(2, this.func_70301_a(2).func_77976_d() - other.getStackInSlot(i).func_190916_E(), true);
                if (!other.isItemValid(i, stack) || !other.getStackInSlot(i).func_190926_b() && (!other.isItemValid(i, stack) || !ItemHandlerHelper.canItemStacksStack((ItemStack)other.getStackInSlot(i), (ItemStack)stack) || other.getStackInSlot(i).func_190916_E() + stack.func_190916_E() > other.getSlotLimit(i))) continue;
                other.insertItem(i, this.extractItemInternal(2, stack.func_190916_E(), false), false);
            }
        }
    }

    @Override
    public boolean IisItemValidForSlot(int index, ItemStack stack) {
        if (index == 2 || index == 3) {
            return false;
        }
        if (index == 0) {
            if (stack.func_190926_b()) {
                return false;
            }
            return this.hasLava();
        }
        if (index == 1) {
            if (stack.func_190926_b()) {
                return false;
            }
            return this.hasWater();
        }
        return false;
    }

    protected boolean doesNeedUpdateSend() {
        return !Arrays.equals(this.provides, this.lastProvides);
    }

    public void onUpdateSent() {
        System.arraycopy(this.provides, 0, this.lastProvides, 0, this.provides.length);
        this.field_145850_b.func_195593_d(this.field_174879_c, this.func_195044_w().func_177230_c());
    }

    public static class BlockCobblestoneGeneratorTileDefinition
    extends BlockCobblestoneGeneratorTile {
        public BlockCobblestoneGeneratorTileDefinition() {
            super((TileEntityType)Registration.COB_GENERATOR_TILE.get());
        }
    }

    public static class BlockCobblestoneGeneratorContainer
    extends wily.betterfurnaces.container.BlockCobblestoneGeneratorContainer {
        public BlockCobblestoneGeneratorContainer(int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player) {
            super((ContainerType)Registration.COB_GENERATOR_CONTAINER.get(), windowId, world, pos, playerInventory, player);
        }

        public BlockCobblestoneGeneratorContainer(int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player, IIntArray fields) {
            super((ContainerType)Registration.COB_GENERATOR_CONTAINER.get(), windowId, world, pos, playerInventory, player, fields);
        }
    }
}

