/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.tileentity;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import wily.betterfurnaces.container.BlockFuelVerifierContainer;
import wily.betterfurnaces.init.Registration;
import wily.betterfurnaces.tileentity.TileEntityInventory;

public class BlockFuelVerifierTile
extends TileEntityInventory
implements ITickableTileEntity {
    public final IIntArray fields = new IIntArray(){

        public int func_221476_a(int index) {
            if (index == 0) {
                return BlockFuelVerifierTile.this.burnTime;
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            BlockFuelVerifierTile.this.burnTime = value;
        }

        public int func_221478_a() {
            return 1;
        }
    };
    public final int[] provides = new int[Direction.values().length];
    private final int[] lastProvides = new int[this.provides.length];
    private int burnTime;
    LazyOptional<? extends IItemHandler>[] invHandlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST});

    @Override
    public int[] IgetSlotsForFace(Direction side) {
        return new int[0];
    }

    @Override
    public boolean IcanExtractItem(int index, ItemStack stack, Direction direction) {
        return false;
    }

    @Override
    public String IgetName() {
        return "block.betterfurnacesreforged.fuel_verifier";
    }

    @Override
    public Container IcreateMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new BlockFuelVerifierTileContainer(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity, this.fields);
    }

    public BlockFuelVerifierTile(TileEntityType<?> tileentitytypeIn) {
        super(tileentitytypeIn, 1);
    }

    public void func_73660_a() {
        ItemStack fuel = this.func_70301_a(0);
        if (!this.field_145850_b.field_72995_K) {
            this.burnTime = !fuel.func_190926_b() ? BlockFuelVerifierTile.getBurnTime(fuel) : 0;
        }
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        ItemStackHelper.func_191283_b((CompoundNBT)tag, (NonNullList)this.inventory);
        this.burnTime = tag.func_74762_e("BurnTime");
        super.func_230337_a_(state, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        ItemStackHelper.func_191282_a((CompoundNBT)tag, (NonNullList)this.inventory);
        tag.func_74768_a("BurnTime", this.burnTime);
        return tag;
    }

    protected static int getBurnTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        int ret = stack.getBurnTime();
        return ForgeEventFactory.getItemBurnTime((ItemStack)stack, (int)(ret == -1 ? AbstractFurnaceTileEntity.func_214001_f().getOrDefault(item, 0) : ret));
    }

    public static boolean isItemFuel(ItemStack stack) {
        return BlockFuelVerifierTile.getBurnTime(stack) > 0;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.func_145837_r() && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.DOWN) {
                return this.invHandlers[0].cast();
            }
            if (facing == Direction.UP) {
                return this.invHandlers[1].cast();
            }
            if (facing == Direction.NORTH) {
                return this.invHandlers[2].cast();
            }
            if (facing == Direction.SOUTH) {
                return this.invHandlers[3].cast();
            }
            if (facing == Direction.WEST) {
                return this.invHandlers[4].cast();
            }
            return this.invHandlers[5].cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean IisItemValidForSlot(int index, ItemStack stack) {
        if (index == 0) {
            return BlockFuelVerifierTile.isItemFuel(stack);
        }
        return false;
    }

    protected boolean doesNeedUpdateSend() {
        return !Arrays.equals(this.provides, this.lastProvides);
    }

    public void onUpdateSent() {
        System.arraycopy(this.provides, 0, this.lastProvides, 0, this.provides.length);
        this.field_145850_b.func_195593_d(this.field_174879_c, this.func_195044_w().func_177230_c());
    }

    public static class BlockFuelVerifierTileDefinition
    extends BlockFuelVerifierTile {
        public BlockFuelVerifierTileDefinition() {
            super((TileEntityType)Registration.FUEL_VERIFIER_TILE.get());
        }
    }

    public static class BlockFuelVerifierTileContainer
    extends BlockFuelVerifierContainer {
        public BlockFuelVerifierTileContainer(int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player) {
            super((ContainerType)Registration.FUEL_VERIFIER_CONTAINER.get(), windowId, world, pos, playerInventory, player);
        }

        public BlockFuelVerifierTileContainer(int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player, IIntArray fields) {
            super((ContainerType)Registration.FUEL_VERIFIER_CONTAINER.get(), windowId, world, pos, playerInventory, player, fields);
        }
    }
}

